/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.BaseDiffFromHistoryHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.util.HgUtil;

public class HgDiffFromHistoryHandler
extends BaseDiffFromHistoryHandler<HgFileRevision> {
    private static final Logger LOG = Logger.getInstance(HgDiffFromHistoryHandler.class);

    public HgDiffFromHistoryHandler(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "<init>"));
        }
        super(project);
    }

    @NotNull
    protected List<Change> getChangesBetweenRevisions(@NotNull FilePath path, @NotNull HgFileRevision rev1, @Nullable HgFileRevision rev2) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "getChangesBetweenRevisions"));
        }
        if (rev1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev1", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "getChangesBetweenRevisions"));
        }
        List<Change> list = this.executeDiff(path, rev1, rev2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "getChangesBetweenRevisions"));
        }
        return list;
    }

    @NotNull
    protected List<Change> getAffectedChanges(@NotNull FilePath path, @NotNull HgFileRevision rev) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "getAffectedChanges"));
        }
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "getAffectedChanges"));
        }
        List<Change> list = this.executeDiff(path, null, rev);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "getAffectedChanges"));
        }
        return list;
    }

    @NotNull
    protected String getPresentableName(@NotNull HgFileRevision revision) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "getPresentableName"));
        }
        String string = revision.getRevisionNumber().getChangeset();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    private List<Change> executeDiff(@NotNull FilePath path, @Nullable HgFileRevision rev1, @Nullable HgFileRevision rev2) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "executeDiff"));
        }
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path);
        LOG.assertTrue(root != null, (Object)("Repository is null for " + path));
        List<Change> list = HgUtil.getDiff(this.myProject, root, path, rev1 != null ? rev1.getRevisionNumber() : null, rev2 != null ? rev2.getRevisionNumber() : null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "executeDiff"));
        }
        return list;
    }
}

