/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.infos;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCandidateInfo
extends CandidateInfo {
    public static final RecursionGuard ourOverloadGuard = RecursionManager.createGuard((String)"overload.guard");
    public static final ThreadLocal<Map<PsiElement, CurrentCandidateProperties>> CURRENT_CANDIDATE = new ThreadLocal();
    @ApplicabilityLevelConstant
    private int myApplicabilityLevel;
    @ApplicabilityLevelConstant
    private int myPertinentApplicabilityLevel;
    private final PsiElement myArgumentList;
    private final PsiType[] myArgumentTypes;
    private final PsiType[] myTypeArguments;
    private PsiSubstitutor myCalcedSubstitutor;
    private String myInferenceError;
    private final LanguageLevel myLanguageLevel;

    public MethodCandidateInfo(@NotNull PsiElement candidate, PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiElement argumentList, PsiElement currFileContext, @Nullable PsiType[] argumentTypes, PsiType[] typeArguments) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/infos/MethodCandidateInfo", "<init>"));
        }
        this(candidate, substitutor, accessProblem, staticsProblem, argumentList, currFileContext, argumentTypes, typeArguments, PsiUtil.getLanguageLevel(argumentList));
    }

    public MethodCandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiElement argumentList, PsiElement currFileContext, @Nullable PsiType[] argumentTypes, PsiType[] typeArguments, @NotNull LanguageLevel languageLevel) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/infos/MethodCandidateInfo", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/infos/MethodCandidateInfo", "<init>"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/infos/MethodCandidateInfo", "<init>"));
        }
        super(candidate, substitutor, accessProblem, staticsProblem, currFileContext);
        this.myArgumentList = argumentList;
        this.myArgumentTypes = argumentTypes;
        this.myTypeArguments = typeArguments;
        this.myLanguageLevel = languageLevel;
    }

    public boolean isVarargs() {
        return false;
    }

    public boolean isApplicable() {
        return this.getPertinentApplicabilityLevel() != 1;
    }

    @ApplicabilityLevelConstant
    private int getApplicabilityLevelInner() {
        PsiType[] argumentTypes = this.getArgumentTypes();
        if (argumentTypes == null) {
            return 1;
        }
        int level = PsiUtil.getApplicabilityLevel(this.getElement(), this.getSubstitutor(), argumentTypes, this.myLanguageLevel);
        if (level > 1 && !this.isTypeArgumentsApplicable()) {
            level = 1;
        }
        return level;
    }

    @ApplicabilityLevelConstant
    public int getApplicabilityLevel() {
        if (this.myApplicabilityLevel == 0) {
            this.myApplicabilityLevel = this.getApplicabilityLevelInner();
        }
        return this.myApplicabilityLevel;
    }

    @ApplicabilityLevelConstant
    public int getPertinentApplicabilityLevel() {
        if (this.myPertinentApplicabilityLevel == 0) {
            this.myPertinentApplicabilityLevel = this.getPertinentApplicabilityLevelInner();
        }
        return this.myPertinentApplicabilityLevel;
    }

    public int getPertinentApplicabilityLevelInner() {
        if (this.myArgumentList == null || !PsiUtil.isLanguageLevel8OrHigher(this.myArgumentList)) {
            return this.getApplicabilityLevel();
        }
        final PsiMethod method = this.getElement();
        if (this.isToInferApplicability()) {
            if (!MethodCandidateInfo.isOverloadCheck()) {
                this.getSubstitutor(false);
            }
            if (this.myInferenceError != null || !this.isPotentiallyCompatible()) {
                return 1;
            }
            return this.isVarargs() ? 2 : 3;
        }
        final PsiSubstitutor substitutor = this.getSubstitutor(false);
        int level = this.computeForOverloadedCandidate(new Computable<Integer>(){

            public Integer compute() {
                PsiType[] argumentTypes = MethodCandidateInfo.this.getArgumentTypes();
                if (argumentTypes == null) {
                    return 1;
                }
                int level = PsiUtil.getApplicabilityLevel(method, substitutor, argumentTypes, MethodCandidateInfo.this.myLanguageLevel);
                if (!MethodCandidateInfo.this.isVarargs() && level < 3) {
                    return 1;
                }
                return level;
            }
        }, substitutor);
        if (level > 1 && !this.isTypeArgumentsApplicable(new Computable<PsiSubstitutor>(){

            public PsiSubstitutor compute() {
                return substitutor;
            }
        })) {
            level = 1;
        }
        return level;
    }

    public boolean isToInferApplicability() {
        return this.myTypeArguments == null && this.getElement().hasTypeParameters() && !this.isRawSubstitution();
    }

    public boolean isPotentiallyCompatible() {
        if (this.myArgumentList instanceof PsiExpressionList) {
            PsiMethod method = this.getElement();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiExpression[] expressions = ((PsiExpressionList)this.myArgumentList).getExpressions();
            if (!this.isVarargs() && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                if (expressions.length != parameters.length) {
                    return false;
                }
            } else {
                if (expressions.length < parameters.length - 1) {
                    return false;
                }
                if (parameters.length == 0 && expressions.length != parameters.length) {
                    return false;
                }
            }
            for (int i = 0; i < expressions.length; ++i) {
                PsiType formalParameterType;
                PsiExpression expression = expressions[i];
                PsiType psiType = formalParameterType = i < parameters.length ? parameters[i].getType() : parameters[parameters.length - 1].getType();
                if (formalParameterType instanceof PsiEllipsisType && this.isVarargs()) {
                    formalParameterType = ((PsiEllipsisType)formalParameterType).getComponentType();
                }
                if (MethodCandidateInfo.isPotentialCompatible(expression, this.getSiteSubstitutor().substitute(formalParameterType), method)) continue;
                return false;
            }
            if (method.hasTypeParameters() && this.myTypeArguments != null) {
                return method.getTypeParameters().length == this.myTypeArguments.length;
            }
        }
        return true;
    }

    private static boolean isPotentialCompatible(PsiExpression expression, PsiType formalType, PsiMethod method) {
        if (expression instanceof PsiFunctionalExpression) {
            PsiClass targetTypeParameter = PsiUtil.resolveClassInClassTypeOnly(formalType);
            if (targetTypeParameter instanceof PsiTypeParameter && method.equals(((PsiTypeParameter)targetTypeParameter).getOwner())) {
                return true;
            }
            if (!((PsiFunctionalExpression)expression).isPotentiallyCompatible(formalType)) {
                return false;
            }
        } else {
            if (expression instanceof PsiParenthesizedExpression) {
                return MethodCandidateInfo.isPotentialCompatible(((PsiParenthesizedExpression)expression).getExpression(), formalType, method);
            }
            if (expression instanceof PsiConditionalExpression) {
                return MethodCandidateInfo.isPotentialCompatible(((PsiConditionalExpression)expression).getThenExpression(), formalType, method) && MethodCandidateInfo.isPotentialCompatible(((PsiConditionalExpression)expression).getElseExpression(), formalType, method);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T computeForOverloadedCandidate(Computable<T> computable, PsiSubstitutor substitutor) {
        ConcurrentMap map = CURRENT_CANDIDATE.get();
        if (map == null) {
            map = ContainerUtil.createConcurrentWeakMap();
            CURRENT_CANDIDATE.set(map);
        }
        PsiElement argumentList = this.getMarkerList();
        CurrentCandidateProperties alreadyThere = map.put(argumentList, new CurrentCandidateProperties(this, substitutor, this.isVarargs(), true));
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            if (alreadyThere == null) {
                map.remove(argumentList);
            } else {
                map.put(argumentList, alreadyThere);
            }
        }
    }

    @NotNull
    public PsiSubstitutor getSiteSubstitutor() {
        PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
        if (this.myTypeArguments != null) {
            PsiMethod method = this.getElement();
            PsiTypeParameter[] typeParams = method.getTypeParameters();
            for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; ++i) {
                incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]);
            }
        }
        PsiSubstitutor psiSubstitutor = incompleteSubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "getSiteSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.getSubstitutor(true);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor(boolean includeReturnConstraint) {
        PsiSubstitutor substitutor = this.myCalcedSubstitutor;
        if (substitutor == null || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || MethodCandidateInfo.isOverloadCheck()) {
            if (includeReturnConstraint) {
                this.myInferenceError = null;
            }
            PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
            PsiMethod method = this.getElement();
            if (this.myTypeArguments == null) {
                RecursionGuard.StackStamp stackStamp = PsiDiamondType.ourDiamondGuard.markStack();
                PsiSubstitutor inferredSubstitutor = this.inferTypeArguments(DefaultParameterTypeInferencePolicy.INSTANCE, includeReturnConstraint);
                if (!stackStamp.mayCacheNow() || MethodCandidateInfo.isOverloadCheck() || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || this.getMarkerList() != null && PsiResolveHelper.ourGraphGuard.currentStack().contains(this.getMarkerList().getParent())) {
                    PsiSubstitutor psiSubstitutor = inferredSubstitutor;
                    if (psiSubstitutor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "getSubstitutor"));
                    }
                    return psiSubstitutor;
                }
                this.myCalcedSubstitutor = substitutor = inferredSubstitutor;
            } else {
                PsiTypeParameter[] typeParams = method.getTypeParameters();
                for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; ++i) {
                    incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]);
                }
                this.myCalcedSubstitutor = substitutor = incompleteSubstitutor;
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    public static boolean isOverloadCheck() {
        return !ourOverloadGuard.currentStack().isEmpty();
    }

    public boolean isTypeArgumentsApplicable() {
        return this.isTypeArgumentsApplicable(new Computable<PsiSubstitutor>(){

            public PsiSubstitutor compute() {
                return MethodCandidateInfo.this.getSubstitutor(false);
            }
        });
    }

    private boolean isTypeArgumentsApplicable(Computable<PsiSubstitutor> computable) {
        PsiMethod psiMethod = this.getElement();
        PsiTypeParameter[] typeParams = psiMethod.getTypeParameters();
        if (this.myTypeArguments != null && typeParams.length != this.myTypeArguments.length && !PsiUtil.isLanguageLevel7OrHigher(psiMethod)) {
            return typeParams.length == 0 && JavaVersionService.getInstance().isAtLeast(psiMethod, JavaSdkVersion.JDK_1_7);
        }
        return GenericsUtil.isTypeArgumentsApplicable(typeParams, (PsiSubstitutor)computable.compute(), this.getParent());
    }

    protected PsiElement getParent() {
        return this.myArgumentList != null ? this.myArgumentList.getParent() : null;
    }

    @Override
    public boolean isValidResult() {
        return super.isValidResult() && this.isApplicable();
    }

    @Override
    @NotNull
    public PsiMethod getElement() {
        PsiMethod psiMethod = (PsiMethod)super.getElement();
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "getElement"));
        }
        return psiMethod;
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, boolean includeReturnConstraint) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments(policy, this.myArgumentList instanceof PsiExpressionList ? ((PsiExpressionList)this.myArgumentList).getExpressions() : PsiExpression.EMPTY_ARRAY, includeReturnConstraint);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    public PsiSubstitutor inferSubstitutorFromArgs(@NotNull ParameterTypeInferencePolicy policy, PsiExpression[] arguments) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/infos/MethodCandidateInfo", "inferSubstitutorFromArgs"));
        }
        if (this.myTypeArguments == null) {
            return this.inferTypeArguments(policy, arguments, true);
        }
        return this.getSiteSubstitutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, @NotNull PsiExpression[] arguments, boolean includeReturnConstraint) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        ConcurrentMap map = CURRENT_CANDIDATE.get();
        if (map == null) {
            map = ContainerUtil.createConcurrentWeakMap();
            CURRENT_CANDIDATE.set(map);
        }
        PsiMethod method = this.getElement();
        PsiElement argumentList = this.getMarkerList();
        CurrentCandidateProperties alreadyThere = map.put(argumentList, new CurrentCandidateProperties(this, super.getSubstitutor(), policy.isVarargsIgnored() || this.isVarargs(), !includeReturnConstraint));
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        if (this.isRawSubstitution()) {
            PsiSubstitutor psiSubstitutor = JavaPsiFacade.getInstance(method.getProject()).getElementFactory().createRawSubstitutor(this.mySubstitutor, typeParameters);
            PsiSubstitutor psiSubstitutor2 = psiSubstitutor;
            if (psiSubstitutor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
            }
            return psiSubstitutor2;
        }
        PsiElement parent = this.getParent();
        if (parent == null) {
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            PsiSubstitutor psiSubstitutor3 = psiSubstitutor;
            if (psiSubstitutor3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
            }
            return psiSubstitutor3;
        }
        Project project = method.getProject();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance(project);
        PsiSubstitutor psiSubstitutor = javaPsiFacade.getResolveHelper().inferTypeArguments(typeParameters, method.getParameterList().getParameters(), arguments, this.mySubstitutor, parent, policy, this.myLanguageLevel);
        PsiSubstitutor psiSubstitutor4 = psiSubstitutor;
        if (psiSubstitutor4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        return psiSubstitutor4;
        finally {
            if (alreadyThere == null) {
                map.remove(argumentList);
            } else {
                map.put(argumentList, alreadyThere);
            }
        }
    }

    private boolean isRawSubstitution() {
        PsiClass containingClass;
        PsiMethod method = this.getElement();
        return !method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && PsiUtil.isRawSubstitutor(containingClass, this.mySubstitutor);
    }

    protected PsiElement getMarkerList() {
        return this.myArgumentList;
    }

    public boolean isInferencePossible() {
        return this.myArgumentList != null && this.myArgumentList.isValid();
    }

    public static CurrentCandidateProperties getCurrentMethod(PsiElement context) {
        Map<PsiElement, CurrentCandidateProperties> currentMethodCandidates = CURRENT_CANDIDATE.get();
        return currentMethodCandidates != null ? currentMethodCandidates.get(context) : null;
    }

    public static void updateSubstitutor(PsiElement context, PsiSubstitutor newSubstitutor) {
        CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod(context);
        if (candidateProperties != null) {
            candidateProperties.setSubstitutor(newSubstitutor);
        }
    }

    public PsiType[] getArgumentTypes() {
        return this.myArgumentTypes;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.isVarargs() == ((MethodCandidateInfo)o).isVarargs();
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.isVarargs() ? 1 : 0);
    }

    public void setInferenceError(String inferenceError) {
        this.myInferenceError = inferenceError;
    }

    public String getInferenceErrorMessage() {
        return this.myInferenceError;
    }

    public String getParentInferenceErrorMessage(PsiExpressionList list) {
        PsiElement parent;
        String errorMessage = this.getInferenceErrorMessage();
        while (errorMessage == null && (list = PsiTreeUtil.getParentOfType((PsiElement)list, PsiExpressionList.class, true)) != null && (parent = list.getParent()) instanceof PsiCallExpression) {
            JavaResolveResult resolveResult = ((PsiCallExpression)parent).resolveMethodGenerics();
            if (!(resolveResult instanceof MethodCandidateInfo)) continue;
            errorMessage = ((MethodCandidateInfo)resolveResult).getInferenceErrorMessage();
        }
        return errorMessage;
    }

    public CurrentCandidateProperties createProperties() {
        return new CurrentCandidateProperties(this, this.getSiteSubstitutor(), this.isVarargs(), false);
    }

    public static @interface ApplicabilityLevelConstant {
    }

    public static class ApplicabilityLevel {
        public static final int NOT_APPLICABLE = 1;
        public static final int VARARGS = 2;
        public static final int FIXED_ARITY = 3;
    }

    public static class CurrentCandidateProperties {
        private final MethodCandidateInfo myMethod;
        private PsiSubstitutor mySubstitutor;
        private boolean myVarargs;
        private boolean myApplicabilityCheck;

        private CurrentCandidateProperties(MethodCandidateInfo info, PsiSubstitutor substitutor, boolean varargs, boolean applicabilityCheck) {
            this.myMethod = info;
            this.mySubstitutor = substitutor;
            this.myVarargs = varargs;
            this.myApplicabilityCheck = applicabilityCheck;
        }

        public PsiMethod getMethod() {
            return this.myMethod.getElement();
        }

        public MethodCandidateInfo getInfo() {
            return this.myMethod;
        }

        public PsiSubstitutor getSubstitutor() {
            return this.mySubstitutor;
        }

        public void setSubstitutor(PsiSubstitutor substitutor) {
            this.mySubstitutor = substitutor;
        }

        public boolean isVarargs() {
            return this.myVarargs;
        }

        public void setVarargs(boolean varargs) {
            this.myVarargs = varargs;
        }

        public boolean isApplicabilityCheck() {
            return this.myApplicabilityCheck;
        }

        public void setApplicabilityCheck(boolean applicabilityCheck) {
            this.myApplicabilityCheck = applicabilityCheck;
        }
    }
}

