/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.serialization;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.load.kotlin.JvmNameResolver;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\f\u0010\u001e\u001a\u00020\u001f*\u00020\rH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u00020\u0012*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/codegen/serialization/JvmStringTable;", "Lorg/jetbrains/kotlin/serialization/StringTable;", "typeMapper", "Lorg/jetbrains/kotlin/codegen/state/JetTypeMapper;", "(Lorg/jetbrains/kotlin/codegen/state/JetTypeMapper;)V", "localNames", "Ljava/util/HashSet;", "", "map", "Ljava/util/HashMap;", "", "records", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/serialization/jvm/JvmProtoBuf$StringTableTypes$Record$Builder;", "strings", "getStrings", "()Ljava/util/ArrayList;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassId", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Lorg/jetbrains/kotlin/name/ClassId;", "getFqNameIndex", "descriptor", "getStringIndex", "string", "serializeTo", "", "output", "Ljava/io/OutputStream;", "isTrivial", "", "backend"})
public final class JvmStringTable
implements StringTable {
    @NotNull
    private final ArrayList<String> strings;
    private final ArrayList<JvmProtoBuf.StringTableTypes.Record.Builder> records;
    private final HashMap<String, Integer> map;
    private final HashSet<Integer> localNames;
    private final JetTypeMapper typeMapper;

    @NotNull
    public final ArrayList<String> getStrings() {
        return this.strings;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getStringIndex(@NotNull String string) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        Map $receiver$iv = this.map;
        Object value$iv = $receiver$iv.get(string);
        if (value$iv == null) {
            void $receiver$iv2;
            Integer n2 = this.strings.size();
            int $receiver = ((Number)$receiver$iv2).intValue();
            this.strings.add(string);
            JvmProtoBuf.StringTableTypes.Record.Builder lastRecord = (JvmProtoBuf.StringTableTypes.Record.Builder)CollectionsKt.lastOrNull((List)this.records);
            if (lastRecord != null && this.isTrivial(lastRecord)) {
                lastRecord.setRange(lastRecord.getRange() + 1);
            } else {
                this.records.add(JvmProtoBuf.StringTableTypes.Record.newBuilder());
            }
            Integer answer$iv = ((Number)$receiver$iv2).intValue();
            $receiver$iv.put(string, answer$iv);
            n = answer$iv;
        } else {
            void var3_3;
            n = var3_3;
        }
        return ((Number)n).intValue();
    }

    private final boolean isTrivial(JvmProtoBuf.StringTableTypes.Record.Builder $receiver) {
        return !$receiver.hasPredefinedIndex() && !$receiver.hasOperation() && $receiver.getSubstringIndexCount() == 0 && $receiver.getReplaceCharCount() == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getFqNameIndex(@NotNull ClassDescriptor descriptor2) {
        void value$iv;
        void key$iv;
        void $receiver$iv;
        Object predefinedIndex;
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (ErrorUtils.isError(descriptor2)) {
            throw (Throwable)new IllegalStateException("Cannot get FQ name of error class: " + descriptor2);
        }
        ClassId classId = this.getClassId(descriptor2);
        String string = classId.asString();
        Integer n = this.map.get(string);
        if (n != null) {
            void $receiver$iv2;
            Integer n2 = n;
            int recordedIndex = ((Number)$receiver$iv2).intValue();
            if (classId.isLocal() == this.localNames.contains(recordedIndex)) {
                return recordedIndex;
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        int index2 = this.strings.size();
        if (classId.isLocal()) {
            this.localNames.add(index2);
        }
        JvmProtoBuf.StringTableTypes.Record.Builder record2 = JvmProtoBuf.StringTableTypes.Record.newBuilder();
        if (classId.isLocal() || StringsKt.contains$default((CharSequence)string, (char)'$', (boolean)false, (int)2, null)) {
            this.strings.add(string);
        } else {
            String string2 = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"string");
            predefinedIndex = JvmNameResolver.Companion.getPredefinedStringIndex(string2);
            if (predefinedIndex != null) {
                record2.setPredefinedIndex(((Number)predefinedIndex).intValue());
                this.strings.add("");
            } else {
                record2.setOperation(JvmProtoBuf.StringTableTypes.Record.Operation.DESC_TO_CLASS_ID);
                this.strings.add("L" + StringsKt.replace$default((String)string, (char)'.', (char)'$', (boolean)false, (int)4, null) + ";");
            }
        }
        this.records.add(record2);
        predefinedIndex = this.map;
        String string3 = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"string");
        String $i$f$let = string3;
        Integer n3 = index2;
        $receiver$iv.put(key$iv, value$iv);
        return index2;
    }

    private final ClassId getClassId(ClassDescriptor $receiver) {
        ClassId classId;
        DeclarationDescriptor container2 = $receiver.getContainingDeclaration();
        DeclarationDescriptor declarationDescriptor = container2;
        if (declarationDescriptor instanceof ClassDescriptor) {
            ClassId classId2 = this.getClassId((ClassDescriptor)container2).createNestedClassId($receiver.getName());
            classId = classId2;
            Intrinsics.checkExpressionValueIsNotNull((Object)classId2, (String)"container.classId.createNestedClassId(name)");
        } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            classId = new ClassId(((PackageFragmentDescriptor)container2).getFqName(), $receiver.getName());
        } else {
            FqName fqName2 = new FqName(StringsKt.replace$default((String)this.typeMapper.mapClass($receiver).getInternalName(), (char)'/', (char)'.', (boolean)false, (int)4, null));
            classId = new ClassId(fqName2.parent(), FqName.topLevel(fqName2.shortName()), true);
        }
        return classId;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serializeTo(@NotNull OutputStream output) {
        List list2;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        JvmProtoBuf.StringTableTypes.Builder receiver$iv = JvmProtoBuf.StringTableTypes.newBuilder();
        JvmProtoBuf.StringTableTypes.Builder $receiver = receiver$iv;
        Iterable iterable = this.records;
        JvmProtoBuf.StringTableTypes.Builder builder = $receiver;
        void var6_6 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JvmProtoBuf.StringTableTypes.Record.Builder builder2 = (JvmProtoBuf.StringTableTypes.Record.Builder)item$iv$iv;
            list2 = destination$iv$iv;
            JvmProtoBuf.StringTableTypes.Record record2 = it.build();
            list2.add(record2);
        }
        list2 = (List)destination$iv$iv;
        builder.addAllRecord(list2);
        $receiver.addAllLocalName((Iterable<? extends Integer>)this.localNames);
        $receiver.build().writeDelimitedTo(output);
    }

    public JvmStringTable(@NotNull JetTypeMapper typeMapper) {
        Intrinsics.checkParameterIsNotNull((Object)typeMapper, (String)"typeMapper");
        this.typeMapper = typeMapper;
        this.strings = new ArrayList();
        this.records = new ArrayList();
        this.map = new HashMap();
        this.localNames = new HashSet();
    }
}

