/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.highlighter.AnnotationPresentationInfo;
import org.jetbrains.kotlin.idea.highlighter.ElementAnnotator$WhenMappings;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.KotlinPsiCheckerKt;
import org.jetbrains.kotlin.idea.highlighter.KotlinSuppressableWarningProblemGroup;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0014\u0010\u0010\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011J\u001e\u0010\u0012\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ElementAnnotator;", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "shouldSuppressUnusedParameter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/lang/annotation/AnnotationHolder;Lkotlin/jvm/functions/Function1;)V", "registerDiagnosticAnnotations", "", "diagnostics", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "registerDiagnosticsAnnotations", "", "setUpAnnotations", "data", "Lorg/jetbrains/kotlin/idea/highlighter/AnnotationPresentationInfo;", "idea-analysis"})
final class ElementAnnotator {
    private final PsiElement element;
    private final AnnotationHolder holder;
    private final Function1<KtParameter, Boolean> shouldSuppressUnusedParameter;

    /*
     * WARNING - void declaration
     */
    public final void registerDiagnosticsAnnotations(@NotNull Collection<? extends Diagnostic> diagnostics) {
        void destination$iv$iv;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(diagnostics, (String)"diagnostics");
        Iterable $receiver$iv = diagnostics;
        Iterable iterable = $receiver$iv;
        Object object = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object2;
            void $receiver$iv$iv$iv;
            Diagnostic it = (Diagnostic)element$iv$iv;
            DiagnosticFactory<?> key$iv$iv = it.getFactory();
            void var10_9 = destination$iv$iv;
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        object = $receiver$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry group = element$iv = (Map.Entry)object.next();
            this.registerDiagnosticAnnotations((List)group.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerDiagnosticAnnotations(List<? extends Diagnostic> diagnostics) {
        AnnotationPresentationInfo annotationPresentationInfo;
        Unit unit;
        boolean bl;
        ProblemHighlightType factory2;
        Diagnostic diagnostic;
        block23: {
            void $receiver$iv;
            Iterable destination$iv$iv;
            Diagnostic it;
            void $receiver$iv$iv;
            Unit unit2;
            Collection $receiver$iv2 = diagnostics;
            boolean value$iv = !$receiver$iv2.isEmpty();
            if (_Assertions.ENABLED) {
                if (!value$iv) {
                    String message$iv$iv = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = Unit.INSTANCE;
            }
            Iterable $receiver$iv3 = diagnostics;
            Iterable $i$f$assert = $receiver$iv3;
            Collection $i$f$assert2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (Diagnostic)element$iv$iv;
                if (!it.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List validDiagnostics = (List)destination$iv$iv;
            if (validDiagnostics.isEmpty()) {
                return;
            }
            diagnostic = (Diagnostic)CollectionsKt.first(diagnostics);
            factory2 = diagnostic.getFactory();
            destination$iv$iv = diagnostics;
            for (Object element$iv : $receiver$iv) {
                it = (Diagnostic)element$iv;
                if (Intrinsics.areEqual((Object)it.getPsiElement(), (Object)this.element) && Intrinsics.areEqual(it.getFactory(), factory2)) continue;
                bl = false;
                break block23;
            }
            bl = true;
        }
        boolean $receiver$iv = bl;
        if (_Assertions.ENABLED) {
            void value$iv;
            if (value$iv == false) {
                String message$iv$iv = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        List<TextRange> ranges2 = diagnostic.getTextRanges();
        switch (ElementAnnotator$WhenMappings.$EnumSwitchMapping$0[factory2.getSeverity().ordinal()]) {
            case 1: {
                ProblemHighlightType problemHighlightType = factory2;
                if (CollectionsKt.contains((Iterable)((Iterable)Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS), problemHighlightType)) {
                    PsiElement psiElement2 = this.element;
                    if (psiElement2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
                    }
                    KtReferenceExpression referenceExpression = (KtReferenceExpression)psiElement2;
                    KtReference reference2 = ReferenceUtilKt.getMainReference(referenceExpression);
                    if (reference2 instanceof MultiRangeReference) {
                        List list2;
                        void destination$iv$iv;
                        void $receiver$iv$iv;
                        void $receiver$iv4;
                        AnnotationPresentationInfo annotationPresentationInfo2;
                        Iterable $i$f$all = ((MultiRangeReference)reference2).getRanges();
                        AnnotationPresentationInfo annotationPresentationInfo3 = annotationPresentationInfo2;
                        AnnotationPresentationInfo annotationPresentationInfo4 = annotationPresentationInfo2;
                        void $i$f$filter = $receiver$iv4;
                        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv4, (int)10));
                        for (Object item$iv$iv : $receiver$iv$iv) {
                            void it;
                            TextRange textRange = (TextRange)item$iv$iv;
                            list2 = destination$iv$iv;
                            TextRange textRange2 = it.shiftRight(referenceExpression.getTextOffset());
                            list2.add(textRange2);
                        }
                        list2 = (List)destination$iv$iv;
                        annotationPresentationInfo = annotationPresentationInfo4;
                        annotationPresentationInfo3(list2, null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, null, 10, null);
                        break;
                    }
                    List<TextRange> list3 = ranges2;
                    Intrinsics.checkExpressionValueIsNotNull(list3, (String)"ranges");
                    annotationPresentationInfo = new AnnotationPresentationInfo(list3, null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, null, 10, null);
                    break;
                }
                if (Intrinsics.areEqual(problemHighlightType, Errors.ILLEGAL_ESCAPE)) {
                    List<TextRange> list4 = ranges2;
                    Intrinsics.checkExpressionValueIsNotNull(list4, (String)"ranges");
                    annotationPresentationInfo = new AnnotationPresentationInfo(list4, null, null, KotlinHighlightingColors.INVALID_STRING_ESCAPE, 6, null);
                    break;
                }
                if (Intrinsics.areEqual(problemHighlightType, Errors.REDECLARATION)) {
                    annotationPresentationInfo = new AnnotationPresentationInfo(CollectionsKt.listOf((Object)CollectionsKt.first(diagnostic.getTextRanges())), "", null, null, 12, null);
                    break;
                }
                List<TextRange> list5 = ranges2;
                Intrinsics.checkExpressionValueIsNotNull(list5, (String)"ranges");
                annotationPresentationInfo = new AnnotationPresentationInfo(list5, null, Intrinsics.areEqual(factory2, Errors.INVISIBLE_REFERENCE) ? ProblemHighlightType.LIKE_UNKNOWN_SYMBOL : (ProblemHighlightType)null, null, 10, null);
                break;
            }
            case 2: {
                if (Intrinsics.areEqual(factory2, Errors.UNUSED_PARAMETER)) {
                    PsiElement psiElement3 = this.element;
                    if (psiElement3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameter");
                    }
                    if (((Boolean)this.shouldSuppressUnusedParameter.invoke((Object)((KtParameter)psiElement3))).booleanValue()) {
                        return;
                    }
                }
                List<TextRange> list6 = ranges2;
                Intrinsics.checkExpressionValueIsNotNull(list6, (String)"ranges");
                ProblemHighlightType problemHighlightType = CollectionsKt.contains((Iterable)((Iterable)Errors.UNUSED_ELEMENT_DIAGNOSTICS), factory2) ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : (ProblemHighlightType)null;
                TextAttributesKey textAttributesKey = Intrinsics.areEqual(factory2, Errors.DEPRECATION) ? CodeInsightColors.DEPRECATED_ATTRIBUTES : (TextAttributesKey)null;
                AnnotationPresentationInfo annotationPresentationInfo5 = new AnnotationPresentationInfo(list6, null, problemHighlightType, textAttributesKey, 2, null);
                annotationPresentationInfo = annotationPresentationInfo5;
                break;
            }
            case 3: {
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        AnnotationPresentationInfo presentationInfo = annotationPresentationInfo;
        this.setUpAnnotations(diagnostics, presentationInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final void setUpAnnotations(List<? extends Diagnostic> diagnostics, AnnotationPresentationInfo data) {
        MultiMap fixesMap = KotlinPsiCheckerKt.access$createQuickFixes(diagnostics);
        for (TextRange range : data.getRanges()) {
            for (Diagnostic diagnostic : diagnostics) {
                void $receiver$iv;
                Annotation annotation2 = data.create(diagnostic, range, this.holder);
                Collection fixes2 = fixesMap.get((Object)diagnostic);
                Iterable iterable = fixes2;
                for (Object element$iv : $receiver$iv) {
                    IntentionAction it = (IntentionAction)element$iv;
                    annotation2.registerFix(it);
                }
                if (!Intrinsics.areEqual((Object)((Object)diagnostic.getSeverity()), (Object)((Object)Severity.WARNING))) continue;
                DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory, (String)"diagnostic.factory");
                annotation2.setProblemGroup((ProblemGroup)new KotlinSuppressableWarningProblemGroup(diagnosticFactory));
                if (!fixes2.isEmpty()) continue;
                annotation2.registerFix((IntentionAction)new EmptyIntentionAction(diagnostic.getFactory().getName()));
            }
        }
    }

    public ElementAnnotator(@NotNull PsiElement element2, @NotNull AnnotationHolder holder, @NotNull Function1<? super KtParameter, Boolean> shouldSuppressUnusedParameter) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull(shouldSuppressUnusedParameter, (String)"shouldSuppressUnusedParameter");
        this.element = element2;
        this.holder = holder;
        this.shouldSuppressUnusedParameter = shouldSuppressUnusedParameter;
    }
}

