/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.JavaTestFrameworkRunnableState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitProcessHandler;
import com.intellij.execution.junit.TestCategory;
import com.intellij.execution.junit.TestClass;
import com.intellij.execution.junit.TestDirectory;
import com.intellij.execution.junit.TestMethod;
import com.intellij.execution.junit.TestPackage;
import com.intellij.execution.junit.TestsPattern;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.segments.DeferredActionsQueue;
import com.intellij.execution.junit2.segments.DeferredActionsQueueImpl;
import com.intellij.execution.junit2.segments.DispatchListener;
import com.intellij.execution.junit2.segments.Extractor;
import com.intellij.execution.junit2.ui.JUnitTreeConsoleView;
import com.intellij.execution.junit2.ui.TestsPacketsReceiver;
import com.intellij.execution.junit2.ui.actions.RerunFailedTestsAction;
import com.intellij.execution.junit2.ui.model.CompletionEvent;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.model.RootTestInfo;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.rt.execution.junit.JUnitStarter;
import com.intellij.rt.execution.junit.RepeatCount;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestObject
extends JavaTestFrameworkRunnableState<JUnitConfiguration> {
    protected static final Logger LOG = Logger.getInstance(TestObject.class);
    private static final String MESSAGE = ExecutionBundle.message((String)"configuration.not.speficied.message", (Object[])new Object[0]);
    @NonNls
    private static final String JUNIT_TEST_FRAMEWORK_NAME = "JUnit";
    private final JUnitConfiguration myConfiguration;
    protected File myListenersFile;

    public static TestObject fromString(String id, JUnitConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/junit/TestObject", "fromString"));
        }
        if ("method".equals(id)) {
            return new TestMethod(configuration, environment);
        }
        if ("class".equals(id)) {
            return new TestClass(configuration, environment);
        }
        if ("package".equals(id)) {
            return new TestPackage(configuration, environment);
        }
        if ("directory".equals(id)) {
            return new TestDirectory(configuration, environment);
        }
        if ("category".equals(id)) {
            return new TestCategory(configuration, environment);
        }
        if ("pattern".equals(id)) {
            return new TestsPattern(configuration, environment);
        }
        LOG.error(MESSAGE + id);
        return null;
    }

    public Module[] getModulesToCompile() {
        SourceScope sourceScope = this.getSourceScope();
        return sourceScope != null ? sourceScope.getModulesToCompile() : Module.EMPTY_ARRAY;
    }

    protected TestObject(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(environment);
        this.myConfiguration = configuration;
    }

    public abstract String suggestActionName();

    public abstract RefactoringElementListener getListener(PsiElement var1, JUnitConfiguration var2);

    public abstract boolean isConfiguredByElement(JUnitConfiguration var1, PsiClass var2, PsiMethod var3, PsiPackage var4, PsiDirectory var5);

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this.getConfiguration());
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this.getConfiguration(), (Project)this.getConfiguration().getProject(), (Module)((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule());
    }

    @Nullable
    public SourceScope getSourceScope() {
        return SourceScope.modulesWithDependencies((Module[])this.getConfiguration().getModules());
    }

    protected void configureRTClasspath(JavaParameters javaParameters) {
        javaParameters.getClassPath().add(PathUtil.getJarPathForClass(JUnitStarter.class));
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = super.createJavaParameters();
        javaParameters.setMainClass("com.intellij.rt.execution.junit.JUnitStarter");
        javaParameters.getProgramParametersList().add("-ideVersion5");
        StringBuilder buf = new StringBuilder();
        this.collectListeners(javaParameters, buf, "com.intellij.junitListener", "\n");
        if (buf.length() > 0) {
            try {
                this.myListenersFile = FileUtil.createTempFile((String)"junit_listeners_", (String)"");
                this.myListenersFile.deleteOnExit();
                javaParameters.getProgramParametersList().add("@@" + this.myListenersFile.getPath());
                FileUtil.writeToFile((File)this.myListenersFile, (byte[])buf.toString().getBytes(CharsetToolkit.UTF8_CHARSET));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return javaParameters;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/junit/TestObject", "execute"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/execution/junit/TestObject", "execute"));
        }
        ExecutionResult executionResult = this.startSMRunner(executor);
        if (executionResult != null) {
            ExecutionResult executionResult2 = executionResult;
            if (executionResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestObject", "execute"));
            }
            return executionResult2;
        }
        final JUnitProcessHandler handler = this.createJUnitHandler(executor);
        RunnerSettings runnerSettings = this.getRunnerSettings();
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.getConfiguration(), (ProcessHandler)handler, runnerSettings);
        final TestProxy unboundOutputRoot = new TestProxy(new RootTestInfo());
        final JUnitConsoleProperties consoleProperties = new JUnitConsoleProperties(this.getConfiguration(), executor);
        final JUnitTreeConsoleView consoleView = new JUnitTreeConsoleView(consoleProperties, this.getEnvironment(), unboundOutputRoot);
        Disposer.register((Disposable)this.getConfiguration().getProject(), (Disposable)consoleView);
        consoleView.initUI();
        consoleView.attachToProcess((ProcessHandler)handler);
        unboundOutputRoot.setPrinter((Printer)consoleView.getPrinter());
        Disposer.register((Disposable)consoleView, (Disposable)unboundOutputRoot);
        final TestsPacketsReceiver packetsReceiver = new TestsPacketsReceiver(consoleView, unboundOutputRoot){

            @Override
            public synchronized void notifyStart(TestProxy root) {
                JUnitRunningModel model;
                if (!this.isRunning()) {
                    return;
                }
                super.notifyStart(root);
                unboundOutputRoot.addChild(root);
                if (TestObject.this.getConfiguration().isSaveOutputToFile()) {
                    unboundOutputRoot.setOutputFilePath(TestObject.this.getConfiguration().getOutputFilePath());
                }
                if ((model = this.getModel()) != null) {
                    handler.getOut().setDispatchListener((DispatchListener)model.getNotifier());
                    Disposer.register((Disposable)model, (Disposable)new Disposable(){

                        public void dispose() {
                            handler.getOut().setDispatchListener(DispatchListener.DEAF);
                        }
                    });
                    consoleView.attachToModel(model);
                }
            }
        };
        Disposer.register((Disposable)consoleView, (Disposable)packetsReceiver);
        DeferredActionsQueueImpl queue = new DeferredActionsQueueImpl();
        handler.getOut().setPacketDispatcher((PacketProcessor)packetsReceiver, (DeferredActionsQueue)queue);
        handler.getErr().setPacketDispatcher((PacketProcessor)packetsReceiver, (DeferredActionsQueue)queue);
        handler.addProcessListener((ProcessListener)new ProcessAdapter((DeferredActionsQueue)queue){
            private boolean myStarted = false;
            final /* synthetic */ DeferredActionsQueue val$queue;
            {
                this.val$queue = deferredActionsQueue;
            }

            public void startNotified(ProcessEvent event) {
                this.myStarted = true;
            }

            public void processTerminated(ProcessEvent event) {
                handler.removeProcessListener((ProcessListener)this);
                TestObject.this.deleteTempFiles();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        unboundOutputRoot.flush();
                        packetsReceiver.checkTerminated();
                        JUnitRunningModel model = packetsReceiver.getModel();
                        TestObject.this.notifyByBalloon(model, myStarted, consoleProperties);
                    }
                };
                handler.getOut().addRequest(runnable, this.val$queue);
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                final String text = event.getText();
                final ConsoleViewContentType consoleViewType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
                Printable printable = new Printable(){

                    public void printOn(Printer printer) {
                        printer.print(text, consoleViewType);
                    }
                };
                Extractor extractor = consoleViewType == ConsoleViewContentType.ERROR_OUTPUT || consoleViewType == ConsoleViewContentType.SYSTEM_OUTPUT ? handler.getErr() : handler.getOut();
                extractor.getEventsDispatcher().processOutput(printable);
            }
        });
        RerunFailedTestsAction rerunFailedTestsAction = new RerunFailedTestsAction((ComponentContainer)consoleView, (TestConsoleProperties)consoleProperties);
        rerunFailedTestsAction.setModelProvider((Getter)new Getter<TestFrameworkRunningModel>(){

            public TestFrameworkRunningModel get() {
                return packetsReceiver.getModel();
            }
        });
        DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)handler);
        result.setRestartActions(new AnAction[]{rerunFailedTestsAction});
        DefaultExecutionResult defaultExecutionResult = result;
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestObject", "execute"));
        }
        return defaultExecutionResult;
    }

    protected void notifyByBalloon(JUnitRunningModel model, boolean started, JUnitConsoleProperties consoleProperties) {
        CompletionEvent done;
        String comment = model != null ? ((done = model.getProgress().getDone()) != null ? done.getComment() : null) : null;
        TestsUIUtil.notifyByBalloon((Project)consoleProperties.getProject(), (boolean)started, (AbstractTestProxy)(model != null ? model.getRoot() : null), (TestConsoleProperties)consoleProperties, (String)comment);
    }

    @NotNull
    protected JUnitProcessHandler createJUnitHandler(Executor executor) throws ExecutionException {
        this.appendForkInfo(executor);
        String repeatMode = this.getConfiguration().getRepeatMode();
        if (!"Once".equals(repeatMode)) {
            int repeatCount = this.getConfiguration().getRepeatCount();
            String countString = "N Times".equals(repeatMode) && repeatCount > 0 ? RepeatCount.getCountString((int)repeatCount) : repeatMode;
            this.getJavaParameters().getProgramParametersList().add(countString);
        }
        JUnitProcessHandler jUnitProcessHandler = JUnitProcessHandler.runCommandLine((GeneralCommandLine)this.createCommandLine());
        if (jUnitProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestObject", "createJUnitHandler"));
        }
        return jUnitProcessHandler;
    }

    @NotNull
    protected OSProcessHandler createHandler(Executor executor) throws ExecutionException {
        this.appendForkInfo(executor);
        String repeatMode = this.getConfiguration().getRepeatMode();
        if (!"Once".equals(repeatMode)) {
            int repeatCount = this.getConfiguration().getRepeatCount();
            String countString = "N Times".equals(repeatMode) && repeatCount > 0 ? RepeatCount.getCountString((int)repeatCount) : repeatMode;
            this.getJavaParameters().getProgramParametersList().add(countString);
        }
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(this.createCommandLine());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        SearchForTestsTask searchForTestsTask = this.createSearchingForTestsTask();
        if (searchForTestsTask != null) {
            searchForTestsTask.attachTaskToProcess((OSProcessHandler)processHandler);
        }
        KillableColoredProcessHandler killableColoredProcessHandler = processHandler;
        if (killableColoredProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestObject", "createHandler"));
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    protected String getForkMode() {
        String string = this.getConfiguration().getForkMode();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestObject", "getForkMode"));
        }
        return string;
    }

    protected <T> void addClassesListToJavaParameters(Collection<? extends T> elements, Function<T, String> nameFunction, String packageName, boolean createTempFile, JavaParameters javaParameters) throws CantRunException {
        try {
            if (createTempFile) {
                this.createTempFiles(javaParameters);
            }
            TreeMap<Module, ArrayList<String>> perModule = this.forkPerModule() ? new TreeMap<Module, ArrayList<String>>(new Comparator<Module>(){

                @Override
                public int compare(Module o1, Module o2) {
                    return StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true);
                }
            }) : null;
            ArrayList<String> testNames = new ArrayList<String>();
            for (Object element : elements) {
                String name = (String)nameFunction.fun(element);
                if (name == null) continue;
                PsiElement psiElement = this.retrievePsiElement(element);
                if (perModule != null && psiElement != null) {
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
                    if (module == null) continue;
                    ArrayList<String> list = (ArrayList<String>)perModule.get(module);
                    if (list == null) {
                        list = new ArrayList<String>();
                        perModule.put(module, list);
                    }
                    list.add(name);
                    continue;
                }
                testNames.add(name);
            }
            JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
            if (perModule != null) {
                for (List perModuleClasses : perModule.values()) {
                    Collections.sort(perModuleClasses);
                    testNames.addAll(perModuleClasses);
                }
            } else if ("package".equals(data.TEST_OBJECT)) {
                Collections.sort(testNames);
            }
            String category = "category".equals(data.TEST_OBJECT) ? data.getCategory() : "";
            JUnitStarter.printClassesList(testNames, (String)packageName, (String)category, (File)this.myTempFile);
            this.writeClassesPerModule(packageName, javaParameters, perModule);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected PsiElement retrievePsiElement(Object element) {
        return element instanceof PsiElement ? (PsiElement)element : null;
    }

    protected void deleteTempFiles() {
        super.deleteTempFiles();
        if (this.myListenersFile != null) {
            FileUtil.delete((File)this.myListenersFile);
        }
    }

    @NotNull
    protected String getFrameworkName() {
        if (JUNIT_TEST_FRAMEWORK_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestObject", "getFrameworkName"));
        }
        return JUNIT_TEST_FRAMEWORK_NAME;
    }

    @NotNull
    protected String getFrameworkId() {
        if ("junit" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestObject", "getFrameworkId"));
        }
        return "junit";
    }

    protected void passTempFile(ParametersList parametersList, String tempFilePath) {
        parametersList.add("@" + tempFilePath);
    }

    @NotNull
    public JUnitConfiguration getConfiguration() {
        JUnitConfiguration jUnitConfiguration = this.myConfiguration;
        if (jUnitConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestObject", "getConfiguration"));
        }
        return jUnitConfiguration;
    }

    protected TestSearchScope getScope() {
        return this.getConfiguration().getPersistentData().getScope();
    }

    protected void passForkMode(String forkMode, File tempFile, JavaParameters parameters) throws ExecutionException {
        parameters.getProgramParametersList().add("@@@" + forkMode + ',' + tempFile.getAbsolutePath());
        if (this.getForkSocket() != null) {
            parameters.getProgramParametersList().add("-debugSocket" + this.getForkSocket().getLocalPort());
        }
    }
}

