/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.AndroidIdIndex;
import org.jetbrains.android.AndroidValueResourcesIndex;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.wrappers.FileResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.FileResourceProcessor;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceManager {
    protected final Project myProject;

    protected ResourceManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/resourceManagers/ResourceManager", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public abstract VirtualFile[] getAllResourceDirs();

    @NotNull
    public abstract List<VirtualFile> getResourceDirs();

    public abstract boolean isResourceDir(@NotNull VirtualFile var1);

    public boolean processFileResources(@Nullable String resourceType, @NotNull FileResourceProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/android/resourceManagers/ResourceManager", "processFileResources"));
        }
        return this.processFileResources(resourceType, processor, true);
    }

    public boolean processFileResources(@Nullable String resourceType, @NotNull FileResourceProcessor processor, boolean withDependencies) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/android/resourceManagers/ResourceManager", "processFileResources"));
        }
        return this.processFileResources(resourceType, processor, withDependencies, true);
    }

    public boolean processFileResources(@Nullable String resourceType, @NotNull FileResourceProcessor processor, boolean withDependencies, boolean publicOnly) {
        VirtualFile[] resDirs;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/android/resourceManagers/ResourceManager", "processFileResources"));
        }
        if (withDependencies) {
            resDirs = this.getAllResourceDirs();
        } else {
            List<VirtualFile> resourceDirs = this.getResourceDirs();
            resDirs = resourceDirs.toArray(new VirtualFile[resourceDirs.size()]);
        }
        for (VirtualFile resSubdir : AndroidResourceUtil.getResourceSubdirs(resourceType, resDirs)) {
            String resType = AndroidCommonUtils.getResourceTypeByDirName((String)resSubdir.getName());
            if (resType == null) continue;
            assert (resourceType == null || resourceType.equals(resType));
            for (VirtualFile resFile : resSubdir.getChildren()) {
                String resName = AndroidCommonUtils.getResourceName((String)resType, (String)resFile.getName());
                if (resFile.isDirectory() || publicOnly && !this.isResourcePublic(resType, resName) || processor.process(resFile, resName, resType)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public VirtualFile[] getResourceOverlayDirs() {
        if (VirtualFile.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "getResourceOverlayDirs"));
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    protected boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/resourceManagers/ResourceManager", "isResourcePublic"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/resourceManagers/ResourceManager", "isResourcePublic"));
        }
        return true;
    }

    @NotNull
    public List<VirtualFile> getResourceSubdirs(@Nullable String resourceType) {
        List<VirtualFile> list = AndroidResourceUtil.getResourceSubdirs(resourceType, this.getAllResourceDirs());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "getResourceSubdirs"));
        }
        return list;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull String resType, @Nullable String resName, boolean distinguishDelimetersInName, String ... extensions) {
        if (resType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType", "org/jetbrains/android/resourceManagers/ResourceManager", "findResourceFiles"));
        }
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "org/jetbrains/android/resourceManagers/ResourceManager", "findResourceFiles"));
        }
        List<PsiFile> list = this.findResourceFiles(resType, resName, distinguishDelimetersInName, true, extensions);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "findResourceFiles"));
        }
        return list;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull String resType1, @Nullable String resName1, boolean distinguishDelimetersInName, boolean withDependencies, final String ... extensions) {
        if (resType1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType1", "org/jetbrains/android/resourceManagers/ResourceManager", "findResourceFiles"));
        }
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "org/jetbrains/android/resourceManagers/ResourceManager", "findResourceFiles"));
        }
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        HashSet extensionSet = new HashSet();
        Collections.addAll(extensionSet, extensions);
        this.processFileResources(resType1, new FileResourceProcessor((Set)extensionSet, resName1, distinguishDelimetersInName, result){
            final /* synthetic */ Set val$extensionSet;
            final /* synthetic */ String val$resName1;
            final /* synthetic */ boolean val$distinguishDelimetersInName;
            final /* synthetic */ List val$result;
            {
                this.val$extensionSet = set;
                this.val$resName1 = string;
                this.val$distinguishDelimetersInName = bl;
                this.val$result = list;
            }

            @Override
            public boolean process(@NotNull VirtualFile resFile, @NotNull String resName, @NotNull String resFolderType) {
                PsiFile file;
                if (resFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resFile", "org/jetbrains/android/resourceManagers/ResourceManager$1", "process"));
                }
                if (resName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resName", "org/jetbrains/android/resourceManagers/ResourceManager$1", "process"));
                }
                if (resFolderType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resFolderType", "org/jetbrains/android/resourceManagers/ResourceManager$1", "process"));
                }
                String extension = resFile.getExtension();
                if ((extensions.length == 0 || this.val$extensionSet.contains(extension)) && (this.val$resName1 == null || AndroidUtils.equal(this.val$resName1, resName, this.val$distinguishDelimetersInName)) && (file = AndroidPsiUtils.getPsiFileSafely(ResourceManager.this.myProject, resFile)) != null) {
                    this.val$result.add(file);
                }
                return true;
            }
        }, withDependencies);
        ArrayList<PsiFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "findResourceFiles"));
        }
        return arrayList;
    }

    public List<PsiFile> findResourceFiles(@NotNull String resType, @NotNull String resName, String ... extensions) {
        if (resType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType", "org/jetbrains/android/resourceManagers/ResourceManager", "findResourceFiles"));
        }
        if (resName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resName", "org/jetbrains/android/resourceManagers/ResourceManager", "findResourceFiles"));
        }
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "org/jetbrains/android/resourceManagers/ResourceManager", "findResourceFiles"));
        }
        return this.findResourceFiles(resType, resName, true, extensions);
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull String resType) {
        if (resType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType", "org/jetbrains/android/resourceManagers/ResourceManager", "findResourceFiles"));
        }
        List<PsiFile> list = this.findResourceFiles(resType, null, true, new String[0]);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "findResourceFiles"));
        }
        return list;
    }

    protected List<Pair<Resources, VirtualFile>> getResourceElements(@Nullable Set<VirtualFile> files) {
        return this.getRootDomElements(Resources.class, files);
    }

    private <T extends DomElement> List<Pair<T, VirtualFile>> getRootDomElements(@NotNull Class<T> elementType, @Nullable Set<VirtualFile> files) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/android/resourceManagers/ResourceManager", "getRootDomElements"));
        }
        ArrayList<Pair<T, VirtualFile>> result = new ArrayList<Pair<T, VirtualFile>>();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            T element;
            if (files != null && !files.contains(file) || !file.isValid() || (element = AndroidUtils.loadDomElement(this.myProject, file, elementType)) == null) continue;
            result.add(Pair.create(element, (Object)file));
        }
        return result;
    }

    @NotNull
    protected Set<VirtualFile> getAllValueResourceFiles() {
        HashSet files = new HashSet();
        for (VirtualFile valueResourceDir : this.getResourceSubdirs("values")) {
            for (VirtualFile valueResourceFile : valueResourceDir.getChildren()) {
                if (valueResourceFile.isDirectory() || !valueResourceFile.getFileType().equals(StdFileTypes.XML)) continue;
                files.add(valueResourceFile);
            }
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "getAllValueResourceFiles"));
        }
        return hashSet;
    }

    protected List<ResourceElement> getValueResources(final @NotNull String resourceType, @Nullable Set<VirtualFile> files) {
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/resourceManagers/ResourceManager", "getValueResources"));
        }
        final ArrayList<ResourceElement> result = new ArrayList<ResourceElement>();
        List<Pair<Resources, VirtualFile>> resourceFiles = this.getResourceElements(files);
        for (Pair<Resources, VirtualFile> pair : resourceFiles) {
            final Resources resources = (Resources)pair.getFirst();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (!resources.isValid() || ResourceManager.this.myProject.isDisposed()) {
                        return;
                    }
                    List<ResourceElement> valueResources = AndroidResourceUtil.getValueResourcesFromElement(resourceType, resources);
                    for (ResourceElement valueResource : valueResources) {
                        String resName = (String)valueResource.getName().getValue();
                        if (resName == null || !ResourceManager.this.isResourcePublic(resourceType, resName)) continue;
                        result.add(valueResource);
                    }
                }
            });
        }
        return result;
    }

    @Nullable
    public String getValueResourceType(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/android/resourceManagers/ResourceManager", "getValueResourceType"));
        }
        String fileResType = this.getFileResourceType(tag.getContainingFile());
        if ("values".equals(fileResType)) {
            return tag.getName();
        }
        return null;
    }

    @Nullable
    public String getFileResourceType(final @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/resourceManagers/ResourceManager", "getFileResourceType"));
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                PsiDirectory dir = file.getContainingDirectory();
                if (dir == null) {
                    return null;
                }
                PsiDirectory possibleResDir = dir.getParentDirectory();
                if (possibleResDir == null || !ResourceManager.this.isResourceDir(possibleResDir.getVirtualFile())) {
                    return null;
                }
                String type = AndroidCommonUtils.getResourceTypeByDirName((String)dir.getName());
                if (type == null) {
                    return null;
                }
                return type;
            }
        });
    }

    @NotNull
    public Set<String> getFileResourcesNames(@NotNull String resourceType) {
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/resourceManagers/ResourceManager", "getFileResourcesNames"));
        }
        HashSet result = new HashSet();
        this.processFileResources(resourceType, new FileResourceProcessor((Set)result){
            final /* synthetic */ Set val$result;
            {
                this.val$result = set;
            }

            @Override
            public boolean process(@NotNull VirtualFile resFile, @NotNull String resName, @NotNull String resFolderType) {
                if (resFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resFile", "org/jetbrains/android/resourceManagers/ResourceManager$4", "process"));
                }
                if (resName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resName", "org/jetbrains/android/resourceManagers/ResourceManager$4", "process"));
                }
                if (resFolderType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resFolderType", "org/jetbrains/android/resourceManagers/ResourceManager$4", "process"));
                }
                this.val$result.add(resName);
                return true;
            }
        });
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "getFileResourcesNames"));
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getValueResourceNames(@NotNull String resourceType) {
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/resourceManagers/ResourceManager", "getValueResourceNames"));
        }
        HashSet result = new HashSet();
        boolean attr = ResourceType.ATTR.getName().equals(resourceType);
        for (ResourceEntry entry : this.getValueResourceEntries(resourceType)) {
            String name = entry.getName();
            if (attr && name.startsWith("android:")) continue;
            result.add(name);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "getValueResourceNames"));
        }
        return hashSet;
    }

    @NotNull
    public Collection<ResourceEntry> getValueResourceEntries(@NotNull String resourceType) {
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/resourceManagers/ResourceManager", "getValueResourceEntries"));
        }
        ResourceType type = ResourceType.getEnum((String)resourceType);
        if (type == null) {
            List<ResourceEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "getValueResourceEntries"));
            }
            return list;
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        ResourceEntry typeMarkerEntry = AndroidValueResourcesIndex.createTypeMarkerKey(resourceType);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        HashMap file2resourceSet = new HashMap();
        index.processValues(AndroidValueResourcesIndex.INDEX_ID, (Object)typeMarkerEntry, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<ImmutableSet<AndroidValueResourcesIndex.MyResourceInfo>>((Map)file2resourceSet){
            final /* synthetic */ Map val$file2resourceSet;
            {
                this.val$file2resourceSet = map;
            }

            public boolean process(VirtualFile file, ImmutableSet<AndroidValueResourcesIndex.MyResourceInfo> infos) {
                for (AndroidValueResourcesIndex.MyResourceInfo info : infos) {
                    Set resourcesInFile = (Set)this.val$file2resourceSet.get(file);
                    if (resourcesInFile == null) {
                        resourcesInFile = new HashSet();
                        this.val$file2resourceSet.put(file, resourcesInFile);
                    }
                    resourcesInFile.add(info.getResourceEntry());
                }
                return true;
            }
        }, scope);
        ArrayList<ResourceEntry> result = new ArrayList<ResourceEntry>();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            Set entries = (Set)file2resourceSet.get(file);
            if (entries == null) continue;
            for (ResourceEntry entry : entries) {
                if (!this.isResourcePublic(entry.getType(), entry.getName())) continue;
                result.add(entry);
            }
        }
        ArrayList<ResourceEntry> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "getValueResourceEntries"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<String> getResourceNames(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/resourceManagers/ResourceManager", "getResourceNames"));
        }
        Collection<String> collection = this.getResourceNames(type, false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "getResourceNames"));
        }
        return collection;
    }

    @NotNull
    public Collection<String> getResourceNames(@NotNull String type, boolean publicOnly) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/resourceManagers/ResourceManager", "getResourceNames"));
        }
        HashSet result = new HashSet();
        result.addAll(this.getValueResourceNames(type));
        result.addAll(this.getFileResourcesNames(type));
        if (type.equals(ResourceType.ID.getName())) {
            result.addAll(this.getIds(true));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "getResourceNames"));
        }
        return hashSet;
    }

    @Nullable
    public abstract AttributeDefinitions getAttributeDefinitions();

    @NotNull
    public List<XmlAttributeValue> findIdDeclarations(final @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/android/resourceManagers/ResourceManager", "findIdDeclarations"));
        }
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            List<XmlAttributeValue> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "findIdDeclarations"));
            }
            return list;
        }
        final ArrayList<XmlAttributeValue> declarations = new ArrayList<XmlAttributeValue>();
        Collection files = FileBasedIndex.getInstance().getContainingFiles(AndroidIdIndex.INDEX_ID, (Object)("+" + id), GlobalSearchScope.allScope((Project)this.myProject));
        HashSet fileSet = new HashSet(files);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile subdir : this.getResourceSubdirsToSearchIds()) {
            for (VirtualFile file : subdir.getChildren()) {
                PsiFile psiFile;
                if (!fileSet.contains(file) || !((psiFile = psiManager.findFile(file)) instanceof XmlFile)) continue;
                psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                        String idInAttr;
                        if (AndroidResourceUtil.isIdDeclaration(attributeValue) && id.equals(idInAttr = AndroidResourceUtil.getResourceNameByReferenceText(attributeValue.getValue()))) {
                            declarations.add(attributeValue);
                        }
                    }
                });
            }
        }
        ArrayList<XmlAttributeValue> arrayList = declarations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "findIdDeclarations"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<String> getIds(boolean declarationsOnly) {
        if (this.myProject.isDisposed()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "getIds"));
            }
            return list;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        FileBasedIndex index = FileBasedIndex.getInstance();
        HashMap file2idEntries = new HashMap();
        index.processValues(AndroidIdIndex.INDEX_ID, (Object)"$", null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Set<String>>((Map)file2idEntries){
            final /* synthetic */ Map val$file2idEntries;
            {
                this.val$file2idEntries = map;
            }

            public boolean process(VirtualFile file, Set<String> value) {
                this.val$file2idEntries.put(file, value);
                return true;
            }
        }, scope);
        HashSet result = new HashSet();
        for (VirtualFile resSubdir : this.getResourceSubdirsToSearchIds()) {
            for (VirtualFile resFile : resSubdir.getChildren()) {
                Set idEntries = (Set)file2idEntries.get(resFile);
                if (idEntries == null) continue;
                for (String idEntry : idEntries) {
                    if (idEntry.startsWith("+")) {
                        idEntry = idEntry.substring(1);
                    } else if (declarationsOnly) continue;
                    if (!this.isResourcePublic(ResourceType.ID.getName(), idEntry)) continue;
                    result.add(idEntry);
                }
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "getIds"));
        }
        return hashSet;
    }

    @NotNull
    public List<VirtualFile> getResourceSubdirsToSearchIds() {
        ArrayList<VirtualFile> resSubdirs = new ArrayList<VirtualFile>();
        for (ResourceType type : AndroidCommonUtils.ID_PROVIDING_RESOURCE_TYPES) {
            resSubdirs.addAll(this.getResourceSubdirs(type.getName()));
        }
        ArrayList<VirtualFile> arrayList = resSubdirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "getResourceSubdirsToSearchIds"));
        }
        return arrayList;
    }

    public List<ResourceElement> findValueResources(@NotNull String resType, @NotNull String resName) {
        if (resType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType", "org/jetbrains/android/resourceManagers/ResourceManager", "findValueResources"));
        }
        if (resName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resName", "org/jetbrains/android/resourceManagers/ResourceManager", "findValueResources"));
        }
        return this.findValueResources(resType, resName, true);
    }

    @NotNull
    public List<ResourceElement> findValueResources(@NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName) {
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/resourceManagers/ResourceManager", "findValueResources"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "org/jetbrains/android/resourceManagers/ResourceManager", "findValueResources"));
        }
        List<ValueResourceInfoImpl> resources = this.findValueResourceInfos(resourceType, resourceName, distinguishDelimitersInName, false);
        ArrayList<ResourceElement> result = new ArrayList<ResourceElement>();
        for (ValueResourceInfoImpl resource : resources) {
            ResourceElement domElement = resource.computeDomElement();
            if (domElement == null) continue;
            result.add(domElement);
        }
        ArrayList<ResourceElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "findValueResources"));
        }
        return arrayList;
    }

    public void collectLazyResourceElements(@NotNull String resType, @NotNull String resName, boolean withAttrs, @NotNull PsiElement context, @NotNull Collection<PsiElement> elements) {
        if (resType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType", "org/jetbrains/android/resourceManagers/ResourceManager", "collectLazyResourceElements"));
        }
        if (resName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resName", "org/jetbrains/android/resourceManagers/ResourceManager", "collectLazyResourceElements"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/resourceManagers/ResourceManager", "collectLazyResourceElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/android/resourceManagers/ResourceManager", "collectLazyResourceElements"));
        }
        List<ValueResourceInfoImpl> valueResources = this.findValueResourceInfos(resType, resName, false, withAttrs);
        for (ValueResourceInfo valueResourceInfo : valueResources) {
            elements.add((PsiElement)new LazyValueResourceElementWrapper(valueResourceInfo, context));
        }
        if (resType.equals("id")) {
            elements.addAll(this.findIdDeclarations(resName));
        }
        if (elements.size() == 0) {
            for (PsiFile psiFile : this.findResourceFiles(resType, resName, false, new String[0])) {
                elements.add(new FileResourceElementWrapper(psiFile));
            }
        }
    }

    @NotNull
    public List<ValueResourceInfoImpl> findValueResourceInfos(@NotNull String resourceType, final @NotNull String resourceName, final boolean distinguishDelimetersInName, boolean searchAttrs) {
        ResourceType type;
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/resourceManagers/ResourceManager", "findValueResourceInfos"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "org/jetbrains/android/resourceManagers/ResourceManager", "findValueResourceInfos"));
        }
        ResourceType resourceType2 = type = resourceType.startsWith("+") ? ResourceType.ID : ResourceType.getEnum((String)resourceType);
        if (type == null || !AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(type) && (type != ResourceType.ATTR || !searchAttrs)) {
            List<ValueResourceInfoImpl> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "findValueResourceInfos"));
            }
            return list;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        final ArrayList<ValueResourceInfoImpl> result = new ArrayList<ValueResourceInfoImpl>();
        final Set<VirtualFile> valueResourceFiles = this.getAllValueResourceFiles();
        FileBasedIndex.getInstance().processValues(AndroidValueResourcesIndex.INDEX_ID, (Object)AndroidValueResourcesIndex.createTypeNameMarkerKey(resourceType, resourceName), null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<ImmutableSet<AndroidValueResourcesIndex.MyResourceInfo>>(){

            public boolean process(VirtualFile file, ImmutableSet<AndroidValueResourcesIndex.MyResourceInfo> infos) {
                for (AndroidValueResourcesIndex.MyResourceInfo info : infos) {
                    String name = info.getResourceEntry().getName();
                    if (!AndroidUtils.equal(resourceName, name, distinguishDelimetersInName) || !valueResourceFiles.contains(file)) continue;
                    result.add(new ValueResourceInfoImpl(info.getResourceEntry().getName(), type, file, ResourceManager.this.myProject, info.getOffset()));
                }
                return true;
            }
        }, scope);
        ArrayList<ValueResourceInfoImpl> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/ResourceManager", "findValueResourceInfos"));
        }
        return arrayList;
    }
}

