/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryPropertiesEditorBase;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryType;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesDialog;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;
import org.jetbrains.idea.maven.utils.library.remote.MavenDependenciesRemoteManager;
import org.jetbrains.idea.maven.utils.library.remote.MavenRemoteTask;

public class RepositoryLibraryWithDescriptionEditor
extends LibraryPropertiesEditorBase<RepositoryLibraryProperties, RepositoryLibraryType> {
    public RepositoryLibraryWithDescriptionEditor(LibraryEditorComponent<RepositoryLibraryProperties> editorComponent) {
        super(editorComponent, (LibraryType)RepositoryLibraryType.getInstance(), null);
    }

    public void apply() {
    }

    protected void edit() {
        RepositoryLibraryProperties properties = (RepositoryLibraryProperties)this.myEditorComponent.getProperties();
        boolean wasGeneratedName = RepositoryLibraryType.getInstance().getDescription(properties).equals(this.myEditorComponent.getLibraryEditor().getName());
        RepositoryLibraryPropertiesModel model = new RepositoryLibraryPropertiesModel(properties.getVersion(), RepositoryUtils.libraryHasSources(this.myEditorComponent.getLibraryEditor()), RepositoryUtils.libraryHasJavaDocs(this.myEditorComponent.getLibraryEditor()));
        RepositoryLibraryPropertiesDialog dialog = new RepositoryLibraryPropertiesDialog(this.myEditorComponent.getProject(), model, RepositoryLibraryDescription.findDescription(properties), true);
        if (!dialog.showAndGet()) {
            return;
        }
        ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).changeVersion(model.getVersion());
        if (wasGeneratedName) {
            this.myEditorComponent.renameLibrary(RepositoryLibraryType.getInstance().getDescription(properties));
        }
        final LibraryEditor libraryEditor = this.myEditorComponent.getLibraryEditor();
        MavenDependenciesRemoteManager.getInstance(this.myEditorComponent.getProject()).downloadDependenciesAsync(properties, model.isDownloadSources(), model.isDownloadJavaDocs(), RepositoryUtils.getStorageRoot(this.myEditorComponent.getLibraryEditor().getUrls(OrderRootType.CLASSES), this.myEditorComponent.getProject()), new MavenRemoteTask.ResultProcessor<List<OrderRoot>>(){

            @Override
            public void process(@Nullable List<OrderRoot> roots) {
                libraryEditor.removeAllRoots();
                if (roots != null) {
                    libraryEditor.addRoots(roots);
                }
            }
        });
    }
}

