/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.util.ProxySettings;
import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.PortField;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxySettingsDialog
extends DialogWrapper {
    private static final String SHOW_DO_NOT_ASK_TO_COPY_PROXY_SETTINGS_PROPERTY_NAME = "show.do.not.copy.http.proxy.settings.to.gradle";
    private Project myProject;
    private JPanel myPane;
    private JTextField myHttpProxyLoginTextField;
    private JPasswordField myHttpProxyPasswordTextField;
    private JCheckBox myHttpProxyAuthCheckBox;
    private PortField myHttpProxyPortTextField;
    private JTextField myHttpProxyHostTextField;
    private RawCommandLineEditor myHttpProxyExceptions;
    private JTextField myHttpsProxyLoginTextField;
    private JPasswordField myHttpsProxyPasswordTextField;
    private JCheckBox myHttpsProxyAuthCheckBox;
    private PortField myHttpsProxyPortTextField;
    private JTextField myHttpsProxyHostTextField;
    private RawCommandLineEditor myHttpsProxyExceptions;
    private JCheckBox myEnableHTTPSProxyCheckBox;
    private JPanel myHttpsProxyPanel;
    private JPanel myHttpProxyPanel;
    private JBLabel myMessageTextLabel;

    public ProxySettingsDialog(@NotNull Project project, @NotNull ProxySettings httpProxySettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/ProxySettingsDialog", "<init>"));
        }
        if (httpProxySettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "httpProxySettings", "com/android/tools/idea/gradle/project/ProxySettingsDialog", "<init>"));
        }
        super(false);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.setTitle("Proxy Settings");
        this.setDoNotAskOption(new PropertyDoNotAskOption(project, SHOW_DO_NOT_ASK_TO_COPY_PROXY_SETTINGS_PROPERTY_NAME));
        this.init();
        this.enableHttpsProxy(false);
        this.enableHttpProxyAuth(false);
        this.enableHttpsProxyAuth(false);
        this.myMessageTextLabel.setText("<html>Android Studio is configured to use a HTTP proxy.Gradle may need these HTTP proxy settings to access the Internet (e.g. for downloading dependencies.)<p><p>Would you like to copy the IDE's proxy configuration to project's gradle.properties file?<p><p>For more details, please refer to the <a href=https://developer.android.com/tools/studio/studio-config.html#proxy>developers site</a>.</html>");
        this.myHttpProxyHostTextField.setText(httpProxySettings.getHost());
        this.myHttpProxyPortTextField.setNumber(httpProxySettings.getPort());
        this.myHttpProxyAuthCheckBox.setSelected(httpProxySettings.getUser() != null);
        this.myHttpProxyExceptions.setText(httpProxySettings.getExceptions());
        if (httpProxySettings.getExceptions() != null) {
            this.myHttpProxyExceptions.setText(httpProxySettings.getExceptions());
        }
        if (httpProxySettings.getUser() != null) {
            this.myHttpProxyLoginTextField.setText(httpProxySettings.getUser());
            this.enableHttpProxyAuth(true);
        }
        if (httpProxySettings.getPassword() != null) {
            this.myHttpProxyPasswordTextField.setText(httpProxySettings.getPassword());
        }
        this.myHttpsProxyHostTextField.setText(httpProxySettings.getHost());
        this.myHttpsProxyPortTextField.setNumber(httpProxySettings.getPort());
        this.myHttpsProxyAuthCheckBox.setSelected(httpProxySettings.getUser() != null);
        if (httpProxySettings.getExceptions() != null) {
            this.myHttpsProxyExceptions.setText(httpProxySettings.getExceptions());
            this.enableHttpsProxyAuth(true);
        }
        if (httpProxySettings.getUser() != null) {
            this.myHttpsProxyLoginTextField.setText(httpProxySettings.getUser());
        }
        if (httpProxySettings.getPassword() != null) {
            this.myHttpsProxyPasswordTextField.setText(httpProxySettings.getPassword());
        }
        this.myEnableHTTPSProxyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxySettingsDialog.this.enableHttpsProxy(((JCheckBox)e.getSource()).isSelected());
            }
        });
        this.myHttpProxyAuthCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxySettingsDialog.this.enableHttpProxyAuth(((JCheckBox)e.getSource()).isSelected());
            }
        });
        this.myHttpsProxyAuthCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxySettingsDialog.this.enableHttpsProxyAuth(((JCheckBox)e.getSource()).isSelected());
            }
        });
    }

    public void show() {
        if (PropertiesComponent.getInstance((Project)this.myProject).getBoolean(SHOW_DO_NOT_ASK_TO_COPY_PROXY_SETTINGS_PROPERTY_NAME, true)) {
            super.show();
        }
    }

    public void applyProxySettings(@NotNull Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/gradle/project/ProxySettingsDialog", "applyProxySettings"));
        }
        ProxySettings httpProxySetting = ProxySettingsDialog.createProxySettingsFromUI("http", this.myHttpProxyHostTextField, this.myHttpProxyPortTextField, this.myHttpProxyExceptions, this.myHttpProxyAuthCheckBox, this.myHttpProxyLoginTextField, this.myHttpProxyPasswordTextField);
        httpProxySetting.applyProxySettings(properties);
        if (this.myEnableHTTPSProxyCheckBox.isSelected()) {
            ProxySettings httpsProxySettings = ProxySettingsDialog.createProxySettingsFromUI("https", this.myHttpsProxyHostTextField, this.myHttpsProxyPortTextField, this.myHttpsProxyExceptions, this.myHttpsProxyAuthCheckBox, this.myHttpsProxyLoginTextField, this.myHttpsProxyPasswordTextField);
            httpsProxySettings.applyProxySettings(properties);
        }
    }

    @NotNull
    private static ProxySettings createProxySettingsFromUI(@NotNull String proxyType, @NotNull JTextField proxyHostTextField, @NotNull PortField proxyPortTextField, @NotNull RawCommandLineEditor proxyExceptions, @NotNull JCheckBox proxyAuthCheckBox, @NotNull JTextField proxyLoginTextField, @NotNull JPasswordField proxyPasswordTextField) {
        if (proxyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxyType", "com/android/tools/idea/gradle/project/ProxySettingsDialog", "createProxySettingsFromUI"));
        }
        if (proxyHostTextField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxyHostTextField", "com/android/tools/idea/gradle/project/ProxySettingsDialog", "createProxySettingsFromUI"));
        }
        if (proxyPortTextField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxyPortTextField", "com/android/tools/idea/gradle/project/ProxySettingsDialog", "createProxySettingsFromUI"));
        }
        if (proxyExceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxyExceptions", "com/android/tools/idea/gradle/project/ProxySettingsDialog", "createProxySettingsFromUI"));
        }
        if (proxyAuthCheckBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxyAuthCheckBox", "com/android/tools/idea/gradle/project/ProxySettingsDialog", "createProxySettingsFromUI"));
        }
        if (proxyLoginTextField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxyLoginTextField", "com/android/tools/idea/gradle/project/ProxySettingsDialog", "createProxySettingsFromUI"));
        }
        if (proxyPasswordTextField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxyPasswordTextField", "com/android/tools/idea/gradle/project/ProxySettingsDialog", "createProxySettingsFromUI"));
        }
        ProxySettings proxySettings = new ProxySettings(proxyType);
        proxySettings.setHost(proxyHostTextField.getText());
        proxySettings.setPort(proxyPortTextField.getNumber());
        proxySettings.setExceptions(proxyExceptions.getText());
        if (proxyAuthCheckBox.isSelected()) {
            proxySettings.setUser(proxyLoginTextField.getText());
            proxySettings.setPassword(new String(proxyPasswordTextField.getPassword()));
        }
        ProxySettings proxySettings2 = proxySettings;
        if (proxySettings2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ProxySettingsDialog", "createProxySettingsFromUI"));
        }
        return proxySettings2;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPane;
    }

    private void enableHttpsProxy(boolean enabled) {
        this.myHttpsProxyPanel.setEnabled(enabled);
        this.myHttpsProxyHostTextField.setEnabled(enabled);
        this.myHttpsProxyPortTextField.setEnabled(enabled);
        this.myHttpsProxyExceptions.setEnabled(enabled);
        this.myHttpsProxyAuthCheckBox.setEnabled(enabled);
        this.enableHttpsProxyAuth(enabled && this.myHttpsProxyAuthCheckBox.isSelected());
    }

    private void enableHttpProxyAuth(boolean enabled) {
        this.myHttpProxyLoginTextField.setEnabled(enabled);
        this.myHttpProxyPasswordTextField.setEnabled(enabled);
    }

    private void enableHttpsProxyAuth(boolean enabled) {
        this.myHttpsProxyLoginTextField.setEnabled(enabled);
        this.myHttpsProxyPasswordTextField.setEnabled(enabled);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        PortField portField;
        RawCommandLineEditor rawCommandLineEditor;
        JPasswordField jPasswordField;
        JTextField jTextField;
        JTextField jTextField2;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        PortField portField2;
        RawCommandLineEditor rawCommandLineEditor2;
        JPasswordField jPasswordField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel3.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, null, null));
        this.myHttpProxyPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "HTTP Proxy", 0, 0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CommonBundle").getString("editbox.host.name"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myHttpProxyAuthCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(2, 1, 2, 2));
        jCheckBox3.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/CommonBundle").getString("checkbox.proxy.authentication"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 7, 8, 0, 3, 0, null, null, null, 1));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/CommonBundle").getString("editbox.login"));
        jPanel2.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 4));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("No proxy for:");
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myHttpProxyLoginTextField = jTextField4 = new JTextField();
        jTextField4.setText("");
        jPanel2.add((Component)jTextField4, new GridConstraints(3, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/CommonBundle").getString("editbox.password"));
        jPanel2.add((Component)jLabel4, new GridConstraints(3, 3, 1, 1, 8, 0, 0, 0, null, null, null, 4));
        this.myHttpProxyHostTextField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myHttpProxyPasswordTextField = jPasswordField2 = new JPasswordField();
        jPanel2.add((Component)jPasswordField2, new GridConstraints(3, 4, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myHttpProxyExceptions = rawCommandLineEditor2 = new RawCommandLineEditor();
        rawCommandLineEditor2.setDialogCaption("Proxy exceptions");
        jPanel2.add((Component)rawCommandLineEditor2, new GridConstraints(1, 1, 1, 5, 0, 1, 7, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/CommonBundle").getString("editbox.port.number"));
        jPanel2.add((Component)jLabel5, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myHttpProxyPortTextField = portField2 = new PortField();
        jPanel2.add((Component)portField2, new GridConstraints(0, 4, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myHttpsProxyPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(true);
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(null, "HTTPS Proxy", 0, 0, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/CommonBundle").getString("editbox.host.name"));
        jPanel.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myHttpsProxyAuthCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(2, 1, 2, 2));
        jCheckBox2.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/CommonBundle").getString("checkbox.proxy.authentication"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 7, 8, 0, 3, 0, null, null, null, 2));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/CommonBundle").getString("editbox.login"));
        jPanel.add((Component)jLabel7, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 4));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("No proxy for:");
        jPanel.add((Component)jLabel8, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myHttpsProxyLoginTextField = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel.add((Component)jTextField2, new GridConstraints(3, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("messages/CommonBundle").getString("editbox.password"));
        jPanel.add((Component)jLabel9, new GridConstraints(3, 3, 1, 1, 8, 0, 0, 0, null, null, null, 4));
        this.myHttpsProxyHostTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myHttpsProxyPasswordTextField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(3, 4, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myHttpsProxyExceptions = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption("Proxy exceptions");
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 5, 0, 1, 7, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("messages/CommonBundle").getString("editbox.port.number"));
        jPanel.add((Component)jLabel10, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myHttpsProxyPortTextField = portField = new PortField();
        jPanel.add((Component)portField, new GridConstraints(0, 4, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myMessageTextLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myEnableHTTPSProxyCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable HTTPS Proxy");
        jPanel3.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField3);
        jLabel2.setLabelFor(jTextField4);
        jLabel4.setLabelFor(jPasswordField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class PropertyDoNotAskOption
    implements DialogWrapper.DoNotAskOption {
        @NotNull
        private final String myProperty;
        @NotNull
        private final Project myProject;

        PropertyDoNotAskOption(@NotNull Project project, @NotNull String property) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/ProxySettingsDialog$PropertyDoNotAskOption", "<init>"));
            }
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/project/ProxySettingsDialog$PropertyDoNotAskOption", "<init>"));
            }
            this.myProperty = property;
            this.myProject = project;
        }

        public boolean isToBeShown() {
            return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(this.myProperty, true);
        }

        public void setToBeShown(boolean toBeShown, int exitCode) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(this.myProperty, String.valueOf(toBeShown));
        }

        public boolean canBeHidden() {
            return true;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return true;
        }

        @NotNull
        public String getDoNotShowMessage() {
            String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ProxySettingsDialog$PropertyDoNotAskOption", "getDoNotShowMessage"));
            }
            return string;
        }
    }
}

