/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.Location;
import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEventUnsupported;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.TaskOperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskLocation;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.ExecutionInfo;
import org.jetbrains.plugins.gradle.execution.TaskExecutionView;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleUrlProvider;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleRunnerUtil {
    public static DuplexConsoleView attachTaskExecutionView(@NotNull Project project, final @NotNull ConsoleView consoleView, boolean isTaskConsoleEnabledByDefault, final @Nullable String stateStorageKey, @NotNull ProcessHandler processHandler, @NotNull ExternalSystemTaskId taskId) {
        String tripleStateStorageKey;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil", "attachTaskExecutionView"));
        }
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil", "attachTaskExecutionView"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil", "attachTaskExecutionView"));
        }
        if (taskId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskId", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil", "attachTaskExecutionView"));
        }
        String string = tripleStateStorageKey = stateStorageKey != null ? stateStorageKey + "_str" : null;
        if (stateStorageKey != null && isTaskConsoleEnabledByDefault && !PropertiesComponent.getInstance().isValueSet(tripleStateStorageKey)) {
            PropertiesComponent.getInstance().setValue(tripleStateStorageKey, Boolean.TRUE.toString());
            PropertiesComponent.getInstance().setValue(stateStorageKey, Boolean.TRUE.booleanValue());
        }
        TaskExecutionView gradleExecutionConsole = new TaskExecutionView(project);
        final Ref duplexConsoleViewRef = Ref.create();
        DuplexConsoleView<ConsoleView, ConsoleView> duplexConsoleView = new DuplexConsoleView<ConsoleView, ConsoleView>((ConsoleView)gradleExecutionConsole, consoleView, stateStorageKey){

            public void enableConsole(boolean primary) {
                super.enableConsole(primary);
                if (stateStorageKey != null) {
                    PropertiesComponent.getInstance().setValue(tripleStateStorageKey, Boolean.toString(primary));
                }
            }

            @NotNull
            public AnAction[] createConsoleActions() {
                AnAction[] consoleActions;
                DefaultActionGroup textActionGroup = new DefaultActionGroup(){

                    public void update(AnActionEvent e) {
                        super.update(e);
                        if (duplexConsoleViewRef.get() != null) {
                            e.getPresentation().setVisible(!((DuplexConsoleView)duplexConsoleViewRef.get()).isPrimaryConsoleEnabled());
                        }
                    }
                };
                for (AnAction anAction : consoleActions = consoleView.createConsoleActions()) {
                    textActionGroup.add(anAction);
                }
                ArrayList anActions = ContainerUtil.newArrayList((Object[])super.createConsoleActions());
                anActions.add(textActionGroup);
                AnAction[] anActionArray = (AnAction[])ArrayUtil.toObjectArray((Collection)anActions, AnAction.class);
                if (anActionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil$1", "createConsoleActions"));
                }
                return anActionArray;
            }
        };
        duplexConsoleViewRef.set((Object)duplexConsoleView);
        duplexConsoleView.setDisableSwitchConsoleActionOnProcessEnd(false);
        duplexConsoleView.getSwitchConsoleActionPresentation().setIcon(AllIcons.Actions.ChangeView);
        duplexConsoleView.getSwitchConsoleActionPresentation().setText(GradleBundle.message("gradle.runner.toggle.tree.text.action.name", new Object[0]));
        ExternalSystemProgressNotificationManager progressManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        ExternalSystemTaskNotificationListenerAdapter taskListener = new ExternalSystemTaskNotificationListenerAdapter((DuplexConsoleView)duplexConsoleView, gradleExecutionConsole, progressManager){
            final /* synthetic */ DuplexConsoleView val$duplexConsoleView;
            final /* synthetic */ TaskExecutionView val$gradleExecutionConsole;
            final /* synthetic */ ExternalSystemProgressNotificationManager val$progressManager;
            {
                this.val$duplexConsoleView = duplexConsoleView;
                this.val$gradleExecutionConsole = taskExecutionView;
                this.val$progressManager = externalSystemProgressNotificationManager;
            }

            public void onStatusChange(final @NotNull ExternalSystemTaskNotificationEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil$2", "onStatusChange"));
                }
                if (event instanceof ExternalSystemTaskExecutionEvent) {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (((ExternalSystemTaskExecutionEvent)event).getProgressEvent() instanceof ExternalSystemProgressEventUnsupported) {
                                val$duplexConsoleView.enableConsole(false);
                            }
                            val$gradleExecutionConsole.onStatusChange((ExternalSystemTaskExecutionEvent)event);
                        }
                    });
                }
            }

            public void onQueued(@NotNull ExternalSystemTaskId id, final String workingDir) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil$2", "onQueued"));
                }
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        val$gradleExecutionConsole.setWorkingDir(workingDir);
                    }
                });
            }

            public void onFailure(@NotNull ExternalSystemTaskId id, final @NotNull Exception e) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil$2", "onFailure"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil$2", "onFailure"));
                }
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        val$gradleExecutionConsole.onFailure(e);
                    }
                });
            }

            public void onEnd(@NotNull ExternalSystemTaskId id) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil$2", "onEnd"));
                }
                this.val$progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this);
            }
        };
        progressManager.addNotificationListener(taskId, (ExternalSystemTaskNotificationListener)taskListener);
        return duplexConsoleView;
    }

    @Nullable
    public static Location<PsiMethod> getMethodLocation(@NotNull Location contextLocation) {
        PsiClass containingClass;
        if (contextLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextLocation", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil", "getMethodLocation"));
        }
        MethodLocation methodLocation = GradleRunnerUtil.getTestMethod(contextLocation);
        if (methodLocation == null) {
            return null;
        }
        if (contextLocation instanceof PsiMemberParameterizedLocation && (containingClass = ((PsiMemberParameterizedLocation)contextLocation).getContainingClass()) != null) {
            methodLocation = MethodLocation.elementInClass((PsiMethod)((PsiMethod)methodLocation.getPsiElement()), (PsiClass)containingClass);
        }
        return methodLocation;
    }

    @Nullable
    public static Location<PsiMethod> getTestMethod(Location<?> location) {
        Iterator iterator = location.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            Location methodLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestMethod((Location)methodLocation, (boolean)false)) continue;
            return methodLocation;
        }
        return null;
    }

    @NotNull
    public static String getTestLocationUrl(@Nullable String testName, @NotNull String fqClassName) {
        if (fqClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqClassName", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil", "getTestLocationUrl"));
        }
        String string = testName == null ? String.format("%s://%s::%s", "gradle", "className", fqClassName) : String.format("%s://%s::%s::%s", "gradle", "methodName", fqClassName, testName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil", "getTestLocationUrl"));
        }
        return string;
    }

    public static Object getData(@NotNull Project project, @NonNls String dataId, @NotNull ExecutionInfo executionInfo) {
        Location location;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil", "getData"));
        }
        if (executionInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionInfo", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil", "getData"));
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            OpenFileDescriptor openFileDescriptor;
            location = GradleRunnerUtil.getLocation(project, executionInfo);
            OpenFileDescriptor openFileDescriptor2 = openFileDescriptor = location == null ? null : location.getOpenFileDescriptor();
            if (openFileDescriptor != null && openFileDescriptor.getFile().isValid()) {
                return openFileDescriptor;
            }
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            location = GradleRunnerUtil.getLocation(project, executionInfo);
            if (location != null) {
                PsiElement element = location.getPsiElement();
                return element.isValid() ? element : null;
            }
            return null;
        }
        if (Location.DATA_KEY.is(dataId)) {
            return GradleRunnerUtil.getLocation(project, executionInfo);
        }
        return null;
    }

    @Nullable
    public static ExternalSystemTaskLocation getTaskLocation(Project project, ExecutionInfo ... executionInfos) {
        ExternalTaskExecutionInfo taskExecutionInfo = new ExternalTaskExecutionInfo();
        String projectPath = null;
        List taskNames = taskExecutionInfo.getSettings().getTaskNames();
        for (ExecutionInfo executionInfo : executionInfos) {
            String taskName;
            OperationDescriptor descriptor = executionInfo.getDescriptor();
            if (descriptor instanceof TaskOperationDescriptor) {
                taskName = ((TaskOperationDescriptor)descriptor).getTaskName();
                if (projectPath == null) {
                    projectPath = executionInfo.getWorkingDir();
                } else if (!projectPath.equals(executionInfo.getWorkingDir())) {
                    return null;
                }
            } else {
                return null;
            }
            taskNames.add(taskName);
        }
        if (!taskNames.isEmpty()) {
            taskExecutionInfo.getSettings().setExternalSystemIdString(GradleConstants.SYSTEM_ID.toString());
            taskExecutionInfo.getSettings().setExternalProjectPath(projectPath);
            return ExternalSystemTaskLocation.create((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, projectPath, (ExternalTaskExecutionInfo)taskExecutionInfo);
        }
        return null;
    }

    @Nullable
    private static Location getLocation(Project project, ExecutionInfo executionInfo) {
        OperationDescriptor descriptor = executionInfo.getDescriptor();
        if (descriptor instanceof TestOperationDescriptor) {
            String className = ((TestOperationDescriptor)descriptor).getClassName();
            if (className == null) {
                return null;
            }
            String methodName = ((TestOperationDescriptor)descriptor).getMethodName();
            String testLocationUrl = VirtualFileManager.extractPath((String)GradleRunnerUtil.getTestLocationUrl(methodName, className));
            List<Location> locations = GradleUrlProvider.INSTANCE.getLocation("gradle", testLocationUrl, project, GlobalSearchScope.allScope((Project)project));
            return (Location)ContainerUtil.getFirstItem(locations);
        }
        return GradleRunnerUtil.getTaskLocation(project, executionInfo);
    }
}

