/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.Prefs;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PrivacyPolicy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.PrivacyPolicy");
    private static final String CACHED_RESOURCE_NAME = "Cached";
    private static final String RELATIVE_RESOURCE_PATH = "JetBrains/PrivacyPolicy";
    private static final String VERSION_COMMENT_START = "<!--";
    private static final String VERSION_COMMENT_END = "-->";
    private static final String ACCEPTED_VERSION_KEY = "JetBrains.privacy_policy.accepted_version";
    private static final Version EMBEDDED_VERSION = new Version(1, 0);
    @Nullable
    private static volatile Version ourLatestVersion;
    private static final File ourCachedPolicyFile;

    public static boolean isLatestVersionAccepted() {
        return PrivacyPolicy.getAcceptedVersion().equals(PrivacyPolicy.getLatestVersion());
    }

    public static void setVersionAccepted(@NotNull Version version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/ide/PrivacyPolicy", "setVersionAccepted"));
        }
        if (version.isUnknown()) {
            Prefs.remove(ACCEPTED_VERSION_KEY);
        } else {
            Prefs.put(ACCEPTED_VERSION_KEY, version.toString());
        }
    }

    @NotNull
    public static Version getLatestVersion() {
        Version cached = ourLatestVersion;
        if (cached != null) {
            Version version = cached;
            if (version == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/PrivacyPolicy", "getLatestVersion"));
            }
            return version;
        }
        Version latest = EMBEDDED_VERSION;
        if (ourCachedPolicyFile.exists()) {
            try {
                Version version = PrivacyPolicy.loadVersion(new FileInputStream(ourCachedPolicyFile));
                if (!version.isUnknown() && version.compareTo(latest) > 0) {
                    latest = version;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        ourLatestVersion = latest;
        Version version = latest;
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/PrivacyPolicy", "getLatestVersion"));
        }
        return version;
    }

    @NotNull
    public static Version getAcceptedVersion() {
        Version version = new Version(Prefs.get(ACCEPTED_VERSION_KEY, null));
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/PrivacyPolicy", "getAcceptedVersion"));
        }
        return version;
    }

    public static String getText() {
        return PrivacyPolicy.getText(PrivacyPolicy.getLatestVersion());
    }

    @NotNull
    public static String getText(@NotNull Version version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/ide/PrivacyPolicy", "getText"));
        }
        String text = null;
        try {
            text = EMBEDDED_VERSION.equals(version) ? PrivacyPolicy.loadText(PrivacyPolicy.class.getResourceAsStream("/PrivacyPolicy-" + EMBEDDED_VERSION + ".html")) : PrivacyPolicy.loadText(new FileInputStream(ourCachedPolicyFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = text == null ? "" : text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/PrivacyPolicy", "getText"));
        }
        return string;
    }

    public static void updateText(String text) {
        try {
            FileUtil.writeToFile((File)ourCachedPolicyFile, (String)text);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        finally {
            ourLatestVersion = null;
        }
    }

    @Nullable
    private static String loadText(InputStream stream) {
        block5: {
            String string;
            if (stream == null) break block5;
            InputStreamReader reader = new InputStreamReader(stream, "utf-8");
            try {
                string = new String(FileUtil.adaptiveLoadText((Reader)reader));
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)reader).close();
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            ((Reader)reader).close();
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static Version loadVersion(InputStream is) {
        block8: {
            BufferedReader reader;
            block7: {
                int endComment;
                int startComment;
                reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                String line = reader.readLine();
                if (line == null || (startComment = line.indexOf(VERSION_COMMENT_START)) < 0 || (endComment = line.indexOf(VERSION_COMMENT_END)) <= startComment) break block7;
                Version version = new Version(line.substring(startComment + VERSION_COMMENT_START.length(), endComment).trim());
                reader.close();
                Version version2 = version;
                if (version2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/PrivacyPolicy", "loadVersion"));
                }
                return version2;
            }
            try {
                reader.close();
                break block8;
                {
                    catch (Throwable throwable) {
                        reader.close();
                        throw throwable;
                    }
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        Version version = Version.UNKNOWN;
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/PrivacyPolicy", "loadVersion"));
        }
        return version;
    }

    static {
        File dataDir = null;
        if (SystemInfo.isWindows) {
            String appdata = System.getenv("APPDATA");
            if (appdata != null) {
                dataDir = new File(appdata, RELATIVE_RESOURCE_PATH);
            }
        } else {
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                if (SystemInfo.isMac) {
                    File dataRoot = new File(userHome, "/Library/Application Support");
                    if (dataRoot.exists()) {
                        dataDir = new File(dataRoot, RELATIVE_RESOURCE_PATH);
                    }
                } else if (SystemInfo.isUnix) {
                    File dataRoot;
                    String dataHome = System.getenv("XDG_DATA_HOME");
                    File file = dataRoot = dataHome == null ? new File(userHome, ".local/share") : new File(dataHome);
                    if (dataRoot.exists()) {
                        dataDir = new File(dataRoot, RELATIVE_RESOURCE_PATH);
                    }
                }
            }
        }
        if (dataDir == null) {
            dataDir = new File(PathManager.getSystemPath(), "PrivacyPolicy");
        }
        dataDir.mkdirs();
        ourCachedPolicyFile = new File(dataDir, CACHED_RESOURCE_NAME);
    }

    public static final class Version
    implements Comparable<Version> {
        public static final Version UNKNOWN = new Version(-1, -1);
        private final int myMajor;
        private final int myMinor;

        public Version(@Nullable String version) {
            int dot;
            int n = dot = version == null ? -1 : version.indexOf(46);
            if (dot > 0) {
                this.myMajor = Integer.parseInt(version.substring(0, dot));
                this.myMinor = Integer.parseInt(version.substring(dot + 1));
            } else {
                this.myMajor = -1;
                this.myMinor = -1;
            }
        }

        private Version(int major, int minor) {
            this.myMajor = major;
            this.myMinor = minor;
        }

        public boolean isUnknown() {
            return this.myMajor < 0 || this.myMinor < 0;
        }

        @Override
        public int compareTo(Version other) {
            if (this.isUnknown()) {
                return other.isUnknown() ? 0 : -1;
            }
            int majorDiff = this.myMajor - other.myMajor;
            return majorDiff != 0 ? majorDiff : this.myMinor - other.myMinor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Version version = (Version)o;
            if (this.myMajor != version.myMajor) {
                return false;
            }
            return this.myMinor == version.myMinor;
        }

        public int hashCode() {
            int result = this.myMajor;
            result = 31 * result + this.myMinor;
            return result;
        }

        public String toString() {
            return this.isUnknown() ? "unknown" : this.myMajor + "." + this.myMinor;
        }
    }
}

