/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaFxFileReferenceProvider
extends PsiReferenceProvider {
    private final String myAcceptedExtension;

    public JavaFxFileReferenceProvider(String acceptedExtension) {
        this.myAcceptedExtension = acceptedExtension;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFileReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFileReferenceProvider", "getReferencesByElement"));
        }
        Object value = ((PsiLiteralExpression)element).getValue();
        if (!(value instanceof String)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFileReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = JavaFxFileReferenceProvider.getReferences(element, this.preprocessValue((String)value), this.myAcceptedExtension);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFileReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    protected String preprocessValue(String value) {
        return value;
    }

    public static PsiReference[] getReferences(@NotNull PsiElement element, String value, final String acceptedExtension) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFileReferenceProvider", "getReferences"));
        }
        final PsiDirectory directory = element.getContainingFile().getOriginalFile().getParent();
        if (directory == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        final boolean startsWithSlash = value.startsWith("/");
        VirtualFileSystem fs = directory.getVirtualFile().getFileSystem();
        FileReferenceSet fileReferenceSet = new FileReferenceSet(value, element, 1, null, fs.isCaseSensitive()){

            @NotNull
            public Collection<PsiFileSystemItem> getDefaultContexts() {
                if (startsWithSlash || !directory.isValid()) {
                    Collection collection = super.getDefaultContexts();
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFileReferenceProvider$1", "getDefaultContexts"));
                    }
                    return collection;
                }
                List<PsiDirectory> list = Collections.singletonList(directory);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFileReferenceProvider$1", "getDefaultContexts"));
                }
                return list;
            }

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return new Condition<PsiFileSystemItem>(){

                    public boolean value(PsiFileSystemItem item) {
                        if (item instanceof PsiDirectory) {
                            return true;
                        }
                        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)item);
                        return virtualFile != null && acceptedExtension.equals(virtualFile.getExtension());
                    }
                };
            }
        };
        if (startsWithSlash) {
            fileReferenceSet.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        }
        return fileReferenceSet.getAllReferences();
    }
}

