/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.ConvertNegatedExpressionWithDemorgansLawIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.GenerateUtilKt;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiUnifierKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/InvertIfConditionIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "copyThenBranchAfter", "ifExpression", "exitStatementExecutedAfter", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "handleSpecialCases", "newCondition", "handleStandardCase", "isApplicableTo", "", "caretOffset", "", "idea"})
public final class InvertIfConditionIntention
extends SelfTargetingIntention<KtIfExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtIfExpression element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!element2.getIfKeyword().getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        return element2.getCondition() != null && element2.getThen() != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtIfExpression element2, @Nullable Editor editor) {
        Editor editor2;
        KtExpression newCondition;
        KtIfExpression ktIfExpression;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = element2.getCondition();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        if ((ktIfExpression = this.handleSpecialCases(element2, newCondition = UtilsKt.negate(ktExpression))) == null) {
            ktIfExpression = this.handleStandardCase(element2, newCondition);
        }
        KtIfExpression newIf = ktIfExpression;
        KtExpression newIfCondition = newIf.getCondition();
        ConvertNegatedExpressionWithDemorgansLawIntention simplifyIntention = new ConvertNegatedExpressionWithDemorgansLawIntention();
        if (newIfCondition instanceof KtPrefixExpression && simplifyIntention.isApplicableTo((KtPrefixExpression)newIfCondition)) {
            simplifyIntention.applyTo((KtPrefixExpression)newIfCondition);
        }
        Editor editor3 = editor;
        if (editor3 != null) {
            void $receiver$iv;
            Editor editor4 = editor3;
            Editor $receiver = (Editor)$receiver$iv;
            GenerateUtilKt.unblockDocument($receiver);
            GenerateUtilKt.moveCaret$default($receiver, newIf.getTextOffset(), null, 2, null);
            editor2 = (Editor)$receiver$iv;
        } else {
            editor2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final KtIfExpression handleStandardCase(KtIfExpression ifExpression2, KtExpression newCondition) {
        Object object;
        void newElement$iv;
        void $receiver$iv;
        KtExpression ktExpression;
        KtExpression elseBranch;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)ifExpression2);
        KtExpression ktExpression2 = ifExpression2.getThen();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        KtExpression thenBranch = ktExpression2;
        KtExpression ktExpression3 = ifExpression2.getElse();
        if (ktExpression3 == null) {
            ktExpression3 = elseBranch = (KtExpression)psiFactory.createEmptyBody();
        }
        if (elseBranch instanceof KtIfExpression) {
            KtExpression ktExpression4 = elseBranch;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"elseBranch");
            ktExpression = psiFactory.createSingleStatementBlock(ktExpression4);
        } else {
            ktExpression = elseBranch;
        }
        KtExpression newThen = ktExpression;
        KtExpression newElse = thenBranch instanceof KtBlockExpression && ((KtBlockExpression)thenBranch).getStatements().isEmpty() ? (KtExpression)null : thenBranch;
        PsiElement psiElement2 = (PsiElement)ifExpression2;
        KtExpression ktExpression5 = newThen;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"newThen");
        PsiElement psiElement3 = (PsiElement)psiFactory.createIf(newCondition, ktExpression5, newElse);
        PsiElement result$iv = $receiver$iv.replace((PsiElement)newElement$iv);
        if (result$iv instanceof KtIfExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement4 = result$iv;
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression6 = ((KtParenthesizedExpression)psiElement4).getExpression();
            if (ktExpression6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
            }
            object = (KtIfExpression)ktExpression6;
        }
        return (KtIfExpression)object;
    }

    /*
     * WARNING - void declaration
     */
    private final KtIfExpression handleSpecialCases(KtIfExpression ifExpression2, KtExpression newCondition) {
        KtExpression thenBranch;
        KtExpression lastThenStatement;
        KtExpression elseBranch = ifExpression2.getElse();
        if (elseBranch != null) {
            return null;
        }
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory((PsiElement)ifExpression2);
        KtExpression ktExpression = ifExpression2.getThen();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        if (UtilsKt.isExitStatement(lastThenStatement = KtPsiUtilKt.lastBlockStatementOrThis(thenBranch = ktExpression))) {
            KtBlockExpression block;
            PsiElement psiElement2 = ifExpression2.getParent();
            if (!(psiElement2 instanceof KtBlockExpression)) {
                psiElement2 = null;
            }
            if ((block = (KtBlockExpression)psiElement2) != null) {
                Object v5;
                List afterIfInBlock2;
                block20: {
                    void $receiver$iv;
                    PsiElement rBrace = block.getRBrace();
                    afterIfInBlock2 = SequencesKt.toList((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings$default((PsiElement)ifExpression2, false, false, 1, null), (Function1)((Function1)new Function1<PsiElement, Boolean>(rBrace){
                        final /* synthetic */ PsiElement $rBrace;

                        public final boolean invoke(@NotNull PsiElement it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return Intrinsics.areEqual((Object)it, (Object)this.$rBrace) ^ true;
                        }
                        {
                            this.$rBrace = psiElement2;
                            super(1);
                        }
                    })));
                    Iterable iterable = afterIfInBlock2;
                    void var12_11 = $receiver$iv;
                    if (var12_11 instanceof List) {
                        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)((Collection)$receiver$iv))));
                        int n = intProgression.getFirst();
                        int n2 = intProgression.getLast();
                        int n3 = intProgression.getStep();
                        int n4 = n;
                        int n5 = n2;
                        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                            while (true) {
                                void i$iv;
                                Object element$iv;
                                if ((element$iv = ((List)$receiver$iv).get((int)i$iv)) instanceof KtExpression) {
                                    v5 = element$iv;
                                    break block20;
                                }
                                if (i$iv == n2) break;
                                i$iv += n3;
                            }
                        }
                        v5 = null;
                    } else {
                        void $receiver$iv$iv;
                        Iterable i$iv = CollectionsKt.reversed((Iterable)$receiver$iv);
                        for (Object element$iv$iv : $receiver$iv$iv) {
                            if (!(element$iv$iv instanceof KtExpression)) continue;
                            v5 = element$iv$iv;
                            break block20;
                        }
                        v5 = null;
                    }
                }
                KtExpression lastStatementInBlock = v5;
                if (lastStatementInBlock != null) {
                    KtExpression exitStatementAfterIf;
                    KtExpression ktExpression2 = exitStatementAfterIf = UtilsKt.isExitStatement(lastStatementInBlock) ? lastStatementInBlock : this.exitStatementExecutedAfter(lastStatementInBlock);
                    if (exitStatementAfterIf != null) {
                        KtExpression exitAfterNewIf;
                        void endIndex$iv;
                        void startIndex$iv;
                        String $receiver$iv;
                        PsiElement first = (PsiElement)CollectionsKt.first((List)afterIfInBlock2);
                        PsiElement last = (PsiElement)CollectionsKt.last((List)afterIfInBlock2);
                        String element$iv$iv = ifExpression2.getContainingFile().getText();
                        int $i$f$firstIsInstanceOrNull = PsiUtilsKt.getStartOffset(first);
                        int $i$f$lastIsInstanceOrNull = PsiUtilsKt.getEndOffset(last);
                        void v7 = $receiver$iv;
                        if (v7 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string = ((String)v7).substring((int)startIndex$iv, (int)endIndex$iv);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        $receiver$iv = string;
                        String string2 = $receiver$iv;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        String newIfBodyText = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                        block.deleteChildRange(first, last);
                        if (lastThenStatement instanceof KtReturnExpression && ((KtReturnExpression)lastThenStatement).getReturnedExpression() == null) {
                            lastThenStatement.delete();
                        }
                        KtIfExpression updatedIf = this.copyThenBranchAfter(ifExpression2);
                        if (Intrinsics.areEqual((Object)exitStatementAfterIf, (Object)lastStatementInBlock) ^ true && ((exitAfterNewIf = this.exitStatementExecutedAfter(updatedIf)) == null || !KotlinPsiUnifierKt.matches((PsiElement)exitAfterNewIf, (PsiElement)exitStatementAfterIf))) {
                            newIfBodyText = newIfBodyText + "\n" + exitStatementAfterIf.getText();
                        }
                        KtExpression newIf = CreateByPatternKt.createExpressionByPattern(factory2, "if ($0) { $1 }", newCondition, newIfBodyText);
                        PsiElement psiElement3 = updatedIf.replace((PsiElement)newIf);
                        if (psiElement3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
                        }
                        return (KtIfExpression)psiElement3;
                    }
                }
            }
        }
        KtExpression ktExpression3 = this.exitStatementExecutedAfter(ifExpression2);
        if (ktExpression3 == null) {
            return null;
        }
        KtExpression exitStatement = ktExpression3;
        KtIfExpression updatedIf = this.copyThenBranchAfter(ifExpression2);
        KtExpression newIf = CreateByPatternKt.createExpressionByPattern(factory2, "if ($0) $1", newCondition, exitStatement);
        PsiElement psiElement4 = updatedIf.replace((PsiElement)newIf);
        if (psiElement4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        }
        return (KtIfExpression)psiElement4;
    }

    /*
     * WARNING - void declaration
     */
    private final KtIfExpression copyThenBranchAfter(KtIfExpression ifExpression2) {
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory((PsiElement)ifExpression2);
        KtExpression ktExpression = ifExpression2.getThen();
        if (ktExpression == null) {
            return ifExpression2;
        }
        KtExpression thenBranch = ktExpression;
        PsiElement parent2 = ifExpression2.getParent();
        if (!(parent2 instanceof KtBlockExpression)) {
            Object object;
            void $receiver$iv;
            Unit unit;
            boolean bl = parent2 instanceof KtContainerNode;
            if (_Assertions.ENABLED) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv$iv = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            KtBlockExpression block = factory2.createEmptyBody();
            block.addAfter((PsiElement)ifExpression2, block.getLBrace());
            PsiElement $i$f$assert = (PsiElement)ifExpression2;
            PsiElement result$iv = $receiver$iv.replace((PsiElement)block);
            if (result$iv instanceof KtBlockExpression) {
                object = result$iv;
            } else {
                PsiElement psiElement2 = result$iv;
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression2 = ((KtParenthesizedExpression)psiElement2).getExpression();
                if (ktExpression2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
                }
                object = (KtBlockExpression)ktExpression2;
            }
            KtBlockExpression newBlock = (KtBlockExpression)object;
            Object object2 = CollectionsKt.single(newBlock.getStatements());
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
            }
            KtIfExpression newIf = (KtIfExpression)object2;
            return this.copyThenBranchAfter(newIf);
        }
        if (thenBranch instanceof KtBlockExpression) {
            PsiChildRange range = KtPsiUtilKt.contentRange((KtBlockExpression)thenBranch);
            if (!range.isEmpty()) {
                parent2.addRangeAfter(range.getFirst(), range.getLast(), (PsiElement)ifExpression2);
                parent2.addAfter(factory2.createNewLine(), (PsiElement)ifExpression2);
            }
        } else {
            parent2.addAfter((PsiElement)thenBranch, (PsiElement)ifExpression2);
            parent2.addAfter(factory2.createNewLine(), (PsiElement)ifExpression2);
        }
        return ifExpression2;
    }

    /*
     * WARNING - void declaration
     */
    private final KtExpression exitStatementExecutedAfter(KtExpression expression2) {
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtBlockExpression) {
            KtExpression lastStatement = (KtExpression)CollectionsKt.last(((KtBlockExpression)parent2).getStatements());
            if (Intrinsics.areEqual((Object)expression2, (Object)lastStatement)) {
                return this.exitStatementExecutedAfter((KtExpression)parent2);
            }
            if (UtilsKt.isExitStatement(lastStatement)) {
                Object element$iv2;
                block16: {
                    void $receiver$iv;
                    Sequence sequence2 = PsiUtilsKt.siblings$default((PsiElement)expression2, false, false, 1, null);
                    for (Object element$iv2 : $receiver$iv) {
                        if (!(element$iv2 instanceof KtExpression)) continue;
                        break block16;
                    }
                    throw (Throwable)new NoSuchElementException("No element of given type found");
                }
                if (Intrinsics.areEqual((Object)((KtExpression)element$iv2), (Object)lastStatement)) {
                    return lastStatement;
                }
            }
            return null;
        }
        PsiElement psiElement2 = parent2;
        if (psiElement2 instanceof KtNamedFunction) {
            if (Intrinsics.areEqual((Object)((KtNamedFunction)parent2).getBodyExpression(), (Object)expression2)) {
                if (!((KtNamedFunction)parent2).hasBlockBody()) {
                    return null;
                }
                DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor((KtDeclaration)parent2);
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                }
                KotlinType returnType2 = ((FunctionDescriptor)declarationDescriptor).getReturnType();
                if (returnType2 == null || !TypeUtilsKt.isUnit(returnType2)) {
                    return null;
                }
                return KtPsiFactoryKt.KtPsiFactory((PsiElement)expression2).createExpression("return");
            }
        } else if (psiElement2 instanceof KtContainerNode) {
            PsiElement pparent = ((KtContainerNode)parent2).getParent();
            PsiElement psiElement3 = pparent;
            if (psiElement3 instanceof KtLoopExpression) {
                if (Intrinsics.areEqual((Object)expression2, (Object)((KtLoopExpression)pparent).getBody())) {
                    return KtPsiFactoryKt.KtPsiFactory((PsiElement)expression2).createExpression("continue");
                }
            } else if (psiElement3 instanceof KtIfExpression && (Intrinsics.areEqual((Object)expression2, (Object)((KtIfExpression)pparent).getThen()) || Intrinsics.areEqual((Object)expression2, (Object)((KtIfExpression)pparent).getElse()))) {
                return this.exitStatementExecutedAfter((KtExpression)pparent);
            }
        }
        return null;
    }

    public InvertIfConditionIntention() {
        super(KtIfExpression.class, "Invert 'if' condition", null, 4, null);
    }
}

