/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.AbstractDiagnostic;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFix;
import org.jetbrains.kotlin.idea.quickfix.CastExpressionFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeParameterTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeVariableTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class QuickFixFactoryForTypeMismatchError
extends KotlinIntentionActionsFactory {
    private static final Logger LOG = Logger.getInstance(QuickFixFactoryForTypeMismatchError.class);

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        KtFunction declaration;
        ResolvedCall<? extends CallableDescriptor> resolvedCall;
        PsiElement expressionParent;
        KtCallableDeclaration function2;
        KotlinType typeToInsert;
        LexicalScope scope2;
        KtProperty property2;
        KotlinType nullableExpected;
        KotlinType expressionType;
        KotlinType expectedType;
        AbstractDiagnostic diagnosticWithParameters;
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError", "doCreateActions"));
        }
        LinkedList<IntentionAction> actions2 = new LinkedList<IntentionAction>();
        BindingContext context = ResolutionUtils.analyzeFully((KtFile)diagnostic.getPsiFile());
        PsiElement diagnosticElement = diagnostic.getPsiElement();
        if (!(diagnosticElement instanceof KtExpression)) {
            LOG.error("Unexpected element: " + diagnosticElement.getText());
            List<IntentionAction> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError", "doCreateActions"));
            }
            return list2;
        }
        KtExpression expression2 = (KtExpression)diagnosticElement;
        if (diagnostic.getFactory() == Errors.TYPE_MISMATCH) {
            diagnosticWithParameters = (DiagnosticWithParameters2)Errors.TYPE_MISMATCH.cast(diagnostic);
            expectedType = (KotlinType)((DiagnosticWithParameters2)diagnosticWithParameters).getA();
            expressionType = (KotlinType)((DiagnosticWithParameters2)diagnosticWithParameters).getB();
        } else if (diagnostic.getFactory() == Errors.NULL_FOR_NONNULL_TYPE) {
            diagnosticWithParameters = (DiagnosticWithParameters1)Errors.NULL_FOR_NONNULL_TYPE.cast(diagnostic);
            expectedType = (KotlinType)((DiagnosticWithParameters1)diagnosticWithParameters).getA();
            expressionType = TypeUtilsKt.makeNullable(expectedType);
        } else if (diagnostic.getFactory() == Errors.CONSTANT_EXPECTED_TYPE_MISMATCH) {
            diagnosticWithParameters = (DiagnosticWithParameters2)Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.cast(diagnostic);
            expectedType = (KotlinType)((DiagnosticWithParameters2)diagnosticWithParameters).getB();
            expressionType = context.getType(expression2);
            if (expressionType == null) {
                LOG.error("No type inferred: " + expression2.getText());
                List<IntentionAction> list3 = Collections.emptyList();
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError", "doCreateActions"));
                }
                return list3;
            }
        } else {
            LOG.error("Unexpected diagnostic: " + DefaultErrorMessages.render(diagnostic));
            List<IntentionAction> list4 = Collections.emptyList();
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError", "doCreateActions"));
            }
            return list4;
        }
        if (!(expression2 instanceof KtBinaryExpressionWithTypeRHS) && !(expression2.getParent() instanceof KtBinaryExpressionWithTypeRHS)) {
            actions2.add(new CastExpressionFix(expression2, expectedType));
        }
        if (!expectedType.isMarkedNullable() && org.jetbrains.kotlin.types.TypeUtils.isNullableType(expressionType) && TypeUtilsKt.isSubtypeOf(expressionType, nullableExpected = TypeUtilsKt.makeNullable(expectedType))) {
            actions2.add(new AddExclExclCallFix((PsiElement)expression2));
        }
        if ((property2 = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)expression2, KtProperty.class)) != null) {
            KtPropertyAccessor getter = property2.getGetter();
            KtExpression initializer2 = property2.getInitializer();
            if (QuickFixUtil.canEvaluateTo(initializer2, expression2) || getter != null && QuickFixUtil.canFunctionOrGetterReturnExpression(getter, expression2)) {
                scope2 = ScopeUtils.getResolutionScope(property2, context, ResolutionUtils.getResolutionFacade(property2));
                typeToInsert = TypeUtils.approximateWithResolvableType(expressionType, scope2, false);
                actions2.add(new ChangeVariableTypeFix(property2, typeToInsert));
            }
        }
        KtCallableDeclaration ktCallableDeclaration = function2 = (expressionParent = expression2.getParent()) instanceof KtReturnExpression ? BindingContextUtilsKt.getTargetFunction((KtReturnExpression)expressionParent, context) : (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)expression2, KtFunction.class, (boolean)true);
        if (function2 instanceof KtFunction && QuickFixUtil.canFunctionOrGetterReturnExpression(function2, expression2)) {
            scope2 = ScopeUtils.getResolutionScope(function2, context, ResolutionUtils.getResolutionFacade(function2));
            typeToInsert = TypeUtils.approximateWithResolvableType(expressionType, scope2, false);
            actions2.add(new ChangeFunctionReturnTypeFix((KtFunction)function2, typeToInsert));
        }
        if (expression2 instanceof KtOperationExpression && (resolvedCall = CallUtilKt.getResolvedCall(expression2, context)) != null && (declaration = QuickFixFactoryForTypeMismatchError.getFunctionDeclaration(resolvedCall)) != null) {
            actions2.add(new ChangeFunctionReturnTypeFix(declaration, expectedType));
        }
        if (expression2 instanceof KtCallExpression && (resolvedCall = CallUtilKt.getResolvedCall(expression2, context)) != null && (declaration = QuickFixFactoryForTypeMismatchError.getFunctionDeclaration(resolvedCall)) != null) {
            actions2.add(new ChangeFunctionReturnTypeFix(declaration, expectedType));
        }
        if ((resolvedCall = CallUtilKt.getParentResolvedCall(expression2, context, true)) != null) {
            KtIfExpression parentIf = QuickFixUtil.getParentIfForBranch(expression2);
            KtExpression argumentExpression = parentIf != null ? parentIf : expression2;
            ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(resolvedCall.getCall(), argumentExpression);
            if (valueArgument != null) {
                KotlinType valueArgumentType;
                KtParameter correspondingParameter = QuickFixUtil.getParameterDeclarationForValueArgument(resolvedCall, valueArgument);
                KtExpression expressionFromArgument = valueArgument.getArgumentExpression();
                KotlinType kotlinType = diagnostic.getFactory() == Errors.NULL_FOR_NONNULL_TYPE ? expressionType : (valueArgumentType = expressionFromArgument != null ? context.getType(expressionFromArgument) : null);
                if (correspondingParameter != null && valueArgumentType != null) {
                    KtCallableDeclaration callable = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)correspondingParameter, KtCallableDeclaration.class, (boolean)true);
                    LexicalScope scope3 = callable != null ? ScopeUtils.getResolutionScope(callable, context, ResolutionUtils.getResolutionFacade(callable)) : null;
                    KotlinType typeToInsert2 = TypeUtils.approximateWithResolvableType(valueArgumentType, scope3, true);
                    actions2.add(new ChangeParameterTypeFix(correspondingParameter, typeToInsert2));
                }
            }
        }
        LinkedList<IntentionAction> linkedList = actions2;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError", "doCreateActions"));
        }
        return linkedList;
    }

    @Nullable
    private static KtFunction getFunctionDeclaration(@NotNull ResolvedCall<?> resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError", "getFunctionDeclaration"));
        }
        PsiElement result2 = QuickFixUtil.safeGetDeclaration(resolvedCall.getResultingDescriptor());
        if (result2 instanceof KtFunction) {
            return (KtFunction)result2;
        }
        return null;
    }
}

