/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration.project;

import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.configuration.project.ProjectEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleProjectEvaluator
implements ProjectEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleProjectEvaluator.class);
    private final ProjectEvaluator delegate;

    public LifecycleProjectEvaluator(ProjectEvaluator delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(ProjectInternal project, ProjectStateInternal state) {
        if (state.getExecuted() || state.getExecuting()) {
            return;
        }
        ProjectEvaluationListener listener = project.getProjectEvaluationBroadcaster();
        try {
            listener.beforeEvaluate(project);
        }
        catch (Exception e) {
            this.addConfigurationFailure(project, state, e);
            return;
        }
        state.setExecuting(true);
        try {
            this.delegate.evaluate(project, state);
        }
        catch (Exception e) {
            this.addConfigurationFailure(project, state, e);
        }
        finally {
            state.setExecuting(false);
            state.executed();
            this.notifyAfterEvaluate(listener, project, state);
        }
    }

    private void notifyAfterEvaluate(ProjectEvaluationListener listener, ProjectInternal project, ProjectStateInternal state) {
        try {
            listener.afterEvaluate(project, state);
        }
        catch (Exception e) {
            if (state.hasFailure()) {
                LOGGER.error("Failed to notify ProjectEvaluationListener.afterEvaluate(), but primary configuration failure takes precedence.", (Throwable)e);
                return;
            }
            this.addConfigurationFailure(project, state, e);
        }
    }

    private void addConfigurationFailure(ProjectInternal project, ProjectStateInternal state, Exception e) {
        ProjectConfigurationException failure = new ProjectConfigurationException(String.format("A problem occurred configuring %s.", project), e);
        state.executed((Throwable)((Object)failure));
    }
}

