/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.refactoring.ElementRenderingUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\f\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0003"}, d2={"renderTrimmed", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "idea"})
public final class ElementRenderingUtilsKt {
    @NotNull
    public static final String renderTrimmed(KtElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u00b3\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\f2\u0006\u0010\r\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\f2\u0006\u0010\r\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\f2\u0006\u0010\t\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\f2\u0006\u0010\r\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\f2\u0006\u0010\r\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\f2\u0006\u0010\r\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\f2\u0006\u0010\r\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\f2\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\f2\u0006\u0010\r\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\f2\u0006\u0010\r\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\f2\u0006\u0010\r\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\f2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\f2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\f2\u0006\u0010\r\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\f2\u0006\u0010\r\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\f2\u0006\u0010@\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\f2\u0006\u0010\r\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020\f2\u0006\u0010N\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020\f2\u0006\u0010(\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\f2\u0006\u0010S\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020\f2\u0006\u0010\r\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020\f2\u0006\u0010\r\u001a\u00020XH\u0016J\u0010\u0010Y\u001a\u00020\f2\u0006\u0010\r\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020\f2\u0006\u0010S\u001a\u00020\\H\u0016J\u0010\u0010]\u001a\u00020\f2\u0006\u0010\r\u001a\u00020^H\u0016J\u0010\u0010_\u001a\u00020\f2\u0006\u0010\r\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020\f2\u0006\u0010b\u001a\u00020cH\u0016J:\u0010d\u001a\u00020\f\"\b\b\u0000\u0010e*\u00020-*\b\u0012\u0004\u0012\u0002He0f2\b\b\u0002\u0010g\u001a\u00020h2\b\b\u0002\u0010i\u001a\u00020h2\b\b\u0002\u0010j\u001a\u00020hH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006k"}, d2={"org/jetbrains/kotlin/idea/refactoring/ElementRenderingUtilsKt$renderTrimmed$Renderer", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "()V", "builder", "Ljava/lang/StringBuilder;", "getBuilder", "()Ljava/lang/StringBuilder;", "render", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitAnnotatedExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtAnnotatedExpression;", "visitArrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitBlockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "visitClassLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitComment", "comment", "Lcom/intellij/psi/PsiComment;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "visitDelegatedSuperTypeEntry", "specifier", "Lorg/jetbrains/kotlin/psi/KtDelegatedSuperTypeEntry;", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "visitElement", "Lcom/intellij/psi/PsiElement;", "visitForExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "visitPostfixExpression", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "visitPrefixExpression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "visitPropertyAccessor", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitReturnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "visitSuperExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "visitSuperTypeCallEntry", "call", "Lorg/jetbrains/kotlin/psi/KtSuperTypeCallEntry;", "visitSuperTypeEntry", "Lorg/jetbrains/kotlin/psi/KtSuperTypeEntry;", "visitSuperTypeList", "list", "Lorg/jetbrains/kotlin/psi/KtSuperTypeList;", "visitThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "visitThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "visitValueArgumentList", "Lorg/jetbrains/kotlin/psi/KtValueArgumentList;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "visitWhiteSpace", "space", "Lcom/intellij/psi/PsiWhiteSpace;", "join", "T", "", "separator", "", "prefix", "postfix", "idea"})
        public final class Renderer
        extends KtTreeVisitorVoid {
            @NotNull
            private final StringBuilder builder;

            @NotNull
            public final StringBuilder getBuilder() {
                return this.builder;
            }

            @NotNull
            public final String render(@NotNull KtElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                element2.accept(this);
                String string = this.builder.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
                return string;
            }

            private final <T extends PsiElement> void join(Iterable<? extends T> $receiver, CharSequence separator, CharSequence prefix, CharSequence postfix) {
                this.builder.append(prefix);
                int count = 0;
                for (PsiElement element2 : $receiver) {
                    if (++count > 1) {
                        this.builder.append(separator);
                    }
                    element2.accept((PsiElementVisitor)this);
                }
                this.builder.append(postfix);
            }

            static /* bridge */ /* synthetic */ void join$default(Renderer renderer2, Iterable iterable, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: join");
                }
                if ((n & 1) != 0) {
                    charSequence = ", ";
                }
                if ((n & 2) != 0) {
                    charSequence2 = "";
                }
                if ((n & 4) != 0) {
                    charSequence3 = "";
                }
                renderer2.join(iterable, charSequence, charSequence2, charSequence3);
            }

            /*
             * WARNING - void declaration
             */
            public void visitWhiteSpace(@NotNull PsiWhiteSpace space) {
                Intrinsics.checkParameterIsNotNull((Object)space, (String)"space");
                String text2 = space.getText();
                int newLine = StringsKt.indexOf$default((CharSequence)text2, (char)'\n', (int)0, (boolean)false, (int)6, null);
                if (newLine != 0) {
                    this.builder.append(' ');
                }
                if (newLine >= 0) {
                    void $receiver$iv;
                    String string = text2;
                    StringBuilder stringBuilder = this.builder;
                    void v0 = $receiver$iv;
                    if (v0 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = ((String)v0).substring(newLine);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    String string3 = string2;
                    stringBuilder.append(string3);
                }
            }

            public void visitComment(@NotNull PsiComment comment) {
                Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
            }

            public void visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.builder.append('(');
                KtExpression ktExpression = expression2.getExpression();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                this.builder.append(')');
            }

            public void visitLabeledExpression(@NotNull KtLabeledExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtExpression ktExpression = expression2.getBaseExpression();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtExpression ktExpression = expression2.getBaseExpression();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitPrefixExpression(@NotNull KtPrefixExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.builder.append(String.valueOf(expression2.getOperationReference().getReferencedName()));
                KtExpression ktExpression = expression2.getBaseExpression();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitPostfixExpression(@NotNull KtPostfixExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtExpression ktExpression = expression2.getBaseExpression();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                this.builder.append(String.valueOf(expression2.getOperationReference().getReferencedName()));
            }

            public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
                Unit unit;
                Unit unit2;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtExpression ktExpression = expression2.getLeft();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                this.builder.append(" " + expression2.getOperationReference().getReferencedName() + " ");
                KtExpression ktExpression2 = expression2.getRight();
                if (ktExpression2 != null) {
                    ktExpression2.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                expression2.getLeft().accept(this);
                this.builder.append(" " + expression2.getOperationReference().getReferencedName() + " ");
                KtTypeReference ktTypeReference = expression2.getRight();
                if (ktTypeReference != null) {
                    ktTypeReference.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitIsExpression(@NotNull KtIsExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                expression2.getLeftHandSide().accept(this);
                this.builder.append(" is ");
                KtTypeReference ktTypeReference = expression2.getTypeReference();
                if (ktTypeReference != null) {
                    ktTypeReference.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtExpression ktExpression = expression2.getArrayExpression();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                this.join((Iterable)expression2.getIndexExpressions(), this.builder, "[", "]");
            }

            public void visitCallExpression(@NotNull KtCallExpression expression2) {
                Unit unit;
                Unit unit2;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtExpression ktExpression = expression2.getCalleeExpression();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                KtValueArgumentList ktValueArgumentList = expression2.getValueArgumentList();
                if (ktValueArgumentList != null) {
                    ktValueArgumentList.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Iterable $receiver$iv = expression2.getLambdaArguments();
                for (T element$iv : $receiver$iv) {
                    KtLambdaArgument it = (KtLambdaArgument)element$iv;
                    this.builder.append("{...}");
                }
            }

            public void visitValueArgumentList(@NotNull KtValueArgumentList list2) {
                Intrinsics.checkParameterIsNotNull((Object)list2, (String)"list");
                this.builder.append(list2.getArguments().isEmpty() ? "()" : "(...)");
            }

            public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                expression2.getReceiverExpression().accept(this);
                this.builder.append(expression2.getOperationTokenNode().getText());
                KtExpression ktExpression = expression2.getSelectorExpression();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtTypeReference ktTypeReference = expression2.getTypeReference();
                if (ktTypeReference != null) {
                    ktTypeReference.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                this.builder.append("::class");
            }

            public void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtTypeReference ktTypeReference = expression2.getTypeReference();
                if (ktTypeReference != null) {
                    ktTypeReference.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                this.builder.append("::");
                this.builder.append(expression2.getCallableReference().getReferencedName());
            }

            public void visitThisExpression(@NotNull KtThisExpression expression2) {
                StringBuilder stringBuilder;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.builder.append("this");
                String string = expression2.getLabelName();
                if (string != null) {
                    String $receiver$iv = string;
                    String it = $receiver$iv;
                    stringBuilder = this.builder.append("@" + it);
                } else {
                    stringBuilder = null;
                }
            }

            public void visitSuperExpression(@NotNull KtSuperExpression expression2) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2;
                Object it;
                Object $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.builder.append("super");
                KtTypeReference ktTypeReference = expression2.getSuperTypeQualifier();
                if (ktTypeReference != null) {
                    $receiver$iv = ktTypeReference;
                    it = $receiver$iv;
                    this.builder.append("<");
                    ((KtElementImplStub)it).accept(this);
                    stringBuilder2 = this.builder.append(">");
                } else {
                    stringBuilder2 = null;
                }
                String string = expression2.getLabelName();
                if (string != null) {
                    $receiver$iv = string;
                    it = (String)$receiver$iv;
                    stringBuilder = this.builder.append("@" + (String)it);
                } else {
                    stringBuilder = null;
                }
            }

            public void visitBreakExpression(@NotNull KtBreakExpression expression2) {
                StringBuilder stringBuilder;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.builder.append("break");
                String string = expression2.getLabelName();
                if (string != null) {
                    String $receiver$iv = string;
                    String it = $receiver$iv;
                    stringBuilder = this.builder.append("@" + it);
                } else {
                    stringBuilder = null;
                }
            }

            public void visitContinueExpression(@NotNull KtContinueExpression expression2) {
                StringBuilder stringBuilder;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.builder.append("continue");
                String string = expression2.getLabelName();
                if (string != null) {
                    String $receiver$iv = string;
                    String it = $receiver$iv;
                    stringBuilder = this.builder.append("@" + it);
                } else {
                    stringBuilder = null;
                }
            }

            public void visitThrowExpression(@NotNull KtThrowExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.builder.append("throw ");
                KtExpression ktExpression = expression2.getThrownExpression();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitReturnExpression(@NotNull KtReturnExpression expression2) {
                Unit unit;
                StringBuilder stringBuilder;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.builder.append("return");
                String string = expression2.getLabelName();
                if (string != null) {
                    String $receiver$iv = string;
                    String it = $receiver$iv;
                    stringBuilder = this.builder.append("@" + it);
                } else {
                    stringBuilder = null;
                }
                this.builder.append(' ');
                KtExpression ktExpression = expression2.getReturnedExpression();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitBlockExpression(@NotNull KtBlockExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                if (expression2.getParent() instanceof KtFunctionLiteral) {
                    super.visitBlockExpression(expression2);
                } else {
                    this.builder.append("{...}");
                }
            }

            public void visitIfExpression(@NotNull KtIfExpression expression2) {
                Unit unit;
                Unit unit2;
                KtExpression it;
                KtExpression $receiver$iv;
                Unit unit3;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.builder.append("if (");
                KtExpression ktExpression = expression2.getCondition();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit3 = Unit.INSTANCE;
                } else {
                    unit3 = null;
                }
                this.builder.append(")");
                KtExpression ktExpression2 = expression2.getThen();
                if (ktExpression2 != null) {
                    $receiver$iv = ktExpression2;
                    it = $receiver$iv;
                    this.builder.append(' ');
                    it.accept(this);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                KtExpression ktExpression3 = expression2.getElse();
                if (ktExpression3 != null) {
                    $receiver$iv = ktExpression3;
                    it = $receiver$iv;
                    this.builder.append(" else ");
                    it.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
                StringBuilder stringBuilder;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.builder.append("when");
                KtExpression ktExpression = expression2.getSubjectExpression();
                if (ktExpression != null) {
                    KtExpression $receiver$iv = ktExpression;
                    KtExpression it = $receiver$iv;
                    this.builder.append('(');
                    it.accept(this);
                    stringBuilder = this.builder.append(')');
                } else {
                    stringBuilder = null;
                }
                this.builder.append(" {...}");
            }

            public void visitForExpression(@NotNull KtForExpression expression2) {
                Unit unit;
                Unit unit2;
                Unit unit3;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.builder.append("for (");
                KtParameter ktParameter = expression2.getLoopParameter();
                PsiElement psiElement2 = ktParameter != null ? (PsiElement)ktParameter : (PsiElement)expression2.getDestructuringParameter();
                if (psiElement2 != null) {
                    psiElement2.accept((PsiElementVisitor)this);
                    unit3 = Unit.INSTANCE;
                } else {
                    unit3 = null;
                }
                this.builder.append(" in ");
                KtExpression ktExpression = expression2.getLoopRange();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                this.builder.append(")");
                KtExpression ktExpression2 = expression2.getBody();
                if (ktExpression2 != null) {
                    KtExpression $receiver$iv = ktExpression2;
                    KtExpression it = $receiver$iv;
                    this.builder.append(' ');
                    it.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitWhileExpression(@NotNull KtWhileExpression expression2) {
                Unit unit;
                Unit unit2;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.builder.append("while (");
                KtExpression ktExpression = expression2.getCondition();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                this.builder.append(")");
                KtExpression ktExpression2 = expression2.getBody();
                if (ktExpression2 != null) {
                    KtExpression $receiver$iv = ktExpression2;
                    KtExpression it = $receiver$iv;
                    this.builder.append(' ');
                    it.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression2) {
                Unit unit;
                Unit unit2;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.builder.append("do");
                KtExpression ktExpression = expression2.getBody();
                if (ktExpression != null) {
                    KtExpression $receiver$iv = ktExpression;
                    KtExpression it = $receiver$iv;
                    this.builder.append(' ');
                    it.accept(this);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                this.builder.append(" while (");
                KtExpression ktExpression2 = expression2.getCondition();
                if (ktExpression2 != null) {
                    ktExpression2.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                this.builder.append(")");
            }

            public void visitTryExpression(@NotNull KtTryExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.builder.append("try {...}");
            }

            /*
             * WARNING - void declaration
             */
            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                Unit unit;
                StringBuilder stringBuilder;
                void destination$iv$iv;
                void $receiver$iv$iv$iv;
                void $receiver$iv$iv;
                StringBuilder stringBuilder2;
                Unit unit2;
                Object it;
                Object $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                this.builder.append("fun");
                KtTypeReference ktTypeReference = function2.getReceiverTypeReference();
                if (ktTypeReference != null) {
                    $receiver$iv = ktTypeReference;
                    it = $receiver$iv;
                    this.builder.append('.');
                    ((KtElementImplStub)it).accept(this);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                String string = function2.getName();
                if (string != null) {
                    $receiver$iv = string;
                    it = (String)$receiver$iv;
                    stringBuilder2 = this.builder.append(" " + (String)it);
                } else {
                    stringBuilder2 = null;
                }
                $receiver$iv = function2.getValueParameters();
                it = $receiver$iv;
                Collection $i$a$2 = new ArrayList<E>();
                void $i$f$let = $receiver$iv$iv;
                for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                    Boolean bl;
                    T element$iv$iv = element$iv$iv$iv;
                    KtParameter it2 = (KtParameter)element$iv$iv;
                    if (it2.getTypeReference() != null) {
                        void $receiver$iv$iv$iv2;
                        void it$iv$iv = $receiver$iv$iv$iv2;
                        bl = destination$iv$iv.add(it$iv$iv);
                        continue;
                    }
                    bl = null;
                }
                CollectionsKt.joinTo$default((Iterable)((List)destination$iv$iv), (Appendable)this.builder, null, (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)114, null);
                PsiElement psiElement2 = function2.getEqualsToken();
                if (psiElement2 != null) {
                    $receiver$iv = psiElement2;
                    it = (PsiElement)$receiver$iv;
                    stringBuilder = this.builder.append(" = ");
                } else {
                    stringBuilder = null;
                }
                KtExpression ktExpression = function2.getBodyExpression();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
                Unit unit;
                StringBuilder stringBuilder;
                Intrinsics.checkParameterIsNotNull((Object)accessor, (String)"accessor");
                this.builder.append(accessor.isGetter() ? "get" : "set");
                this.builder.append("()");
                PsiElement psiElement2 = accessor.getEqualsToken();
                if (psiElement2 != null) {
                    PsiElement $receiver$iv = psiElement2;
                    PsiElement it = $receiver$iv;
                    stringBuilder = this.builder.append(" = ");
                } else {
                    stringBuilder = null;
                }
                KtExpression ktExpression = accessor.getBodyExpression();
                if (ktExpression != null) {
                    ktExpression.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            /*
             * WARNING - void declaration
             */
            public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
                void destination$iv$iv;
                void $receiver$iv$iv$iv;
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
                Iterable $receiver$iv = constructor.getValueParameters();
                Iterable iterable = $receiver$iv;
                Collection collection = new ArrayList<E>();
                void var5_5 = $receiver$iv$iv;
                for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                    Boolean bl;
                    T element$iv$iv = element$iv$iv$iv;
                    KtParameter it = (KtParameter)element$iv$iv;
                    if (it.getTypeReference() != null) {
                        void $receiver$iv$iv$iv2;
                        void it$iv$iv = $receiver$iv$iv$iv2;
                        bl = destination$iv$iv.add(it$iv$iv);
                        continue;
                    }
                    bl = null;
                }
                CollectionsKt.joinTo$default((Iterable)((List)destination$iv$iv), (Appendable)this.builder, null, (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)114, null);
            }

            /*
             * WARNING - void declaration
             */
            public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
                Unit unit;
                void destination$iv$iv;
                void $receiver$iv$iv$iv;
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
                this.builder.append("constructor");
                Iterable $receiver$iv = constructor.getValueParameters();
                Iterable iterable = $receiver$iv;
                Collection collection = new ArrayList<E>();
                void var5_5 = $receiver$iv$iv;
                for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                    Boolean bl;
                    T element$iv$iv = element$iv$iv$iv;
                    KtParameter it = (KtParameter)element$iv$iv;
                    if (it.getTypeReference() != null) {
                        void $receiver$iv$iv$iv2;
                        void it$iv$iv = $receiver$iv$iv$iv2;
                        bl = destination$iv$iv.add(it$iv$iv);
                        continue;
                    }
                    bl = null;
                }
                CollectionsKt.joinTo$default((Iterable)((List)destination$iv$iv), (Appendable)this.builder, null, (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)114, null);
                KtBlockExpression ktBlockExpression = constructor.getBodyExpression();
                if (ktBlockExpression != null) {
                    ktBlockExpression.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
                StringBuilder stringBuilder;
                Unit unit;
                StringBuilder stringBuilder2;
                Object it;
                Object $receiver$iv;
                Unit unit2;
                PsiElement keyword;
                PsiElement psiElement2;
                Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
                KtClassOrObject ktClassOrObject = classOrObject;
                if (ktClassOrObject instanceof KtClass) {
                    psiElement2 = ((KtClass)classOrObject).getClassOrInterfaceKeyword();
                } else if (ktClassOrObject instanceof KtObjectDeclaration) {
                    psiElement2 = ((KtObjectDeclaration)classOrObject).getObjectKeyword();
                } else {
                    return;
                }
                PsiElement psiElement3 = keyword = psiElement2;
                if (psiElement3 != null) {
                    psiElement3.accept((PsiElementVisitor)this);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                String string = classOrObject.getName();
                if (string != null) {
                    $receiver$iv = string;
                    it = $receiver$iv;
                    stringBuilder2 = this.builder.append(" " + (String)it);
                } else {
                    stringBuilder2 = null;
                }
                KtSuperTypeList ktSuperTypeList = classOrObject.getSuperTypeList();
                if (ktSuperTypeList != null) {
                    ktSuperTypeList.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                KtClassBody ktClassBody = classOrObject.getBody();
                if (ktClassBody != null) {
                    $receiver$iv = ktClassBody;
                    it = (KtClassBody)$receiver$iv;
                    stringBuilder = this.builder.append(" {...}");
                } else {
                    stringBuilder = null;
                }
            }

            /*
             * WARNING - void declaration
             */
            public void visitSuperTypeList(@NotNull KtSuperTypeList list2) {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)list2, (String)"list");
                Collection collection = list2.getEntries();
                Renderer renderer2 = this;
                if ($receiver$iv.isEmpty()) {
                    return;
                }
                Collection collection2 = collection;
                Renderer.join$default(renderer2, collection2, this.builder, " : ", null, 4, null);
            }

            public void visitDelegatedSuperTypeEntry(@NotNull KtDelegatedSuperTypeEntry specifier) {
                Unit unit;
                Unit unit2;
                Intrinsics.checkParameterIsNotNull((Object)specifier, (String)"specifier");
                KtTypeReference ktTypeReference = specifier.getTypeReference();
                if (ktTypeReference != null) {
                    ktTypeReference.accept(this);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                KtExpression ktExpression = specifier.getDelegateExpression();
                if (ktExpression != null) {
                    KtExpression $receiver$iv = ktExpression;
                    KtExpression it = $receiver$iv;
                    this.builder.append(" by ");
                    it.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call) {
                Unit unit;
                Unit unit2;
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                KtTypeReference ktTypeReference = call.getTypeReference();
                if (ktTypeReference != null) {
                    ktTypeReference.accept(this);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                KtValueArgumentList ktValueArgumentList = call.getValueArgumentList();
                if (ktValueArgumentList != null) {
                    ktValueArgumentList.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitSuperTypeEntry(@NotNull KtSuperTypeEntry specifier) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)specifier, (String)"specifier");
                KtTypeReference ktTypeReference = specifier.getTypeReference();
                if (ktTypeReference != null) {
                    ktTypeReference.accept(this);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }

            public void visitElement(@NotNull PsiElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                if (element2 instanceof LeafPsiElement) {
                    this.builder.append(((LeafPsiElement)element2).getText());
                } else {
                    super.visitElement(element2);
                }
            }

            public Renderer() {
                this.builder = new StringBuilder();
            }
        }
        return new Renderer().render($receiver);
    }
}

