/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.model.GradleFileModel;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSettingsModel
extends GradleFileModel {
    private static final String INCLUDE = "include";

    @Nullable
    public static GradleSettingsModel get(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel", "get"));
        }
        VirtualFile file = GradleUtil.getGradleSettingsFile(Projects.getBaseDirPath(project));
        return file != null ? GradleSettingsModel.parseBuildFile(file, project, "settings") : null;
    }

    @NotNull
    public static GradleSettingsModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel", "parseBuildFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel", "parseBuildFile"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel", "parseBuildFile"));
        }
        GradleSettingsDslFile settingsFile = new GradleSettingsDslFile(file, project, moduleName);
        settingsFile.parse();
        GradleSettingsModel gradleSettingsModel = new GradleSettingsModel(settingsFile);
        if (gradleSettingsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel", "parseBuildFile"));
        }
        return gradleSettingsModel;
    }

    private GradleSettingsModel(@NotNull GradleSettingsDslFile parsedModel) {
        if (parsedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsedModel", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel", "<init>"));
        }
        super(parsedModel);
    }

    @Nullable
    public List<String> modulePaths() {
        return this.myGradleDslFile.getListProperty(INCLUDE, String.class);
    }

    @NotNull
    public GradleSettingsModel addModulePath(@NotNull String modulePath) {
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel", "addModulePath"));
        }
        if (!modulePath.startsWith(":")) {
            modulePath = ":" + modulePath;
        }
        this.myGradleDslFile.addToListProperty(INCLUDE, modulePath);
        GradleSettingsModel gradleSettingsModel = this;
        if (gradleSettingsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel", "addModulePath"));
        }
        return gradleSettingsModel;
    }

    @NotNull
    public GradleSettingsModel removeModulePath(@NotNull String modulePath) {
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel", "removeModulePath"));
        }
        if (!modulePath.startsWith(":")) {
            this.myGradleDslFile.removeFromListProperty(INCLUDE, ":" + modulePath);
        }
        this.myGradleDslFile.removeFromListProperty(INCLUDE, modulePath);
        GradleSettingsModel gradleSettingsModel = this;
        if (gradleSettingsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel", "removeModulePath"));
        }
        return gradleSettingsModel;
    }

    @NotNull
    public GradleSettingsModel replaceModulePath(@NotNull String oldModulePath, @NotNull String newModulePath) {
        if (oldModulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldModulePath", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel", "replaceModulePath"));
        }
        if (newModulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newModulePath", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel", "replaceModulePath"));
        }
        if (!newModulePath.startsWith(":")) {
            newModulePath = ":" + newModulePath;
        }
        if (!oldModulePath.startsWith(":")) {
            this.myGradleDslFile.replaceInListProperty(INCLUDE, ":" + oldModulePath, newModulePath);
        }
        this.myGradleDslFile.replaceInListProperty(INCLUDE, oldModulePath, newModulePath);
        GradleSettingsModel gradleSettingsModel = this;
        if (gradleSettingsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel", "replaceModulePath"));
        }
        return gradleSettingsModel;
    }

    private static class GradleSettingsDslFile
    extends GradleDslFile {
        private GradleSettingsDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel$GradleSettingsDslFile", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel$GradleSettingsDslFile", "<init>"));
            }
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel$GradleSettingsDslFile", "<init>"));
            }
            super(file, project, moduleName);
        }

        @Override
        public void addDslElement(@NotNull String property, @NotNull GradleDslElement element) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel$GradleSettingsDslFile", "addDslElement"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel$GradleSettingsDslFile", "addDslElement"));
            }
            if (property.equals(GradleSettingsModel.INCLUDE)) {
                this.addToDslLiteralList(property, element);
                return;
            }
            super.addDslElement(property, element);
        }
    }
}

