/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public abstract class WindowStateService {
    public static WindowStateService getInstance() {
        return ServiceManager.getService(WindowStateService.class);
    }

    public static WindowStateService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/util/WindowStateService", "getInstance"));
        }
        return ServiceManager.getService(project, WindowStateService.class);
    }

    public final boolean loadState(@NotNull String key, @NotNull Component component) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/WindowStateService", "loadState"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/util/WindowStateService", "loadState"));
        }
        return this.loadStateFor(null, key, component);
    }

    public abstract boolean loadStateFor(Object var1, @NotNull String var2, @NotNull Component var3);

    public final void saveState(@NotNull String key, @NotNull Component component) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/WindowStateService", "saveState"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/util/WindowStateService", "saveState"));
        }
        this.saveStateFor(null, key, component);
    }

    public abstract void saveStateFor(Object var1, @NotNull String var2, @NotNull Component var3);

    public final Point getLocation(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/WindowStateService", "getLocation"));
        }
        return this.getLocationFor(null, key);
    }

    public abstract Point getLocationFor(Object var1, @NotNull String var2);

    public final void putLocation(@NotNull String key, Point location) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/WindowStateService", "putLocation"));
        }
        this.putLocationFor(null, key, location);
    }

    public abstract void putLocationFor(Object var1, @NotNull String var2, Point var3);

    public final Dimension getSize(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/WindowStateService", "getSize"));
        }
        return this.getSizeFor(null, key);
    }

    public abstract Dimension getSizeFor(Object var1, @NotNull String var2);

    public final void putSize(@NotNull String key, Dimension size) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/WindowStateService", "putSize"));
        }
        this.putSizeFor(null, key, size);
    }

    public abstract void putSizeFor(Object var1, @NotNull String var2, Dimension var3);

    public final Rectangle getBounds(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/WindowStateService", "getBounds"));
        }
        return this.getBoundsFor(null, key);
    }

    public abstract Rectangle getBoundsFor(Object var1, @NotNull String var2);

    public final void putBounds(@NotNull String key, Rectangle bounds) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/WindowStateService", "putBounds"));
        }
        this.putBoundsFor(null, key, bounds);
    }

    public abstract void putBoundsFor(Object var1, @NotNull String var2, Rectangle var3);
}

