/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.RefHashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

abstract class RefHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final RefHashMap.MyMap myMap;
    private final ReferenceQueue<K> myReferenceQueue;
    private final HardKey<K> myHardKeyInstance;
    private Set<Map.Entry<K, V>> entrySet;
    private boolean processingQueue;

    public RefHashMap(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<Key<K>> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/RefHashMap", "<init>"));
        }
        this.myReferenceQueue = new ReferenceQueue();
        this.myHardKeyInstance = new HardKey();
        this.entrySet = null;
        this.myMap = new MyMap(initialCapacity, loadFactor, strategy);
    }

    public RefHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, ContainerUtil.canonicalStrategy());
    }

    public RefHashMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public RefHashMap() {
        this(4);
    }

    @NotNull
    protected abstract <T> Key<T> createKey(@NotNull T var1, @NotNull ReferenceQueue<? super T> var2);

    boolean processQueue() {
        boolean processed = false;
        try {
            Key wk;
            this.processingQueue = true;
            while ((wk = (Key)((Object)this.myReferenceQueue.poll())) != null) {
                this.myMap.remove(wk);
                processed = true;
            }
        }
        finally {
            this.processingQueue = false;
        }
        ((MyMap)this.myMap).compactIfNecessary();
        return processed;
    }

    V removeKey(@NotNull Key<K> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/RefHashMap", "removeKey"));
        }
        return this.myMap.remove(key);
    }

    @NotNull
    Key<K> createKey(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/RefHashMap", "createKey"));
        }
        Key<K> key2 = this.createKey(key, this.myReferenceQueue);
        if (key2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/RefHashMap", "createKey"));
        }
        return key2;
    }

    V putKey(@NotNull Key<K> weakKey, V value) {
        if (weakKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "weakKey", "com/intellij/util/containers/RefHashMap", "putKey"));
        }
        return this.myMap.put(weakKey, value);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        ((HardKey)this.myHardKeyInstance).set(key);
        boolean result2 = this.myMap.containsKey(this.myHardKeyInstance);
        ((HardKey)this.myHardKeyInstance).clear();
        return result2;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        ((HardKey)this.myHardKeyInstance).set(key);
        Object result2 = this.myMap.get(this.myHardKeyInstance);
        ((HardKey)this.myHardKeyInstance).clear();
        return result2;
    }

    @Override
    public V put(@NotNull K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/RefHashMap", "put"));
        }
        this.processQueue();
        return this.putKey(this.createKey(key), value);
    }

    @Override
    public V remove(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/RefHashMap", "remove"));
        }
        this.processQueue();
        ((HardKey)this.myHardKeyInstance).set(key);
        Object result2 = this.myMap.remove(this.myHardKeyInstance);
        ((HardKey)this.myHardKeyInstance).clear();
        return result2;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/RefHashMap", "entrySet"));
        }
        return set;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<Key<K>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = RefHashMap.this.myMap.entrySet();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            Iterator iterator2 = new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<Key<K>, V>> hashIterator;
                private MyEntry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        Key wk = ent.getKey();
                        Object k = null;
                        if (wk != null) {
                            Object k2 = wk.get();
                            k = k2;
                            if (k2 == null) continue;
                        }
                        this.next = new MyEntry(ent, k);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    MyEntry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
            if (iterator2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/RefHashMap$EntrySet", "iterator"));
            }
            return iterator2;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            boolean toRemove;
            RefHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            RefHashMap.this.myHardKeyInstance.set(e.getKey());
            HardKey key = RefHashMap.this.myHardKeyInstance;
            Object hv = RefHashMap.this.myMap.get(key);
            boolean bl = hv == null ? ev == null && RefHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
            if (toRemove) {
                RefHashMap.this.myMap.remove(key);
            }
            RefHashMap.this.myHardKeyInstance.clear();
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry entry : this.hashEntrySet) {
                Object v;
                Key wk = entry.getKey();
                if (wk == null) continue;
                h += wk.hashCode() ^ ((v = entry.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private static class MyEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<?, V> ent;
        private final K key;

        private MyEntry(@NotNull Map.Entry<?, V> ent, K key) {
            if (ent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ent", "com/intellij/util/containers/RefHashMap$MyEntry", "<init>"));
            }
            this.ent = ent;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.ent.setValue(value);
        }

        private static boolean valEquals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return MyEntry.valEquals(this.key, e.getKey()) && MyEntry.valEquals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }
    }

    private static class HardKey<T>
    implements Key<T> {
        private T myObject;
        private int myHash;

        private HardKey() {
        }

        @Override
        public T get() {
            return this.myObject;
        }

        private void set(@NotNull T object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/containers/RefHashMap$HardKey", "set"));
            }
            this.myObject = object;
            this.myHash = object.hashCode();
        }

        private void clear() {
            this.myObject = null;
            this.myHash = 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            T t = this.myObject;
            Object u = ((Key)o).get();
            return t == u || t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }
    }

    static interface Key<T> {
        public T get();
    }

    private class MyMap
    extends THashMap<Key<K>, V> {
        private MyMap(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<Key<K>> strategy) {
            if (strategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/RefHashMap$MyMap", "<init>"));
            }
            super(initialCapacity, loadFactor, strategy);
        }

        @Override
        public void compact() {
            if (!RefHashMap.this.processingQueue) {
                super.compact();
            }
        }

        private void compactIfNecessary() {
            if (this._deadkeys > this._size && this.capacity() > 42) {
                this.compact();
            }
        }

        @Override
        protected void rehash(int newCapacity) {
            int oldCapacity = this._set.length;
            Object[] oldKeys = this._set;
            Object[] oldVals = this._values;
            this._set = new Object[newCapacity];
            this._values = new Object[newCapacity];
            int i = oldCapacity;
            while (i-- > 0) {
                Key k;
                Object key;
                Object o = oldKeys[i];
                if (o == null || o == REMOVED || (key = (k = (Key)o).get()) == null) continue;
                int index2 = this.insertionIndex(k);
                if (index2 < 0) {
                    this.throwObjectContractViolation(this._set[-index2 - 1], o + "; key: " + key);
                }
                this._set[index2] = o;
                this._values[index2] = oldVals[i];
            }
        }
    }
}

