/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.EnterProcessor;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlainEnterProcessor
implements EnterProcessor {
    @Override
    public boolean doEnter(Editor editor, PsiElement psiElement, boolean isModified) {
        if (PlainEnterProcessor.expandCodeBlock(editor, psiElement)) {
            return true;
        }
        PlainEnterProcessor.getEnterHandler("EditorStartNewLine").execute(editor, ((EditorEx)editor).getDataContext());
        return true;
    }

    static boolean expandCodeBlock(Editor editor, PsiElement psiElement) {
        PsiCodeBlock block = PlainEnterProcessor.getControlStatementBlock(editor.getCaretModel().getOffset(), psiElement);
        if (PlainEnterProcessor.processExistingBlankLine(editor, block, psiElement)) {
            return true;
        }
        if (block == null) {
            return false;
        }
        EditorActionHandler enterHandler = PlainEnterProcessor.getEnterHandler("EditorStartNewLine");
        PsiElement firstElement = block.getFirstBodyElement();
        if (firstElement == null) {
            firstElement = block.getRBrace();
            enterHandler = PlainEnterProcessor.getEnterHandler("EditorEnter");
        }
        editor.getCaretModel().moveToOffset(firstElement != null ? firstElement.getTextRange().getStartOffset() : block.getTextRange().getEndOffset());
        enterHandler.execute(editor, ((EditorEx)editor).getDataContext());
        return true;
    }

    private static EditorActionHandler getEnterHandler(String actionId) {
        return EditorActionManager.getInstance().getActionHandler(actionId);
    }

    @Nullable
    private static PsiCodeBlock getControlStatementBlock(int caret, PsiElement element) {
        PsiCodeBlock methodBody;
        if (element instanceof PsiTryStatement) {
            PsiCodeBlock tryBlock = ((PsiTryStatement)element).getTryBlock();
            if (tryBlock != null && caret < tryBlock.getTextRange().getEndOffset()) {
                return tryBlock;
            }
            for (PsiCodeBlock catchBlock : ((PsiTryStatement)element).getCatchBlocks()) {
                if (catchBlock == null || caret >= catchBlock.getTextRange().getEndOffset()) continue;
                return catchBlock;
            }
            return ((PsiTryStatement)element).getFinallyBlock();
        }
        if (element instanceof PsiMethod && (methodBody = ((PsiMethod)element).getBody()) != null) {
            return methodBody;
        }
        if (element instanceof PsiSwitchStatement) {
            return ((PsiSwitchStatement)element).getBody();
        }
        PsiStatement body = null;
        if (element instanceof PsiIfStatement) {
            body = ((PsiIfStatement)element).getThenBranch();
            if (body != null && caret > body.getTextRange().getEndOffset()) {
                body = ((PsiIfStatement)element).getElseBranch();
            }
        } else if (element instanceof PsiWhileStatement) {
            body = ((PsiWhileStatement)element).getBody();
        } else if (element instanceof PsiForStatement) {
            body = ((PsiForStatement)element).getBody();
        } else if (element instanceof PsiForeachStatement) {
            body = ((PsiForeachStatement)element).getBody();
        } else if (element instanceof PsiDoWhileStatement) {
            body = ((PsiDoWhileStatement)element).getBody();
        }
        return body instanceof PsiBlockStatement ? ((PsiBlockStatement)body).getCodeBlock() : null;
    }

    private static boolean processExistingBlankLine(@NotNull Editor editor, @Nullable PsiCodeBlock codeBlock, @Nullable PsiElement element) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/smartEnter/PlainEnterProcessor", "processExistingBlankLine"));
        }
        PsiWhiteSpace whiteSpace = null;
        if (codeBlock == null) {
            PsiElement next;
            if (element != null && !(element instanceof PsiMember) && (next = PsiTreeUtil.nextLeaf((PsiElement)element)) instanceof PsiWhiteSpace) {
                whiteSpace = (PsiWhiteSpace)next;
            }
        } else {
            whiteSpace = (PsiWhiteSpace)PsiTreeUtil.findChildOfType((PsiElement)codeBlock, PsiWhiteSpace.class);
            if (whiteSpace == null) {
                return false;
            }
            PsiElement lbraceCandidate = whiteSpace.getPrevSibling();
            if (lbraceCandidate == null) {
                return false;
            }
            ASTNode node = lbraceCandidate.getNode();
            if (node == null || node.getElementType() != JavaTokenType.LBRACE) {
                return false;
            }
        }
        if (whiteSpace == null) {
            return false;
        }
        TextRange textRange = whiteSpace.getTextRange();
        Document document = editor.getDocument();
        CharSequence whiteSpaceText = document.getCharsSequence().subSequence(textRange.getStartOffset(), textRange.getEndOffset());
        if (StringUtil.countNewLines((CharSequence)whiteSpaceText) < 2) {
            return false;
        }
        int i = CharArrayUtil.shiftForward((CharSequence)whiteSpaceText, (int)0, (String)" \t");
        if (i >= whiteSpaceText.length() - 1) {
            assert (false) : String.format("code block: %s, white space: %s", codeBlock == null ? "undefined" : codeBlock.getTextRange(), whiteSpace.getTextRange());
            return false;
        }
        editor.getCaretModel().moveToOffset(i + 1 + textRange.getStartOffset());
        EditorActionManager actionManager = EditorActionManager.getInstance();
        EditorActionHandler actionHandler = actionManager.getActionHandler("EditorLineEnd");
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
        if (dataContext == null) {
            if ((i = CharArrayUtil.shiftForwardUntil((CharSequence)whiteSpaceText, (int)i, (String)"\n")) >= whiteSpaceText.length()) {
                i = whiteSpaceText.length();
            }
            editor.getCaretModel().moveToOffset(i + textRange.getStartOffset());
        } else {
            actionHandler.execute(editor, dataContext);
        }
        return true;
    }
}

