/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.ShowHideIntentionIconLookupAction;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.lookup.impl.Advertiser;
import com.intellij.codeInsight.lookup.impl.CompletionExtender;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Alarm;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LookupUi {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.lookup.impl.LookupUi");
    @NotNull
    private final LookupImpl myLookup;
    private final Advertiser myAdvertiser;
    private final JBList myList;
    private final Project myProject;
    private final ModalityState myModalityState;
    private final Alarm myHintAlarm;
    private final JLabel mySortingLabel;
    private final JScrollPane myScrollPane;
    private final JButton myScrollBarIncreaseButton;
    private final AsyncProcessIcon myProcessIcon;
    private final JPanel myIconPanel;
    private final LookupLayeredPane myLayeredPane;
    private LookupHint myElementHint;
    private int myMaximumHeight;
    private Boolean myPositionedAbove;

    LookupUi(@NotNull LookupImpl lookup, Advertiser advertiser, JBList list, Project project2) {
        if (lookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/lookup/impl/LookupUi", "<init>"));
        }
        this.myHintAlarm = new Alarm();
        this.mySortingLabel = new JLabel();
        this.myProcessIcon = new AsyncProcessIcon("Completion progress");
        this.myIconPanel = new JPanel(new BorderLayout());
        this.myLayeredPane = new LookupLayeredPane();
        this.myElementHint = null;
        this.myMaximumHeight = Integer.MAX_VALUE;
        this.myPositionedAbove = null;
        this.myLookup = lookup;
        this.myAdvertiser = advertiser;
        this.myList = list;
        this.myProject = project2;
        this.myIconPanel.setVisible(false);
        this.myIconPanel.setBackground(Color.LIGHT_GRAY);
        this.myIconPanel.add((Component)this.myProcessIcon);
        JComponent adComponent = advertiser.getAdComponent();
        adComponent.setBorder(new EmptyBorder(0, 1, 1, 2 + AllIcons.Ide.LookupRelevance.getIconWidth()));
        this.myLayeredPane.mainPanel.add((Component)adComponent, "South");
        this.myScrollBarIncreaseButton = new JButton();
        this.myScrollBarIncreaseButton.setFocusable(false);
        this.myScrollBarIncreaseButton.setRequestFocusEnabled(false);
        this.myScrollPane = new JBScrollPane((Component)lookup.getList());
        this.myScrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        this.myScrollPane.setHorizontalScrollBarPolicy(31);
        this.myScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(13, -1));
        this.myScrollPane.getVerticalScrollBar().setUI((ScrollBarUI)new ButtonlessScrollBarUI(){

            protected JButton createIncreaseButton(int orientation) {
                return LookupUi.this.myScrollBarIncreaseButton;
            }
        });
        ((Container)lookup.getComponent()).add((Component)((Object)this.myLayeredPane), "Center");
        this.fixMouseCheaters();
        this.myLayeredPane.mainPanel.add((Component)this.myScrollPane, "Center");
        this.myScrollPane.setBorder(null);
        this.mySortingLabel.setBorder(new LineBorder((Color)new JBColor(Color.LIGHT_GRAY, JBColor.background())));
        this.mySortingLabel.setOpaque(true);
        new ChangeLookupSorting().installOn(this.mySortingLabel);
        this.updateSorting();
        this.myModalityState = ModalityState.stateForComponent((Component)lookup.getTopLevelEditor().getComponent());
        this.addListeners();
        this.updateScrollbarVisibility();
        Disposer.register((Disposable)lookup, (Disposable)this.myProcessIcon);
        Disposer.register((Disposable)lookup, (Disposable)this.myHintAlarm);
    }

    private void addListeners() {
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (LookupUi.this.myLookup.isLookupDisposed()) {
                    return;
                }
                LookupUi.this.myHintAlarm.cancelAllRequests();
                LookupElement item = LookupUi.this.myLookup.getCurrentItem();
                if (item != null) {
                    LookupUi.this.updateHint(item);
                }
            }
        });
        final Alarm alarm = new Alarm((Disposable)this.myLookup);
        this.myScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (((LookupUi)LookupUi.this).myLookup.myUpdating || LookupUi.this.myLookup.isLookupDisposed()) {
                    return;
                }
                alarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        LookupUi.this.myLookup.refreshUi(false, false);
                    }
                }, 300, LookupUi.this.myModalityState);
            }
        });
    }

    private void updateScrollbarVisibility() {
        boolean showSorting = this.myLookup.isCompletion() && this.myList.getModel().getSize() >= 3;
        this.mySortingLabel.setVisible(showSorting);
        this.myScrollPane.setVerticalScrollBarPolicy(showSorting ? 22 : 20);
    }

    private void updateHint(@NotNull LookupElement item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/codeInsight/lookup/impl/LookupUi", "updateHint"));
        }
        this.myLookup.checkValid();
        if (this.myElementHint != null) {
            this.myLayeredPane.remove(this.myElementHint);
            this.myElementHint = null;
            JRootPane rootPane = ((JComponent)this.myLookup.getComponent()).getRootPane();
            if (rootPane != null) {
                rootPane.revalidate();
                rootPane.repaint();
            }
        }
        if (!item.isValid()) {
            return;
        }
        Collection<LookupElementAction> actions = this.myLookup.getActionsFor(item);
        if (!actions.isEmpty()) {
            this.myHintAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    if (!ShowHideIntentionIconLookupAction.shouldShowLookupHint() || ((CompletionExtender)LookupUi.this.myList.getExpandableItemsHandler()).isShowing()) {
                        return;
                    }
                    LookupUi.this.myElementHint = new LookupHint();
                    LookupUi.this.myLayeredPane.add(LookupUi.this.myElementHint, 20, 0);
                    LookupUi.this.myLayeredPane.layoutHint();
                }
            }, 500, this.myModalityState);
        }
    }

    private void fixMouseCheaters() {
        this.myLookup.getComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                final ActionCallback done2 = IdeFocusManager.getInstance((Project)LookupUi.this.myProject).requestFocus((Component)LookupUi.this.myLookup.getTopLevelEditor().getContentComponent(), true);
                IdeFocusManager.getInstance((Project)LookupUi.this.myProject).typeAheadUntil(done2);
                new Alarm((Disposable)LookupUi.this.myLookup).addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (!done2.isDone()) {
                            done2.setDone();
                        }
                    }
                }, 300, LookupUi.this.myModalityState);
            }
        });
    }

    void setCalculating(boolean calculating) {
        Runnable setVisible = new Runnable(){

            @Override
            public void run() {
                LookupUi.this.myIconPanel.setVisible(LookupUi.this.myLookup.isCalculating());
            }
        };
        if (this.myLookup.isCalculating()) {
            new Alarm((Disposable)this.myLookup).addRequest(setVisible, 100, this.myModalityState);
        } else {
            setVisible.run();
        }
        if (calculating) {
            this.myProcessIcon.resume();
        } else {
            this.myProcessIcon.suspend();
        }
    }

    private void updateSorting() {
        boolean lexi = UISettings.getInstance().SORT_LOOKUP_ELEMENTS_LEXICOGRAPHICALLY;
        this.mySortingLabel.setIcon(lexi ? AllIcons.Ide.LookupAlphanumeric : AllIcons.Ide.LookupRelevance);
        this.mySortingLabel.setToolTipText(lexi ? "Click to sort variants by relevance" : "Click to sort variants alphabetically");
        this.myLookup.resort(false);
    }

    void refreshUi(boolean selectionVisible, boolean itemsChanged, boolean reused, boolean onExplicitAction) {
        Editor editor = this.myLookup.getTopLevelEditor();
        if (editor.getComponent().getRootPane() == null || editor instanceof EditorWindow && !((EditorWindow)editor).isValid()) {
            return;
        }
        this.updateScrollbarVisibility();
        if (this.myLookup.myResizePending || itemsChanged) {
            this.myMaximumHeight = Integer.MAX_VALUE;
        }
        Rectangle rectangle = this.calculatePosition();
        this.myMaximumHeight = rectangle.height;
        if (this.myLookup.myResizePending || itemsChanged) {
            this.myLookup.myResizePending = false;
            this.myLookup.pack();
        }
        HintManagerImpl.updateLocation(this.myLookup, editor, rectangle.getLocation());
        if (reused || selectionVisible || onExplicitAction) {
            this.myLookup.ensureSelectionVisible(false);
        }
    }

    boolean isPositionedAboveCaret() {
        return this.myPositionedAbove != null && this.myPositionedAbove != false;
    }

    Rectangle calculatePosition() {
        JRootPane rootPane;
        Component lookupComponent = this.myLookup.getComponent();
        Dimension dim = ((JComponent)lookupComponent).getPreferredSize();
        int lookupStart = this.myLookup.getLookupStart();
        Editor editor = this.myLookup.getTopLevelEditor();
        if (lookupStart < 0 || lookupStart > editor.getDocument().getTextLength()) {
            LOG.error(lookupStart + "; offset=" + editor.getCaretModel().getOffset() + "; element=" + this.myLookup.getPsiElement());
        }
        LogicalPosition pos = editor.offsetToLogicalPosition(lookupStart);
        Point location = editor.logicalPositionToXY(pos);
        location.y += editor.getLineHeight();
        location.x -= this.myLookup.myCellRenderer.getTextIndent();
        Window window = UIUtil.getWindow((Component)lookupComponent);
        if (window != null) {
            Point point = SwingUtilities.convertPoint(lookupComponent, 0, 0, window);
            location.x -= point.x;
        }
        SwingUtilities.convertPointToScreen(location, editor.getContentComponent());
        Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Point)location);
        if (!this.isPositionedAboveCaret()) {
            int shiftLow = screenRectangle.height - (location.y + dim.height);
            this.myPositionedAbove = shiftLow < 0 && shiftLow < location.y - dim.height && location.y >= dim.height;
        }
        if (this.isPositionedAboveCaret()) {
            location.y -= dim.height + editor.getLineHeight();
            if (pos.line == 0) {
                ++location.y;
            }
        }
        if (!screenRectangle.contains(location)) {
            location = ScreenUtil.findNearestPointOnBorder((Rectangle)screenRectangle, (Point)location);
        }
        if ((rootPane = editor.getComponent().getRootPane()) == null) {
            LOG.error("editor.disposed=" + editor.isDisposed() + "; lookup.disposed=" + this.myLookup.isLookupDisposed() + "; editorShowing=" + editor.getContentComponent().isShowing());
        }
        Rectangle candidate = new Rectangle(location, dim);
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)candidate);
        SwingUtilities.convertPointFromScreen(location, rootPane.getLayeredPane());
        this.myMaximumHeight = candidate.height;
        return new Rectangle(location.x, location.y, dim.width, candidate.height);
    }

    private class ChangeLookupSorting
    extends ClickListener {
        private ChangeLookupSorting() {
        }

        public boolean onClick(@NotNull MouseEvent e, int clickCount) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupUi$ChangeLookupSorting", "onClick"));
            }
            DataContext context = DataManager.getInstance().getDataContext((Component)LookupUi.this.mySortingLabel);
            DefaultActionGroup group = new DefaultActionGroup();
            group.add(this.createSortingAction(true));
            group.add(this.createSortingAction(false));
            JBPopupFactory.getInstance().createActionGroupPopup("Change sorting", (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).showInBestPositionFor(context);
            return true;
        }

        private AnAction createSortingAction(boolean checked) {
            boolean currentSetting = UISettings.getInstance().SORT_LOOKUP_ELEMENTS_LEXICOGRAPHICALLY;
            final boolean newSetting = checked ? currentSetting : !currentSetting;
            return new DumbAwareAction(newSetting ? "Sort lexicographically" : "Sort by relevance", null, checked ? PlatformIcons.CHECK_ICON : null){

                public void actionPerformed(AnActionEvent e) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.changeSorting");
                    UISettings.getInstance().SORT_LOOKUP_ELEMENTS_LEXICOGRAPHICALLY = newSetting;
                    LookupUi.this.updateSorting();
                }
            };
        }
    }

    private class LookupHint
    extends JLabel {
        private final Border INACTIVE_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        private final Border ACTIVE_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(1, 1, 1, 1));

        private LookupHint() {
            this.setOpaque(false);
            this.setBorder(this.INACTIVE_BORDER);
            this.setIcon(AllIcons.Actions.IntentionBulb);
            String acceleratorsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
            if (acceleratorsText.length() > 0) {
                this.setToolTipText(CodeInsightBundle.message((String)"lightbulb.tooltip", (Object[])new Object[]{acceleratorsText}));
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    LookupHint.this.setBorder(LookupHint.this.ACTIVE_BORDER);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    LookupHint.this.setBorder(LookupHint.this.INACTIVE_BORDER);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!e.isPopupTrigger() && e.getButton() == 1) {
                        LookupUi.this.myLookup.showElementActions();
                    }
                }
            });
        }
    }

    private class LookupLayeredPane
    extends JBLayeredPane {
        final JPanel mainPanel = new JPanel(new BorderLayout());

        private LookupLayeredPane() {
            this.add(this.mainPanel, 0, 0);
            this.add(LookupUi.this.myIconPanel, 42, 0);
            this.add(LookupUi.this.mySortingLabel, 10, 0);
            this.setLayout((LayoutManager)new AbstractLayoutManager(){

                public Dimension preferredLayoutSize(@Nullable Container parent) {
                    int maxCellWidth = ((LookupUi)LookupUi.this).myLookup.myLookupTextWidth + ((LookupUi)LookupUi.this).myLookup.myCellRenderer.getTextIndent();
                    int scrollBarWidth = ((LookupUi)LookupUi.this).myScrollPane.getPreferredSize().width - ((LookupUi)LookupUi.this).myScrollPane.getViewport().getPreferredSize().width;
                    int listWidth = Math.min(scrollBarWidth + maxCellWidth, UISettings.getInstance().MAX_LOOKUP_WIDTH2);
                    Dimension adSize = LookupUi.this.myAdvertiser.getAdComponent().getPreferredSize();
                    int panelHeight = ((LookupUi)LookupUi.this).myList.getPreferredScrollableViewportSize().height + adSize.height;
                    if (LookupUi.this.myList.getModel().getSize() > LookupUi.this.myList.getVisibleRowCount() && LookupUi.this.myList.getVisibleRowCount() >= 5) {
                        panelHeight -= LookupUi.this.myList.getFixedCellHeight() / 2;
                    }
                    return new Dimension(Math.max(listWidth, adSize.width), Math.min(panelHeight, LookupUi.this.myMaximumHeight));
                }

                public void layoutContainer(Container parent) {
                    Dimension size = LookupLayeredPane.this.getSize();
                    LookupLayeredPane.this.mainPanel.setSize(size);
                    LookupLayeredPane.this.mainPanel.validate();
                    if (!((LookupUi)LookupUi.this).myLookup.myResizePending) {
                        int listHeight;
                        Dimension preferredSize = this.preferredLayoutSize(null);
                        if (preferredSize.width != size.width) {
                            UISettings.getInstance().MAX_LOOKUP_WIDTH2 = Math.max(500, size.width);
                        }
                        if ((listHeight = LookupUi.this.myList.getLastVisibleIndex() - LookupUi.this.myList.getFirstVisibleIndex() + 1) != LookupUi.this.myList.getModel().getSize() && listHeight != LookupUi.this.myList.getVisibleRowCount() && preferredSize.height != size.height) {
                            UISettings.getInstance().MAX_LOOKUP_LIST_HEIGHT = Math.max(5, listHeight);
                        }
                    }
                    LookupUi.this.myList.setFixedCellWidth(LookupUi.this.myScrollPane.getViewport().getWidth());
                    LookupLayeredPane.this.layoutStatusIcons();
                    LookupLayeredPane.this.layoutHint();
                }
            });
        }

        private void layoutStatusIcons() {
            int adHeight = ((LookupUi)LookupUi.this).myAdvertiser.getAdComponent().getPreferredSize().height;
            Dimension buttonSize = adHeight > 0 || !LookupUi.this.mySortingLabel.isVisible() ? new Dimension(0, 0) : new Dimension(AllIcons.Ide.LookupRelevance.getIconWidth(), AllIcons.Ide.LookupRelevance.getIconHeight());
            LookupUi.this.myScrollBarIncreaseButton.setPreferredSize(buttonSize);
            LookupUi.this.myScrollBarIncreaseButton.setMinimumSize(buttonSize);
            LookupUi.this.myScrollBarIncreaseButton.setMaximumSize(buttonSize);
            JScrollBar vScrollBar = LookupUi.this.myScrollPane.getVerticalScrollBar();
            vScrollBar.revalidate();
            vScrollBar.repaint();
            Dimension iconSize = LookupUi.this.myProcessIcon.getPreferredSize();
            LookupUi.this.myIconPanel.setBounds(this.getWidth() - iconSize.width - (vScrollBar.isVisible() ? vScrollBar.getWidth() : 0), 0, iconSize.width, iconSize.height);
            Dimension sortSize = LookupUi.this.mySortingLabel.getPreferredSize();
            int sortWidth = vScrollBar.isVisible() ? vScrollBar.getWidth() : sortSize.width;
            int sortHeight = Math.max(sortSize.height, adHeight);
            LookupUi.this.mySortingLabel.setBounds(this.getWidth() - sortWidth, this.getHeight() - sortHeight, sortSize.width, sortHeight);
        }

        void layoutHint() {
            if (LookupUi.this.myElementHint != null && LookupUi.this.myLookup.getCurrentItem() != null) {
                Rectangle bounds = LookupUi.this.myLookup.getCurrentItemBounds();
                LookupUi.this.myElementHint.setSize(LookupUi.this.myElementHint.getPreferredSize());
                JScrollBar sb = LookupUi.this.myScrollPane.getVerticalScrollBar();
                int x = bounds.x + bounds.width - LookupUi.this.myElementHint.getWidth() + (sb.isVisible() ? sb.getWidth() : 0);
                x = Math.min(x, this.getWidth() - LookupUi.this.myElementHint.getWidth());
                LookupUi.this.myElementHint.setLocation(new Point(x, bounds.y));
            }
        }
    }
}

