/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.impl.AddNotNullAnnotationFix;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.nullable.AnnotateOverriddenMethodParameterFix;
import com.intellij.codeInspection.nullable.ChangeNullableDefaultsFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class NullableStuffInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @Deprecated
    public boolean REPORT_NULLABLE_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE = true;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_PARAMETER_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_GETTER = true;
    public boolean IGNORE_EXTERNAL_SUPER_NOTNULL = false;
    public boolean REQUIRE_NOTNULL_FIELDS_INITIALIZED = true;
    public boolean REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED = false;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_SETTER_PARAMETER = true;
    @Deprecated
    public boolean REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS = true;
    public boolean REPORT_NULLS_PASSED_TO_NON_ANNOTATED_METHOD = true;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.nullable.NullableStuffInspectionBase");

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "writeSettings"));
        }
        super.writeSettings(node);
        for (Element child : new ArrayList(node.getChildren())) {
            String name = child.getAttributeValue("name");
            String value = child.getAttributeValue("value");
            if (!("IGNORE_EXTERNAL_SUPER_NOTNULL".equals(name) && "false".equals(value) || "REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED".equals(name) && "false".equals(value)) && (!"REQUIRE_NOTNULL_FIELDS_INITIALIZED".equals(name) || !"true".equals(value))) continue;
            node.removeContent((Content)child);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "buildVisitor"));
        }
        PsiFile file2 = holder.getFile();
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2) || NullableStuffInspectionBase.nullabilityAnnotationsNotAvailable(file2)) {
            PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){};
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                NullableStuffInspectionBase.this.checkNullableStuffForMethod(method, holder);
            }

            public void visitField(PsiField field) {
                PsiType type = field.getType();
                Annotated annotated = NullableStuffInspectionBase.check((PsiModifierListOwner)field, holder, type);
                if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type)) {
                    return;
                }
                Project project2 = holder.getProject();
                NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
                if (annotated.isDeclaredNotNull ^ annotated.isDeclaredNullable) {
                    List annoToRemove;
                    String anno = annotated.isDeclaredNotNull ? manager.getDefaultNotNull() : manager.getDefaultNullable();
                    List list = annoToRemove = annotated.isDeclaredNotNull ? manager.getNullables() : manager.getNotNulls();
                    if (!NullableStuffInspectionBase.checkNonStandardAnnotations(field, annotated, manager, anno, holder)) {
                        return;
                    }
                    NullableStuffInspectionBase.this.checkAccessors(field, annotated, project2, manager, anno, annoToRemove, holder);
                    NullableStuffInspectionBase.this.checkConstructorParameters(field, annotated, manager, anno, annoToRemove, holder);
                }
                if (NullableStuffInspectionBase.this.REQUIRE_NOTNULL_FIELDS_INITIALIZED && !annotated.isDeclaredNullable) {
                    NullableStuffInspectionBase.checkNotNullFieldsInitialized(field, manager, holder);
                }
            }

            public void visitParameter(PsiParameter parameter) {
                NullableStuffInspectionBase.check((PsiModifierListOwner)parameter, holder, parameter.getType());
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                PsiClass psiClass;
                if (!"org.jetbrains.annotations.NotNull".equals(annotation.getQualifiedName())) {
                    return;
                }
                PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue("exception");
                if (value instanceof PsiClassObjectAccessExpression && (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiClassObjectAccessExpression)value).getOperand().getType())) != null && !this.hasStringConstructor(psiClass)) {
                    holder.registerProblem((PsiElement)value, "Custom exception class should have a constructor with a single message parameter of String type", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }

            private boolean hasStringConstructor(PsiClass aClass) {
                for (PsiMethod method : aClass.getConstructors()) {
                    PsiParameterList list = method.getParameterList();
                    if (list.getParametersCount() != 1 || !list.getParameters()[0].getType().equalsToText("java.lang.String")) continue;
                    return true;
                }
                return false;
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean nullabilityAnnotationsNotAvailable(PsiFile file2) {
        Project project2 = file2.getProject();
        final GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project2);
        final JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        return ContainerUtil.find((Iterable)NullableNotNullManager.getInstance((Project)project2).getNullables(), (Condition)new Condition<String>(){

            public boolean value(String s) {
                return facade.findClass(s, scope) != null;
            }
        }) == null;
    }

    private static boolean checkNonStandardAnnotations(PsiField field, Annotated annotated, NullableNotNullManager manager, String anno, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "checkNonStandardAnnotations"));
        }
        if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)field, (String)anno)) {
            PsiAnnotation annotation;
            PsiAnnotation notNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, (Collection)manager.getNotNulls());
            PsiAnnotation nullable = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, (Collection)manager.getNullables());
            String message = "Not '";
            if (annotated.isDeclaredNullable) {
                message = message + nullable.getQualifiedName();
                annotation = nullable;
            } else {
                message = message + notNull.getQualifiedName();
                annotation = notNull;
            }
            message = message + "' but '" + anno + "' would be used for code generation.";
            PsiJavaCodeReferenceElement annotationNameReferenceElement = annotation.getNameReferenceElement();
            holder.registerProblem((PsiElement)(annotationNameReferenceElement != null && annotationNameReferenceElement.isPhysical() ? annotationNameReferenceElement : field.getNameIdentifier()), message, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new ChangeNullableDefaultsFix(notNull, nullable, manager)});
            return false;
        }
        return true;
    }

    private void checkAccessors(PsiField field, Annotated annotated, Project project2, NullableNotNullManager manager, String anno, List<String> annoToRemove, @NotNull ProblemsHolder holder) {
        PsiClass containingClass;
        PsiMethod setter;
        PsiIdentifier nameIdentifier;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "checkAccessors"));
        }
        String propName = JavaCodeStyleManager.getInstance((Project)project2).variableNameToPropertyName(field.getName(), VariableKind.FIELD);
        boolean isStatic = field.hasModifierProperty("static");
        PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)field.getContainingClass(), (String)propName, (boolean)isStatic, (boolean)false);
        PsiIdentifier psiIdentifier = nameIdentifier = getter == null ? null : getter.getNameIdentifier();
        if (nameIdentifier != null && nameIdentifier.isPhysical() && PropertyUtil.isSimpleGetter((PsiMethod)getter)) {
            AnnotateMethodFix getterAnnoFix = new AnnotateMethodFix(anno, ArrayUtil.toStringArray(annoToRemove)){

                @Override
                public int shouldAnnotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project2) {
                    return 1;
                }
            };
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)getter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)getter.getReturnType())) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.getter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{getterAnnoFix});
            }
            if (annotated.isDeclaredNotNull && NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)getter, false) || annotated.isDeclaredNullable && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)getter, false, false)) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.getter.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)getter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{getterAnnoFix});
            }
        }
        if ((setter = PropertyUtil.findPropertySetter((PsiClass)(containingClass = field.getContainingClass()), (String)propName, (boolean)isStatic, (boolean)false)) != null && setter.isPhysical()) {
            PsiIdentifier nameIdentifier1;
            PsiParameter[] parameters = setter.getParameterList().getParameters();
            assert (parameters.length == 1) : setter.getText();
            PsiParameter parameter = parameters[0];
            LOG.assertTrue(parameter != null, (Object)setter.getText());
            AddAnnotationPsiFix addAnnoFix = NullableStuffInspectionBase.createAddAnnotationFix(anno, annoToRemove, parameter);
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)parameter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)parameter.getType())) {
                nameIdentifier1 = parameter.getNameIdentifier();
                NullableStuffInspectionBase.assertValidElement(setter, parameter, nameIdentifier1);
                holder.registerProblem((PsiElement)nameIdentifier1, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.setter.parameter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{addAnnoFix});
            }
            if (PropertyUtil.isSimpleSetter((PsiMethod)setter) && annotated.isDeclaredNotNull && NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)parameter, false)) {
                nameIdentifier1 = parameter.getNameIdentifier();
                NullableStuffInspectionBase.assertValidElement(setter, parameter, nameIdentifier1);
                holder.registerProblem((PsiElement)nameIdentifier1, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.setter.parameter.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{addAnnoFix});
            }
        }
    }

    @NotNull
    private static AddAnnotationPsiFix createAddAnnotationFix(String anno, List<String> annoToRemove, PsiParameter parameter) {
        AddAnnotationPsiFix addAnnotationPsiFix = new AddAnnotationPsiFix(anno, (PsiModifierListOwner)parameter, PsiNameValuePair.EMPTY_ARRAY, ArrayUtil.toStringArray(annoToRemove));
        if (addAnnotationPsiFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "createAddAnnotationFix"));
        }
        return addAnnotationPsiFix;
    }

    private static void assertValidElement(PsiMethod setter, PsiParameter parameter, PsiIdentifier nameIdentifier1) {
        LOG.assertTrue(nameIdentifier1 != null && nameIdentifier1.isPhysical(), (Object)setter.getText());
        LOG.assertTrue(parameter.isPhysical(), (Object)setter.getText());
    }

    private static void checkNotNullFieldsInitialized(PsiField field, NullableNotNullManager manager, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "checkNotNullFieldsInitialized"));
        }
        PsiAnnotation annotation = manager.getNotNullAnnotation((PsiModifierListOwner)field, false);
        if (annotation == null || HighlightControlFlowUtil.isFieldInitializedAfterObjectConstruction(field)) {
            return;
        }
        boolean byDefault = manager.isContainerAnnotation(annotation);
        PsiJavaCodeReferenceElement name = annotation.getNameReferenceElement();
        holder.registerProblem((PsiElement)(annotation.isPhysical() && !byDefault ? annotation : field.getNameIdentifier()), (byDefault && name != null ? "@" + name.getReferenceName() : "Not-null") + " fields must be initialized", new LocalQuickFix[0]);
    }

    private void checkConstructorParameters(PsiField field, Annotated annotated, NullableNotNullManager manager, String anno, List<String> annoToRemove, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "checkConstructorParameters"));
        }
        List<PsiExpression> initializers = DfaPsiUtil.findAllConstructorInitializers(field);
        if (initializers.isEmpty()) {
            return;
        }
        ArrayList notNullParams = ContainerUtil.newArrayList();
        boolean isFinal = field.hasModifierProperty("final");
        for (PsiExpression rhs : initializers) {
            PsiIdentifier nameIdentifier;
            PsiElement target;
            if (!(rhs instanceof PsiReferenceExpression) || !((target = ((PsiReferenceExpression)rhs).resolve()) instanceof PsiParameter) || !target.isPhysical()) continue;
            PsiParameter parameter = (PsiParameter)target;
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)parameter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)parameter.getType()) && (nameIdentifier = parameter.getNameIdentifier()) != null && nameIdentifier.isPhysical()) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.constructor.parameter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{NullableStuffInspectionBase.createAddAnnotationFix(anno, annoToRemove, parameter)});
                continue;
            }
            if (!isFinal || !annotated.isDeclaredNullable || !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false)) continue;
            notNullParams.add(parameter);
        }
        if (notNullParams.size() != initializers.size()) {
            return;
        }
        PsiIdentifier nameIdentifier = field.getNameIdentifier();
        if (nameIdentifier.isPhysical()) {
            holder.registerProblem((PsiElement)nameIdentifier, "@" + NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field) + " field is always initialized not-null", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new AddNotNullAnnotationFix((PsiModifierListOwner)field)});
        }
    }

    @NotNull
    private static String getPresentableAnnoName(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner.getProject());
        HashSet names = ContainerUtil.newHashSet((Iterable)manager.getNullables());
        names.addAll(manager.getNotNulls());
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)owner, (Set)names);
        if (annotation != null) {
            String string = NullableStuffInspectionBase.getPresentableAnnoName(annotation);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
            }
            return string;
        }
        String anno = manager.getNotNull(owner);
        String string = StringUtil.getShortName((String)(anno != null ? anno : StringUtil.notNullize((String)manager.getNullable(owner), (String)"???")));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
        }
        return string;
    }

    private static String getPresentableAnnoName(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
        }
        return StringUtil.getShortName((String)StringUtil.notNullize((String)annotation.getQualifiedName(), (String)"???"));
    }

    private static Annotated check(PsiModifierListOwner parameter, ProblemsHolder holder, PsiType type) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)holder.getProject());
        PsiAnnotation isDeclaredNotNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (Collection)manager.getNotNulls());
        PsiAnnotation isDeclaredNullable = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (Collection)manager.getNullables());
        if (isDeclaredNullable != null && isDeclaredNotNull != null) {
            NullableStuffInspectionBase.reportNullableNotNullConflict(holder, parameter, isDeclaredNullable, isDeclaredNotNull);
        }
        if ((isDeclaredNotNull != null || isDeclaredNullable != null) && type != null && TypeConversionUtil.isPrimitive((String)type.getCanonicalText())) {
            PsiAnnotation annotation = isDeclaredNotNull == null ? isDeclaredNullable : isDeclaredNotNull;
            NullableStuffInspectionBase.reportPrimitiveType(holder, (PsiElement)annotation, annotation, parameter);
        }
        return new Annotated(isDeclaredNotNull != null, isDeclaredNullable != null);
    }

    private static void reportPrimitiveType(ProblemsHolder holder, PsiElement psiElement, PsiAnnotation annotation, PsiModifierListOwner listOwner) {
        holder.registerProblem(psiElement.isPhysical() ? psiElement : listOwner.getNavigationElement(), InspectionsBundle.message((String)"inspection.nullable.problems.primitive.type.annotation", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(annotation, listOwner)});
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.nullable.problems.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("NullableProblems" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getShortName"));
        }
        return "NullableProblems";
    }

    private void checkNullableStuffForMethod(PsiMethod method, ProblemsHolder holder) {
        Annotated annotated = NullableStuffInspectionBase.check((PsiModifierListOwner)method, holder, method.getReturnType());
        List superMethods = ContainerUtil.map((Collection)method.findSuperMethodSignaturesIncludingStatic(true), (Function)new Function<MethodSignatureBackedByPsiMethod, PsiMethod>(){

            public PsiMethod fun(MethodSignatureBackedByPsiMethod signature) {
                return signature.getMethod();
            }
        });
        NullableNotNullManager nullableManager = NullableNotNullManager.getInstance((Project)holder.getProject());
        this.checkSupers(method, holder, annotated, superMethods, nullableManager);
        this.checkParameters(method, holder, superMethods, nullableManager);
        this.checkOverriders(method, holder, annotated, nullableManager);
    }

    private void checkSupers(PsiMethod method, ProblemsHolder holder, Annotated annotated, List<PsiMethod> superMethods, NullableNotNullManager nullableManager) {
        if (this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE) {
            for (PsiMethod superMethod : superMethods) {
                if (!annotated.isDeclaredNullable || !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)superMethod, true, false)) continue;
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (Collection)nullableManager.getNullables(), (boolean)true);
                holder.registerProblem((PsiElement)(annotation != null ? annotation : method.getNameIdentifier()), InspectionsBundle.message((String)"inspection.nullable.problems.Nullable.method.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)method), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                break;
            }
        }
        if (this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL) {
            for (PsiMethod superMethod : superMethods) {
                if (nullableManager.hasNullability((PsiModifierListOwner)method) || !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)superMethod, true, this.IGNORE_EXTERNAL_SUPER_NOTNULL)) continue;
                String defaultNotNull = nullableManager.getDefaultNotNull();
                String[] annotationsToRemove = ArrayUtil.toStringArray((Collection)nullableManager.getNullables());
                LocalQuickFix fix = AnnotationUtil.isAnnotatingApplicable((PsiElement)method, (String)defaultNotNull) ? this.createAnnotateMethodFix(defaultNotNull, annotationsToRemove) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)superMethod);
                holder.registerProblem((PsiElement)method.getNameIdentifier(), InspectionsBundle.message((String)"inspection.nullable.problems.method.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, NullableStuffInspectionBase.wrapFix(fix));
                break;
            }
        }
    }

    private void checkParameters(PsiMethod method, ProblemsHolder holder, List<PsiMethod> superMethods, NullableNotNullManager nullableManager) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        block0: for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            ArrayList superParameters = ContainerUtil.newArrayList();
            for (PsiMethod superMethod : superMethods) {
                PsiParameter[] _superParameters = superMethod.getParameterList().getParameters();
                if (_superParameters.length != parameters.length) continue;
                superParameters.add(_superParameters[i]);
            }
            if (this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE) {
                for (PsiParameter superParameter : superParameters) {
                    if (!NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false) || !NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)superParameter, false)) continue;
                    PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (Collection)nullableManager.getNotNulls(), (boolean)true);
                    holder.registerProblem((PsiElement)(annotation != null ? annotation : parameter.getNameIdentifier()), InspectionsBundle.message((String)"inspection.nullable.problems.NotNull.parameter.overrides.Nullable", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superParameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    break;
                }
            }
            if (this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL) {
                for (PsiParameter superParameter : superParameters) {
                    if (nullableManager.hasNullability((PsiModifierListOwner)parameter) || !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)superParameter, false, this.IGNORE_EXTERNAL_SUPER_NOTNULL)) continue;
                    AddNotNullAnnotationFix fix = AnnotationUtil.isAnnotatingApplicable((PsiElement)parameter, (String)nullableManager.getDefaultNotNull()) ? new AddNotNullAnnotationFix((PsiModifierListOwner)parameter) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)superParameter);
                    holder.registerProblem((PsiElement)parameter.getNameIdentifier(), InspectionsBundle.message((String)"inspection.nullable.problems.parameter.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superParameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, NullableStuffInspectionBase.wrapFix((LocalQuickFix)fix));
                    break;
                }
            }
            if (!this.REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED) continue;
            for (PsiParameter superParameter : superParameters) {
                if (nullableManager.hasNullability((PsiModifierListOwner)superParameter) || !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false)) continue;
                PsiAnnotation notNullAnnotation = nullableManager.getNotNullAnnotation((PsiModifierListOwner)parameter, false);
                assert (notNullAnnotation != null);
                boolean physical = PsiTreeUtil.isAncestor((PsiElement)parameter, (PsiElement)notNullAnnotation, (boolean)true);
                RemoveAnnotationQuickFix fix = physical ? new RemoveAnnotationQuickFix(notNullAnnotation, (PsiModifierListOwner)parameter) : null;
                holder.registerProblem((PsiElement)(physical ? notNullAnnotation : parameter.getNameIdentifier()), InspectionsBundle.message((String)"inspection.nullable.problems.NotNull.parameter.overrides.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, NullableStuffInspectionBase.wrapFix(fix));
                continue block0;
            }
        }
    }

    private void checkOverriders(PsiMethod method, ProblemsHolder holder, Annotated annotated, NullableNotNullManager nullableManager) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (this.REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS) {
            boolean[] parameterAnnotated = new boolean[parameters.length];
            boolean[] parameterQuickFixSuggested = new boolean[parameters.length];
            boolean hasAnnotatedParameter = false;
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                parameterAnnotated[i] = NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false);
                hasAnnotatedParameter |= parameterAnnotated[i];
            }
            if (hasAnnotatedParameter || annotated.isDeclaredNotNull) {
                PsiManager manager = method.getManager();
                String defaultNotNull = nullableManager.getDefaultNotNull();
                boolean superMethodApplicable = AnnotationUtil.isAnnotatingApplicable((PsiElement)method, (String)defaultNotNull);
                PsiMethod[] overridings = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)GlobalSearchScope.allScope((Project)manager.getProject()), (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY);
                boolean methodQuickFixSuggested = false;
                for (PsiMethod overriding : overridings) {
                    if (!manager.isInProject((PsiElement)overriding)) continue;
                    boolean applicable = AnnotationUtil.isAnnotatingApplicable((PsiElement)overriding, (String)defaultNotNull);
                    if (!(methodQuickFixSuggested || !annotated.isDeclaredNotNull || NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)overriding, false, false) || !NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)overriding, false) && NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)overriding, true))) {
                        method.getNameIdentifier();
                        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (Collection)nullableManager.getNotNulls());
                        String[] annotationsToRemove = ArrayUtil.toStringArray((Collection)nullableManager.getNullables());
                        LocalQuickFix fix = applicable ? new MyAnnotateMethodFix(defaultNotNull, annotationsToRemove) : (superMethodApplicable ? null : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)method));
                        PsiAnnotation psiElement = annotation;
                        if (!annotation.isPhysical() && (psiElement = method.getNameIdentifier()) == null) continue;
                        holder.registerProblem((PsiElement)psiElement, InspectionsBundle.message((String)"nullable.stuff.problems.overridden.methods.are.not.annotated", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, NullableStuffInspectionBase.wrapFix(fix));
                        methodQuickFixSuggested = true;
                    }
                    if (!hasAnnotatedParameter) continue;
                    PsiParameter[] psiParameters = overriding.getParameterList().getParameters();
                    for (int i = 0; i < psiParameters.length; ++i) {
                        PsiAnnotation annotation;
                        if (parameterQuickFixSuggested[i]) continue;
                        PsiParameter parameter = psiParameters[i];
                        if (!parameterAnnotated[i] || NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false) || NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)parameter, false)) continue;
                        parameters[i].getNameIdentifier();
                        PsiAnnotation psiElement = annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameters[i], (Collection)nullableManager.getNotNulls());
                        if ((annotation == null || !annotation.isPhysical()) && (psiElement = parameters[i].getNameIdentifier()) == null) continue;
                        holder.registerProblem((PsiElement)psiElement, InspectionsBundle.message((String)"nullable.stuff.problems.overridden.method.parameters.are.not.annotated", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, NullableStuffInspectionBase.wrapFix((LocalQuickFix)(!applicable ? NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)parameters[i]) : new AnnotateOverriddenMethodParameterFix(defaultNotNull, nullableManager.getDefaultNullable()))));
                        parameterQuickFixSuggested[i] = true;
                    }
                }
            }
        }
    }

    private static boolean isNotNullNotInferred(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean skipExternal) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "isNotNullNotInferred"));
        }
        Project project2 = owner.getProject();
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
        if (!manager.isNotNull(owner, checkBases)) {
            return false;
        }
        PsiAnnotation anno = manager.getNotNullAnnotation(owner, checkBases);
        if (anno == null || AnnotationUtil.isInferredAnnotation((PsiAnnotation)anno)) {
            return false;
        }
        return !skipExternal || !AnnotationUtil.isExternalAnnotation((PsiAnnotation)anno);
    }

    public static boolean isNullableNotInferred(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "isNullableNotInferred"));
        }
        Project project2 = owner.getProject();
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
        if (!manager.isNullable(owner, checkBases)) {
            return false;
        }
        PsiAnnotation anno = manager.getNullableAnnotation(owner, checkBases);
        return anno == null || !AnnotationUtil.isInferredAnnotation((PsiAnnotation)anno);
    }

    @NotNull
    private static LocalQuickFix[] wrapFix(LocalQuickFix fix) {
        if (fix == null) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "wrapFix"));
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
        if (localQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "wrapFix"));
        }
        return localQuickFixArray;
    }

    private static LocalQuickFix createChangeDefaultNotNullFix(NullableNotNullManager nullableManager, PsiModifierListOwner modifierListOwner) {
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierListOwner, (Collection)nullableManager.getNotNulls());
        if (annotation != null && (referenceElement = annotation.getNameReferenceElement()) != null && referenceElement.resolve() != null) {
            return new ChangeNullableDefaultsFix(annotation.getQualifiedName(), null, nullableManager);
        }
        return null;
    }

    protected AnnotateMethodFix createAnnotateMethodFix(String defaultNotNull, String[] annotationsToRemove) {
        return new AnnotateMethodFix(defaultNotNull, annotationsToRemove);
    }

    private static void reportNullableNotNullConflict(ProblemsHolder holder, PsiModifierListOwner listOwner, PsiAnnotation declaredNullable, PsiAnnotation declaredNotNull) {
        String bothNullableNotNullMessage = InspectionsBundle.message((String)"inspection.nullable.problems.Nullable.NotNull.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName(declaredNullable), NullableStuffInspectionBase.getPresentableAnnoName(declaredNotNull)});
        holder.registerProblem((PsiElement)(declaredNotNull.isPhysical() ? declaredNotNull : listOwner.getNavigationElement()), bothNullableNotNullMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(declaredNotNull, listOwner)});
        holder.registerProblem((PsiElement)(declaredNullable.isPhysical() ? declaredNullable : listOwner.getNavigationElement()), bothNullableNotNullMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(declaredNullable, listOwner)});
    }

    public JComponent createOptionsPanel() {
        throw new RuntimeException("No UI in headless mode");
    }

    private static class MyAnnotateMethodFix
    extends AnnotateMethodFix {
        public MyAnnotateMethodFix(String defaultNotNull, String[] annotationsToRemove) {
            super(defaultNotNull, annotationsToRemove);
        }

        @Override
        protected boolean annotateOverriddenMethods() {
            return true;
        }

        @Override
        public int shouldAnnotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project2) {
            return 1;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"annotate.overridden.methods.as.notnull", (Object[])new Object[]{ClassUtil.extractClassName((String)this.myAnnotation)});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$MyAnnotateMethodFix", "getName"));
            }
            return string;
        }
    }

    private static class Annotated {
        private final boolean isDeclaredNotNull;
        private final boolean isDeclaredNullable;

        private Annotated(boolean isDeclaredNotNull, boolean isDeclaredNullable) {
            this.isDeclaredNotNull = isDeclaredNotNull;
            this.isDeclaredNullable = isDeclaredNullable;
        }
    }
}

