/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessInfo {
    public static ProcessInfo[] EMPTY_ARRAY = new ProcessInfo[0];
    private final int myPid;
    @NotNull
    private final String myCommandLine;
    @NotNull
    private final Optional<String> myExecutablePath;
    @NotNull
    private final String myExecutableName;
    @NotNull
    private final String myArgs;

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/ProcessInfo", "<init>"));
        }
        if (executableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executableName", "com/intellij/execution/process/ProcessInfo", "<init>"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/execution/process/ProcessInfo", "<init>"));
        }
        this.myPid = pid;
        this.myCommandLine = commandLine;
        this.myExecutablePath = Optional.empty();
        this.myExecutableName = executableName;
        this.myArgs = args;
    }

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args, @Nullable String executablePath) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/ProcessInfo", "<init>"));
        }
        if (executableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executableName", "com/intellij/execution/process/ProcessInfo", "<init>"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/execution/process/ProcessInfo", "<init>"));
        }
        this.myPid = pid;
        this.myCommandLine = commandLine;
        this.myExecutableName = executableName;
        this.myExecutablePath = StringUtil.isNotEmpty((String)executablePath) ? Optional.of(executablePath) : Optional.empty();
        this.myArgs = args;
    }

    public int getPid() {
        return this.myPid;
    }

    @NotNull
    public String getCommandLine() {
        String string = this.myCommandLine;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessInfo", "getCommandLine"));
        }
        return string;
    }

    @NotNull
    public String getExecutableName() {
        String string = this.myExecutableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessInfo", "getExecutableName"));
        }
        return string;
    }

    @NotNull
    public Optional<String> getExecutableCannonicalPath() {
        Optional<String> optional = this.myExecutablePath.map(s -> {
            try {
                return new File((String)s).getCanonicalPath();
            }
            catch (IOException e) {
                return s;
            }
        });
        if (optional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessInfo", "getExecutableCannonicalPath"));
        }
        return optional;
    }

    @NotNull
    public String getExecutableDisplayName() {
        String string = StringUtil.trimEnd((String)this.myExecutableName, (String)".exe", (boolean)true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessInfo", "getExecutableDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getArgs() {
        String string = this.myArgs;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessInfo", "getArgs"));
        }
        return string;
    }

    public String toString() {
        return this.myPid + " '" + this.myCommandLine + "' '" + this.myExecutableName + "' '" + this.myArgs + "'";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInfo info = (ProcessInfo)o;
        if (this.myPid != info.myPid) {
            return false;
        }
        if (!this.myExecutableName.equals(info.myExecutableName)) {
            return false;
        }
        if (!this.myArgs.equals(info.myArgs)) {
            return false;
        }
        return this.myCommandLine.equals(info.myCommandLine);
    }

    public int hashCode() {
        int result = this.myPid;
        result = 31 * result + this.myExecutableName.hashCode();
        result = 31 * result + this.myArgs.hashCode();
        result = 31 * result + this.myCommandLine.hashCode();
        return result;
    }
}

