/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScriptRunnerUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.execution.process.ScriptRunnerUtil");
    public static final Condition<Key> STDOUT_OUTPUT_KEY_FILTER = new Condition<Key>(){

        public boolean value(Key key) {
            return ProcessOutputTypes.STDOUT.equals((Object)key);
        }
    };
    public static final Condition<Key> STDERR_OUTPUT_KEY_FILTER = new Condition<Key>(){

        public boolean value(Key key) {
            return ProcessOutputTypes.STDERR.equals((Object)key);
        }
    };
    public static final Condition<Key> STDOUT_OR_STDERR_OUTPUT_KEY_FILTER = Conditions.or(STDOUT_OUTPUT_KEY_FILTER, STDERR_OUTPUT_KEY_FILTER);
    private static final int DEFAULT_TIMEOUT = 30000;

    private ScriptRunnerUtil() {
    }

    public static String getProcessOutput(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/ScriptRunnerUtil", "getProcessOutput"));
        }
        return ScriptRunnerUtil.getProcessOutput(commandLine, STDOUT_OUTPUT_KEY_FILTER, 30000L);
    }

    public static String getProcessOutput(@NotNull GeneralCommandLine commandLine, @NotNull Condition<Key> outputTypeFilter, long timeout) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/ScriptRunnerUtil", "getProcessOutput"));
        }
        if (outputTypeFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputTypeFilter", "com/intellij/execution/process/ScriptRunnerUtil", "getProcessOutput"));
        }
        return ScriptRunnerUtil.getProcessOutput((ProcessHandler)new OSProcessHandler(commandLine), outputTypeFilter, timeout);
    }

    public static String getProcessOutput(@NotNull ProcessHandler processHandler2, final @NotNull Condition<Key> outputTypeFilter, long timeout) throws ExecutionException {
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/process/ScriptRunnerUtil", "getProcessOutput"));
        }
        if (outputTypeFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputTypeFilter", "com/intellij/execution/process/ScriptRunnerUtil", "getProcessOutput"));
        }
        LOG.assertTrue(!processHandler2.isStartNotified());
        final StringBuilder outputBuilder = new StringBuilder();
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputTypeFilter.value((Object)outputType)) {
                    String text = event.getText();
                    outputBuilder.append(text);
                    LOG.debug(text);
                }
            }
        });
        processHandler2.startNotify();
        if (!processHandler2.waitFor(timeout)) {
            throw new ExecutionException(ExecutionBundle.message((String)"script.execution.timeout", (Object[])new Object[]{String.valueOf(timeout / 1000L)}));
        }
        return outputBuilder.toString();
    }

    @NotNull
    public static OSProcessHandler execute(@NotNull String exePath, @Nullable String workingDirectory, @Nullable VirtualFile scriptFile, String[] parameters) throws ExecutionException {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/intellij/execution/process/ScriptRunnerUtil", "execute"));
        }
        OSProcessHandler oSProcessHandler = ScriptRunnerUtil.execute(exePath, workingDirectory, scriptFile, parameters, null);
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ScriptRunnerUtil", "execute"));
        }
        return oSProcessHandler;
    }

    @NotNull
    public static OSProcessHandler execute(@NotNull String exePath, @Nullable String workingDirectory, @Nullable VirtualFile scriptFile, String[] parameters, @Nullable Charset charset) throws ExecutionException {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/intellij/execution/process/ScriptRunnerUtil", "execute"));
        }
        exePath = PathEnvironmentVariableUtil.findAbsolutePathOnMac((String)exePath);
        OSProcessHandler oSProcessHandler = ScriptRunnerUtil.doExecute(exePath, workingDirectory, scriptFile, parameters, charset);
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ScriptRunnerUtil", "execute"));
        }
        return oSProcessHandler;
    }

    @NotNull
    private static OSProcessHandler doExecute(@NotNull String exePath, @Nullable String workingDirectory, @Nullable VirtualFile scriptFile, String[] parameters, @Nullable Charset charset) throws ExecutionException {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/intellij/execution/process/ScriptRunnerUtil", "doExecute"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{exePath});
        if (scriptFile != null) {
            commandLine.addParameter(scriptFile.getPresentableUrl());
        }
        commandLine.addParameters(parameters);
        if (workingDirectory != null) {
            commandLine.setWorkDirectory(workingDirectory);
        }
        LOG.debug("Command line: ", new Object[]{commandLine.getCommandLineString()});
        LOG.debug("Command line env: ", new Object[]{commandLine.getEnvironment()});
        if (charset == null) {
            charset = EncodingManager.getInstance().getDefaultCharset();
        }
        commandLine.setCharset(charset);
        ColoredProcessHandler processHandler2 = new ColoredProcessHandler(commandLine);
        if (LOG.isDebugEnabled()) {
            processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    LOG.debug(outputType + ": " + event.getText());
                }
            });
        }
        ColoredProcessHandler coloredProcessHandler = processHandler2;
        if (coloredProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ScriptRunnerUtil", "doExecute"));
        }
        return coloredProcessHandler;
    }

    public static ScriptOutput executeScriptInConsoleWithFullOutput(String exePathString, @Nullable VirtualFile scriptFile, @Nullable String workingDirectory, long timeout, Condition<Key> scriptOutputType, String ... parameters) throws ExecutionException {
        OSProcessHandler processHandler2 = ScriptRunnerUtil.execute(exePathString, workingDirectory, scriptFile, parameters);
        ScriptOutput output = new ScriptOutput(scriptOutputType);
        processHandler2.addProcessListener((ProcessListener)output);
        processHandler2.startNotify();
        if (!processHandler2.waitFor(timeout)) {
            LOG.warn("Process did not complete in " + timeout / 1000L + "s");
            throw new ExecutionException(ExecutionBundle.message((String)"script.execution.timeout", (Object[])new Object[]{String.valueOf(timeout / 1000L)}));
        }
        LOG.debug("script output: ", new Object[]{output.myFilteredOutput});
        return output;
    }

    public static void terminateProcessHandler(@NotNull ProcessHandler processHandler2, long millisTimeout, @Nullable String string) {
        KillableProcess killableProcess;
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/process/ScriptRunnerUtil", "terminateProcessHandler"));
        }
        if (processHandler2.isProcessTerminated()) {
            String commandLine;
            if (commandLine == null && processHandler2 instanceof BaseOSProcessHandler) {
                commandLine = ((BaseOSProcessHandler)processHandler2).getCommandLine();
            }
            LOG.warn("Process '" + commandLine + "' is already terminated!");
            return;
        }
        processHandler2.destroyProcess();
        if (processHandler2 instanceof KillableProcess && (killableProcess = (KillableProcess)processHandler2).canKillProcess() && !processHandler2.waitFor(millisTimeout)) {
            killableProcess.killProcess();
        }
    }

    public static class ScriptOutput
    extends ProcessAdapter {
        private final Condition<Key> myScriptOutputType;
        public final StringBuilder myFilteredOutput;
        public final StringBuffer myMergedOutput;

        private ScriptOutput(Condition<Key> scriptOutputType) {
            this.myScriptOutputType = scriptOutputType;
            this.myFilteredOutput = new StringBuilder();
            this.myMergedOutput = new StringBuffer();
        }

        public String getFilteredOutput() {
            return this.myFilteredOutput.toString();
        }

        public String getMergedOutput() {
            return this.myMergedOutput.toString();
        }

        public String[] getOutputToParseArray() {
            return this.getFilteredOutput().split("\n");
        }

        public String getDescriptiveOutput() {
            String outputToParse = this.getFilteredOutput();
            return StringUtil.isEmpty((String)outputToParse) ? this.getMergedOutput() : outputToParse;
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            String text = event.getText();
            if (this.myScriptOutputType.value((Object)outputType)) {
                this.myFilteredOutput.append(text);
            }
            this.myMergedOutput.append(text);
        }
    }
}

