/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetTypeRegistryImpl
extends FacetTypeRegistry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.FacetTypeRegistryImpl");
    private static final Comparator<FacetType> FACET_TYPE_COMPARATOR = new Comparator<FacetType>(){

        @Override
        public int compare(FacetType o1, FacetType o2) {
            return o1.getPresentableName().compareToIgnoreCase(o2.getPresentableName());
        }
    };
    private final Map<String, FacetTypeId> myTypeIds = new HashMap<String, FacetTypeId>();
    private final Map<FacetTypeId, FacetType> myFacetTypes = new HashMap<FacetTypeId, FacetType>();
    private boolean myExtensionsLoaded = false;

    public synchronized void registerFacetType(FacetType facetType) {
        FacetTypeId typeId = facetType.getId();
        String id = facetType.getStringId();
        LOG.assertTrue(!id.contains("/"), (Object)("Facet type id '" + id + "' contains illegal character '/'"));
        LOG.assertTrue(!this.myFacetTypes.containsKey(typeId), (Object)("Facet type '" + id + "' is already registered"));
        this.myFacetTypes.put(typeId, facetType);
        LOG.assertTrue(!this.myTypeIds.containsKey(id), (Object)("Facet type id '" + id + "' is already registered"));
        this.myTypeIds.put(id, typeId);
    }

    public synchronized void unregisterFacetType(FacetType facetType) {
        FacetTypeId id = facetType.getId();
        String stringId = facetType.getStringId();
        LOG.assertTrue(this.myFacetTypes.remove(id) != null, (Object)("Facet type '" + stringId + "' is not registered"));
        this.myFacetTypes.remove(id);
        this.myTypeIds.remove(stringId);
    }

    @NotNull
    public synchronized FacetTypeId[] getFacetTypeIds() {
        this.loadExtensions();
        Set<FacetTypeId> ids = this.myFacetTypes.keySet();
        FacetTypeId[] facetTypeIdArray = ids.toArray(new FacetTypeId[ids.size()]);
        if (facetTypeIdArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetTypeRegistryImpl", "getFacetTypeIds"));
        }
        return facetTypeIdArray;
    }

    @NotNull
    public synchronized FacetType[] getFacetTypes() {
        this.loadExtensions();
        Collection<FacetType> types = this.myFacetTypes.values();
        FacetType[] facetTypes = types.toArray(new FacetType[types.size()]);
        Arrays.sort(facetTypes, FACET_TYPE_COMPARATOR);
        if (facetTypes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetTypeRegistryImpl", "getFacetTypes"));
        }
        return facetTypes;
    }

    @NotNull
    public FacetType[] getSortedFacetTypes() {
        FacetType[] types = this.getFacetTypes();
        Arrays.sort(types, FACET_TYPE_COMPARATOR);
        if (types == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetTypeRegistryImpl", "getSortedFacetTypes"));
        }
        return types;
    }

    @Nullable
    public synchronized FacetType findFacetType(String id) {
        this.loadExtensions();
        FacetTypeId typeId = this.myTypeIds.get(id);
        return typeId == null ? null : this.myFacetTypes.get(typeId);
    }

    @NotNull
    public synchronized <F extends Facet<C>, C extends FacetConfiguration> FacetType<F, C> findFacetType(@NotNull FacetTypeId<F> typeId) {
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/intellij/facet/impl/FacetTypeRegistryImpl", "findFacetType"));
        }
        this.loadExtensions();
        FacetType type = this.myFacetTypes.get(typeId);
        LOG.assertTrue(type != null, (Object)("Cannot find facet by id '" + typeId + "'"));
        FacetType facetType = type;
        if (facetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetTypeRegistryImpl", "findFacetType"));
        }
        return facetType;
    }

    private void loadExtensions() {
        if (!this.myExtensionsLoaded) {
            this.myExtensionsLoaded = true;
            ExtensionPoint extensionPoint = Extensions.getArea(null).getExtensionPoint(FacetType.EP_NAME);
            extensionPoint.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FacetType>(){

                public void extensionAdded(@NotNull FacetType extension, @Nullable PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/facet/impl/FacetTypeRegistryImpl$2", "extensionAdded"));
                    }
                    FacetTypeRegistryImpl.this.registerFacetType(extension);
                }

                public void extensionRemoved(@NotNull FacetType extension, @Nullable PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/facet/impl/FacetTypeRegistryImpl$2", "extensionRemoved"));
                    }
                    FacetTypeRegistryImpl.this.unregisterFacetType(extension);
                }
            });
        }
    }
}

