/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.impl.ui.libraries.DownloadingOptionsDialog;
import com.intellij.facet.impl.ui.libraries.EditLibraryDialog;
import com.intellij.facet.impl.ui.libraries.FrameworkLibraryProvider;
import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.facet.impl.ui.libraries.LibraryDownloadSettings;
import com.intellij.framework.library.DownloadableLibraryDescription;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.frameworkSupport.OldCustomLibraryDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.ui.RadioButtonEnumModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryOptionsPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.ui.libraries.LibraryOptionsPanel");
    private JBLabel myMessageLabel;
    private JPanel myPanel;
    private JButton myConfigureButton;
    private JComboBox myExistingLibraryComboBox;
    private JRadioButton myDoNotCreateRadioButton;
    private JPanel myConfigurationPanel;
    private JButton myCreateButton;
    private JRadioButton myDownloadRadioButton;
    private JRadioButton myUseLibraryRadioButton;
    private JLabel myUseLibraryLabel;
    private JLabel myHiddenLabel;
    private JPanel myRootPanel;
    private JRadioButton myUseFromProviderRadioButton;
    private JPanel mySimplePanel;
    private ButtonGroup myButtonGroup;
    private LibraryCompositionSettings mySettings;
    private final CustomLibraryDescription myLibraryDescription;
    private final LibrariesContainer myLibrariesContainer;
    private SortedComboBoxModel<LibraryEditor> myLibraryComboBoxModel;
    private FrameworkLibraryProvider myLibraryProvider;
    private boolean myDisposed;
    private RadioButtonEnumModel<Choice> myButtonEnumModel;

    public LibraryOptionsPanel(@NotNull CustomLibraryDescription libraryDescription, final @NotNull String path, @NotNull FrameworkLibraryVersionFilter versionFilter, @NotNull LibrariesContainer librariesContainer, boolean showDoNotCreateOption) {
        if (libraryDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescription", "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel", "<init>"));
        }
        if (versionFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionFilter", "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel", "<init>"));
        }
        if (librariesContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "librariesContainer", "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel", "<init>"));
        }
        this(libraryDescription, new NotNullComputable<String>(){

            @NotNull
            public String compute() {
                String string = path;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel$1", "compute"));
                }
                return string;
            }
        }, versionFilter, librariesContainer, showDoNotCreateOption);
    }

    public LibraryOptionsPanel(final @NotNull CustomLibraryDescription libraryDescription, final @NotNull NotNullComputable<String> pathProvider, final @NotNull FrameworkLibraryVersionFilter versionFilter, @NotNull LibrariesContainer librariesContainer, final boolean showDoNotCreateOption) {
        if (libraryDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescription", "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel", "<init>"));
        }
        if (pathProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathProvider", "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel", "<init>"));
        }
        if (versionFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionFilter", "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel", "<init>"));
        }
        if (librariesContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "librariesContainer", "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel", "<init>"));
        }
        this.myLibraryDescription = libraryDescription;
        this.myLibrariesContainer = librariesContainer;
        this.$$$setupUI$$$();
        DownloadableLibraryDescription description = LibraryOptionsPanel.getDownloadableDescription(libraryDescription);
        if (description != null) {
            this.showCard("loading");
            description.fetchVersions((DownloadableFileSetVersions.FileSetVersionsCallback)new DownloadableFileSetVersions.FileSetVersionsCallback<FrameworkLibraryVersion>(){

                public void onSuccess(final @NotNull List<? extends FrameworkLibraryVersion> versions) {
                    if (versions == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel$2", "onSuccess"));
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!LibraryOptionsPanel.this.myDisposed) {
                                LibraryOptionsPanel.this.showSettingsPanel(libraryDescription, (NotNullComputable<String>)pathProvider, versionFilter, showDoNotCreateOption, versions);
                                LibraryOptionsPanel.this.onVersionChanged(LibraryOptionsPanel.this.getPresentableVersion());
                            }
                        }
                    });
                }
            });
        } else {
            this.showSettingsPanel(libraryDescription, pathProvider, versionFilter, showDoNotCreateOption, new ArrayList());
        }
    }

    @Nullable
    private String getPresentableVersion() {
        switch ((Choice)this.myButtonEnumModel.getSelected()) {
            case DOWNLOAD: {
                LibraryDownloadSettings settings = this.mySettings.getDownloadSettings();
                if (settings == null) break;
                return settings.getVersion().getVersionNumber();
            }
            case USE_LIBRARY: {
                LibraryEditor item = (LibraryEditor)this.myLibraryComboBoxModel.getSelectedItem();
                if (!(item instanceof ExistingLibraryEditor)) break;
                return item.getName();
            }
            default: {
                return null;
            }
        }
        return null;
    }

    protected void onVersionChanged(@Nullable String version) {
    }

    public JPanel getSimplePanel() {
        return this.mySimplePanel;
    }

    @Nullable
    private static DownloadableLibraryDescription getDownloadableDescription(CustomLibraryDescription libraryDescription) {
        DownloadableLibraryType type = libraryDescription.getDownloadableLibraryType();
        if (type != null) {
            return type.getLibraryDescription();
        }
        if (libraryDescription instanceof OldCustomLibraryDescription) {
            return ((OldCustomLibraryDescription)libraryDescription).getDownloadableDescription();
        }
        return null;
    }

    private void showCard(String editing) {
        ((CardLayout)this.myRootPanel.getLayout()).show(this.myRootPanel, editing);
    }

    private void showSettingsPanel(CustomLibraryDescription libraryDescription, NotNullComputable<String> pathProvider, FrameworkLibraryVersionFilter versionFilter, boolean showDoNotCreateOption, List<? extends FrameworkLibraryVersion> versions) {
        Choice selectedOption;
        this.mySettings = new LibraryCompositionSettings(libraryDescription, pathProvider, versionFilter, versions);
        Disposer.register((Disposable)this, (Disposable)this.mySettings);
        List<Library> libraries = this.calculateSuitableLibraries();
        this.myButtonEnumModel = RadioButtonEnumModel.bindEnum(Choice.class, (ButtonGroup)this.myButtonGroup);
        this.myButtonEnumModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryOptionsPanel.this.updateState();
                LibraryOptionsPanel.this.onVersionChanged(LibraryOptionsPanel.this.getPresentableVersion());
            }
        });
        this.myDoNotCreateRadioButton.setVisible(showDoNotCreateOption);
        this.myLibraryComboBoxModel = new SortedComboBoxModel((Comparator)new Comparator<LibraryEditor>(){

            @Override
            public int compare(LibraryEditor o1, LibraryEditor o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                return -StringUtil.notNullize((String)name1).compareToIgnoreCase(StringUtil.notNullize((String)name2));
            }
        });
        for (Library library : libraries) {
            ExistingLibraryEditor libraryEditor = this.myLibrariesContainer.getLibraryEditor(library);
            if (libraryEditor == null) {
                libraryEditor = this.mySettings.getOrCreateEditor(library);
            }
            this.myLibraryComboBoxModel.add((Object)libraryEditor);
        }
        this.myExistingLibraryComboBox.setModel(this.myLibraryComboBoxModel);
        if (libraries.isEmpty()) {
            this.myLibraryComboBoxModel.add(null);
        }
        this.myExistingLibraryComboBox.setSelectedIndex(0);
        this.myExistingLibraryComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && e.getItem() != null) {
                    LibraryOptionsPanel.this.myButtonEnumModel.setSelected((Enum)Choice.USE_LIBRARY);
                }
                LibraryOptionsPanel.this.updateState();
                LibraryOptionsPanel.this.onVersionChanged(LibraryOptionsPanel.this.getPresentableVersion());
            }
        });
        this.myExistingLibraryComboBox.setRenderer(new ColoredListCellRenderer(this.myExistingLibraryComboBox){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    this.append("[No library selected]");
                } else if (value instanceof ExistingLibraryEditor) {
                    Library library = ((ExistingLibraryEditor)value).getLibrary();
                    boolean invalid = !((LibraryEx)library).getInvalidRootUrls(OrderRootType.CLASSES).isEmpty();
                    OrderEntryAppearanceService.getInstance().forLibrary(LibraryOptionsPanel.this.getProject(), library, invalid).customize((SimpleColoredComponent)this);
                } else if (value instanceof NewLibraryEditor) {
                    this.setIcon(PlatformIcons.LIBRARY_ICON);
                    String name = ((NewLibraryEditor)value).getName();
                    this.append(name != null ? name : "<unnamed>");
                }
            }
        });
        boolean canDownload = this.mySettings.getDownloadSettings() != null;
        boolean canUseFromProvider = this.myLibraryProvider != null;
        this.myDownloadRadioButton.setVisible(canDownload);
        this.myUseFromProviderRadioButton.setVisible(canUseFromProvider);
        if (canUseFromProvider) {
            selectedOption = Choice.USE_FROM_PROVIDER;
        } else if (libraries.isEmpty() && canDownload) {
            selectedOption = Choice.DOWNLOAD;
        } else {
            selectedOption = Choice.USE_LIBRARY;
            this.doCreate(true);
        }
        this.myButtonEnumModel.setSelected((Enum)selectedOption);
        if (!(canDownload || canUseFromProvider || showDoNotCreateOption)) {
            this.myUseLibraryRadioButton.setVisible(false);
            this.myUseLibraryLabel.setVisible(true);
        } else {
            this.myUseLibraryLabel.setVisible(false);
        }
        Dimension minimumSize = new Dimension(-1, this.myMessageLabel.getFontMetrics(this.myMessageLabel.getFont()).getHeight() * 2);
        this.myHiddenLabel.setMinimumSize(minimumSize);
        this.myCreateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryOptionsPanel.this.doCreate(false);
            }
        });
        this.myConfigureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LibraryOptionsPanel.this.doConfigure();
                    }
                });
            }
        });
        this.updateState();
        this.showCard("editing");
    }

    private Project getProject() {
        Project project2 = this.myLibrariesContainer.getProject();
        if (project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        return project2;
    }

    private void doConfigure() {
        switch ((Choice)this.myButtonEnumModel.getSelected()) {
            case DOWNLOAD: {
                LibraryDownloadSettings oldDownloadSettings = this.mySettings.getDownloadSettings();
                LOG.assertTrue(oldDownloadSettings != null);
                LibraryDownloadSettings newDownloadSettings = DownloadingOptionsDialog.showDialog(this.myPanel, oldDownloadSettings, this.mySettings.getCompatibleVersions(), true);
                if (newDownloadSettings == null) break;
                this.mySettings.setDownloadSettings(newDownloadSettings);
                break;
            }
            case USE_LIBRARY: {
                final Object item = this.myExistingLibraryComboBox.getSelectedItem();
                if (!(item instanceof LibraryEditor)) break;
                EditLibraryDialog dialog = new EditLibraryDialog(this.myPanel, this.mySettings, (LibraryEditor)item);
                dialog.show();
                if (!(item instanceof ExistingLibraryEditor)) break;
                new WriteAction(){

                    protected void run(@NotNull Result result) {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel$9", "run"));
                        }
                        ((ExistingLibraryEditor)item).commit();
                    }
                }.execute();
                break;
            }
        }
        this.updateState();
    }

    public void setLibraryProvider(@Nullable FrameworkLibraryProvider provider) {
        if (provider != null && !ContainerUtil.intersects(provider.getAvailableLibraryKinds(), this.myLibraryDescription.getSuitableLibraryKinds())) {
            provider = null;
        }
        if (!Comparing.equal((Object)this.myLibraryProvider, (Object)provider)) {
            this.myLibraryProvider = provider;
            if (this.mySettings != null) {
                if (provider != null && !this.myUseFromProviderRadioButton.isVisible()) {
                    this.myUseFromProviderRadioButton.setSelected(true);
                }
                this.myUseFromProviderRadioButton.setVisible(provider != null);
                this.updateState();
            }
        }
    }

    public void setVersionFilter(@NotNull FrameworkLibraryVersionFilter versionFilter) {
        if (versionFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionFilter", "com/intellij/facet/impl/ui/libraries/LibraryOptionsPanel", "setVersionFilter"));
        }
        if (this.mySettings != null) {
            this.mySettings.setVersionFilter(versionFilter);
            this.updateState();
        }
    }

    private void doCreate(boolean useDefaultSettings) {
        NewLibraryConfiguration libraryConfiguration;
        NewLibraryConfiguration newLibraryConfiguration = libraryConfiguration = useDefaultSettings ? this.myLibraryDescription.createNewLibraryWithDefaultSettings(this.getBaseDirectory()) : this.myLibraryDescription.createNewLibrary(this.myCreateButton, this.getBaseDirectory());
        if (libraryConfiguration != null) {
            NewLibraryEditor libraryEditor = new NewLibraryEditor(libraryConfiguration.getLibraryType(), libraryConfiguration.getProperties());
            libraryEditor.setName(this.myLibrariesContainer.suggestUniqueLibraryName(libraryConfiguration.getDefaultLibraryName()));
            libraryConfiguration.addRoots(libraryEditor);
            if (this.myLibraryComboBoxModel.get(0) == null) {
                this.myLibraryComboBoxModel.remove(0);
            }
            this.myLibraryComboBoxModel.add((Object)libraryEditor);
            this.myLibraryComboBoxModel.setSelectedItem((Object)libraryEditor);
            this.myButtonEnumModel.setSelected((Enum)Choice.USE_LIBRARY);
        }
    }

    private List<Library> calculateSuitableLibraries() {
        ArrayList<Library> suitableLibraries = new ArrayList<Library>();
        for (Library library : this.myLibrariesContainer.getAllLibraries()) {
            if ((!(this.myLibraryDescription instanceof OldCustomLibraryDescription) || !((OldCustomLibraryDescription)this.myLibraryDescription).isSuitableLibrary(library, this.myLibrariesContainer)) && !LibraryPresentationManager.getInstance().isLibraryOfKind(library, this.myLibrariesContainer, this.myLibraryDescription.getSuitableLibraryKinds())) continue;
            suitableLibraries.add(library);
        }
        return suitableLibraries;
    }

    @Nullable
    private VirtualFile getBaseDirectory() {
        String path = this.mySettings.getBaseDirectoryPath();
        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(path);
        if (dir == null) {
            path = path.substring(0, path.lastIndexOf(47));
            dir = LocalFileSystem.getInstance().findFileByPath(path);
        }
        return dir;
    }

    private void updateState() {
        this.myMessageLabel.setIcon(null);
        this.myConfigureButton.setVisible(true);
        LibraryDownloadSettings settings = this.mySettings.getDownloadSettings();
        this.myDownloadRadioButton.setVisible(settings != null);
        this.myUseFromProviderRadioButton.setVisible(this.myLibraryProvider != null);
        if (!this.myUseFromProviderRadioButton.isVisible() && this.myUseFromProviderRadioButton.isSelected()) {
            if (this.myDownloadRadioButton.isVisible()) {
                this.myDownloadRadioButton.setSelected(true);
            } else {
                this.myUseLibraryRadioButton.setSelected(true);
            }
        }
        if (!this.myDownloadRadioButton.isVisible() && this.myDownloadRadioButton.isSelected() && this.myUseLibraryRadioButton.isVisible()) {
            this.myUseLibraryRadioButton.setSelected(true);
        }
        String message = "";
        boolean showConfigurePanel = true;
        switch ((Choice)this.myButtonEnumModel.getSelected()) {
            case DOWNLOAD: {
                message = this.getDownloadFilesMessage();
                break;
            }
            case USE_FROM_PROVIDER: {
                if (this.myLibraryProvider != null) {
                    message = "Library from " + this.myLibraryProvider.getPresentableName() + " will be used";
                }
                this.myConfigureButton.setVisible(false);
                break;
            }
            case USE_LIBRARY: {
                Object item = this.myExistingLibraryComboBox.getSelectedItem();
                if (item == null) {
                    this.myMessageLabel.setIcon(AllIcons.RunConfigurations.ConfigurationWarning);
                    message = "<b>Error:</b> library is not specified";
                    this.myConfigureButton.setVisible(false);
                    break;
                }
                if (item instanceof NewLibraryEditor) {
                    LibraryEditor libraryEditor = (LibraryEditor)item;
                    message = IdeBundle.message((String)"label.library.will.be.created.description.text", (Object[])new Object[]{this.mySettings.getNewLibraryLevel(), libraryEditor.getName(), libraryEditor.getFiles(OrderRootType.CLASSES).length});
                    break;
                }
                message = MessageFormat.format("<b>{0}</b> library will be used", ((ExistingLibraryEditor)item).getName());
                break;
            }
            default: {
                showConfigurePanel = false;
            }
        }
        if (this.myLibraryProvider != null) {
            this.myUseFromProviderRadioButton.setText("Use library from " + this.myLibraryProvider.getPresentableName());
        }
        if (this.mySettings.getDownloadSettings() != null) {
            this.myHiddenLabel.setText(this.getDownloadFilesMessage());
        } else {
            this.myHiddenLabel.setText(IdeBundle.message((String)"label.library.will.be.created.description.text", (Object[])new Object[]{this.mySettings.getNewLibraryLevel(), "name", 10}));
        }
        ((CardLayout)this.myConfigurationPanel.getLayout()).show(this.myConfigurationPanel, showConfigurePanel ? "configure" : "empty");
        this.myMessageLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)message));
    }

    private String getDownloadFilesMessage() {
        LibraryDownloadSettings downloadSettings = this.mySettings.getDownloadSettings();
        if (downloadSettings == null) {
            return "";
        }
        String downloadPath = downloadSettings.getDirectoryForDownloadedLibrariesPath();
        String basePath = this.mySettings.getBaseDirectoryPath();
        String path = !StringUtil.isEmpty((String)basePath) && FileUtil.startsWith((String)downloadPath, (String)basePath) ? FileUtil.getRelativePath((String)basePath, (String)downloadPath, (char)'/') : PathUtil.getFileName((String)downloadPath);
        return MessageFormat.format("{0} {0, choice, 1#JAR|2#JARs} will be downloaded into <b>{1}</b> directory<br>{2} library <b>{3}</b> will be created", new Object[]{downloadSettings.getSelectedDownloads().size(), path, downloadSettings.getLibraryLevel(), downloadSettings.getLibraryName()});
    }

    public LibraryCompositionSettings getSettings() {
        return this.mySettings;
    }

    @Nullable
    public LibraryCompositionSettings apply() {
        if (this.mySettings == null) {
            return null;
        }
        Choice option = (Choice)this.myButtonEnumModel.getSelected();
        this.mySettings.setDownloadLibraries(option == Choice.DOWNLOAD);
        Object item = this.myExistingLibraryComboBox.getSelectedItem();
        if (option == Choice.USE_LIBRARY && item instanceof ExistingLibraryEditor) {
            this.mySettings.setSelectedExistingLibrary(((ExistingLibraryEditor)item).getLibrary());
        } else {
            this.mySettings.setSelectedExistingLibrary(null);
        }
        if (option == Choice.USE_LIBRARY && item instanceof NewLibraryEditor) {
            this.mySettings.setNewLibraryEditor((NewLibraryEditor)item);
        } else {
            this.mySettings.setNewLibraryEditor(null);
        }
        this.mySettings.setLibraryProvider(option == Choice.USE_FROM_PROVIDER ? this.myLibraryProvider : null);
        return this.mySettings;
    }

    public JComponent getMainPanel() {
        return this.myRootPanel;
    }

    public void dispose() {
        this.myDisposed = true;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ButtonGroup buttonGroup;
        JRadioButton jRadioButton;
        JLabel jLabel;
        JBLabel jBLabel;
        JButton jButton;
        JPanel jPanel;
        JLabel jLabel2;
        JRadioButton jRadioButton2;
        JButton jButton2;
        JComboBox jComboBox;
        JPanel jPanel2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRootPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setEnabled(false);
        jPanel4.add((Component)jPanel3, "editing");
        this.myDownloadRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("Download");
        jRadioButton4.setMnemonic('D');
        jRadioButton4.setDisplayedMnemonicIndex(0);
        jRadioButton4.setSelected(false);
        jPanel3.add((Component)jRadioButton4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(207, 22), null));
        this.myDoNotCreateRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Set up library later");
        jRadioButton3.setMnemonic('L');
        jRadioButton3.setDisplayedMnemonicIndex(15);
        jPanel3.add((Component)jRadioButton3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySimplePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myExistingLibraryComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myCreateButton = jButton2 = new JButton();
        jButton2.setText("Create...");
        jButton2.setMnemonic('C');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myUseLibraryRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Use library:");
        jRadioButton2.setMnemonic('U');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jRadioButton2.setSelected(true);
        jPanel6.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseLibraryLabel = jLabel2 = new JLabel();
        jLabel2.setText("Use library:");
        ((Component)jLabel2).setVisible(true);
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConfigurationPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel7, "configure");
        this.myConfigureButton = jButton = new JButton();
        jButton.setText("Configure...");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 1, 1, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new CardLayout(0, 0));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMessageLabel = jBLabel = new JBLabel();
        jBLabel.setEnabled(true);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("<html>{} JARs will be downloaded into <b>lib</b> directory<br> Project level library <b>spring</b> will be created</html>");
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel8.add((Component)jBLabel, "message");
        this.myHiddenLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel8.add((Component)jLabel, "hidden");
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel9, "empty");
        this.myUseFromProviderRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Use from provider");
        jPanel3.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel10, "loading");
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Loading versions...");
        jPanel10.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel10.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myButtonGroup = buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton);
    }

    private static enum Choice {
        USE_LIBRARY,
        DOWNLOAD,
        SETUP_LIBRARY_LATER,
        USE_FROM_PROVIDER;

    }
}

