/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.BundleBase;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.projectWizard.WebProjectSettingsStepWrapper;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSettingsStepBase
extends AbstractActionWithPanel
implements DumbAware {
    protected final DirectoryProjectGenerator myProjectGenerator;
    private final NullableConsumer<ProjectSettingsStepBase> myCallback;
    protected TextFieldWithBrowseButton myLocationField;
    protected File myProjectDirectory;
    protected JButton myCreateButton;
    protected JLabel myErrorLabel;

    public ProjectSettingsStepBase(DirectoryProjectGenerator projectGenerator, NullableConsumer<ProjectSettingsStepBase> callback) {
        this.getTemplatePresentation().setIcon(projectGenerator.getLogo());
        this.getTemplatePresentation().setText(projectGenerator.getName());
        this.myProjectGenerator = projectGenerator;
        if (projectGenerator instanceof WebProjectTemplate) {
            ((WebProjectTemplate)projectGenerator).reset();
        }
        this.myCallback = callback;
        this.myProjectDirectory = ProjectSettingsStepBase.findSequentNonExistingUntitled();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/projectWizard/ProjectSettingsStepBase", "actionPerformed"));
        }
    }

    @Override
    public JPanel createPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JLabel label = this.createErrorLabel();
        JButton button = this.createActionButton();
        button.addActionListener(this.createCloseActionListener());
        JPanel scrollPanel = this.createAndFillContentPanel();
        this.initGeneratorListeners();
        this.registerValidators();
        JBScrollPane scrollPane = new JBScrollPane((Component)scrollPanel, 20, 31);
        scrollPane.setBorder(null);
        mainPanel.add((Component)scrollPane, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)label, "North");
        bottomPanel.add((Component)button, "East");
        mainPanel.add((Component)bottomPanel, "South");
        return mainPanel;
    }

    protected final JLabel createErrorLabel() {
        JLabel errorLabel = new JLabel("");
        errorLabel.setForeground((Color)JBColor.RED);
        this.myErrorLabel = errorLabel;
        return errorLabel;
    }

    protected final JButton createActionButton() {
        JButton button = new JButton("Create");
        button.putClientProperty("DefaultAction", Boolean.TRUE);
        this.myCreateButton = button;
        return button;
    }

    @NotNull
    protected final ActionListener createCloseActionListener() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isValid = ProjectSettingsStepBase.this.checkValid();
                if (isValid && ProjectSettingsStepBase.this.myCallback != null) {
                    DialogWrapper dialog = DialogWrapper.findInstance((Component)ProjectSettingsStepBase.this.myCreateButton);
                    if (dialog != null) {
                        dialog.close(0);
                    }
                    DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProjectSettingsStepBase.this.myCallback.consume((Object)ProjectSettingsStepBase.this);
                        }
                    });
                }
            }
        };
        if (actionListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/ProjectSettingsStepBase", "createCloseActionListener"));
        }
        return actionListener;
    }

    protected final JPanel createContentPanelWithAdvancedSettingsPanel() {
        JPanel basePanel = this.createBasePanel();
        JPanel scrollPanel = new JPanel(new BorderLayout());
        scrollPanel.add((Component)basePanel, "North");
        JPanel advancedSettings = this.createAdvancedSettings();
        if (advancedSettings != null) {
            scrollPanel.add((Component)advancedSettings, "Center");
        }
        return scrollPanel;
    }

    protected void initGeneratorListeners() {
        if (this.myProjectGenerator instanceof WebProjectTemplate) {
            ((WebProjectTemplate)this.myProjectGenerator).getPeer().addSettingsStateListener(new WebProjectGenerator.SettingsStateListener(){

                @Override
                public void stateChanged(boolean validSettings) {
                    ProjectSettingsStepBase.this.checkValid();
                }
            });
        }
    }

    protected final Icon getIcon() {
        return this.myProjectGenerator.getLogo();
    }

    protected JPanel createBasePanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 2));
        LabeledComponent<TextFieldWithBrowseButton> component = this.createLocationComponent();
        component.setLabelLocation("West");
        panel.add((Component)component);
        return panel;
    }

    protected void registerValidators() {
        this.myLocationField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ProjectSettingsStepBase.this.checkValid();
            }
        });
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectSettingsStepBase.this.checkValid();
            }
        };
        this.myLocationField.getTextField().addActionListener(listener2);
    }

    public boolean checkValid() {
        if (this.myLocationField == null) {
            return true;
        }
        String projectName = this.myLocationField.getText();
        this.setErrorText(null);
        if (projectName.trim().isEmpty()) {
            this.setErrorText("Project name can't be empty");
            return false;
        }
        if (this.myLocationField.getText().indexOf(36) >= 0) {
            this.setErrorText("Project directory name must not contain the $ character");
            return false;
        }
        if (this.myProjectGenerator != null) {
            WebProjectGenerator.GeneratorPeer peer;
            ValidationInfo validationInfo;
            String baseDirPath = this.myLocationField.getTextField().getText();
            ValidationResult validationResult = this.myProjectGenerator.validate(baseDirPath);
            if (!validationResult.isOk()) {
                this.setErrorText(validationResult.getErrorMessage());
                return false;
            }
            if (this.myProjectGenerator instanceof WebProjectTemplate && (validationInfo = (peer = ((WebProjectTemplate)this.myProjectGenerator).getPeer()).validate()) != null && !peer.isBackgroundJobRunning()) {
                this.setErrorText(validationInfo.message);
                return false;
            }
        }
        return true;
    }

    protected JPanel createAndFillContentPanel() {
        if (!(this.myProjectGenerator instanceof WebProjectTemplate)) {
            return this.createContentPanelWithAdvancedSettingsPanel();
        }
        WebProjectSettingsStepWrapper settingsStep = new WebProjectSettingsStepWrapper();
        ((WebProjectTemplate)this.myProjectGenerator).getPeer().buildUI(settingsStep);
        if (settingsStep.isEmpty()) {
            return this.createContentPanelWithAdvancedSettingsPanel();
        }
        JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 5));
        ArrayList labeledComponentList = ContainerUtil.newArrayList();
        labeledComponentList.add(this.createLocationComponent());
        labeledComponentList.addAll(settingsStep.getFields());
        JPanel scrollPanel = new JPanel(new BorderLayout());
        scrollPanel.add((Component)jPanel, "North");
        for (LabeledComponent labeledComponent : labeledComponentList) {
            labeledComponent.setLabelLocation("West");
            jPanel.add((Component)labeledComponent);
        }
        for (JComponent jComponent : settingsStep.getComponents()) {
            jPanel.add(jComponent);
        }
        UIUtil.mergeComponentsWithAnchor((Collection)labeledComponentList);
        return scrollPanel;
    }

    public void setErrorText(@Nullable String text) {
        this.myErrorLabel.setText(text);
        this.myErrorLabel.setForeground(MessageType.ERROR.getTitleForeground());
        this.myErrorLabel.setIcon(text == null ? null : AllIcons.Actions.Lightning);
        this.myCreateButton.setEnabled(text == null);
    }

    public void setWarningText(@Nullable String text) {
        this.myErrorLabel.setText("Note: " + text + "  ");
        this.myErrorLabel.setForeground(MessageType.WARNING.getTitleForeground());
    }

    @Nullable
    protected JPanel createAdvancedSettings() {
        if (this.myProjectGenerator instanceof WebProjectTemplate) {
            JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 5));
            jPanel.add(((WebProjectTemplate)this.myProjectGenerator).getPeer().getComponent());
            return jPanel;
        }
        return null;
    }

    public DirectoryProjectGenerator getProjectGenerator() {
        return this.myProjectGenerator;
    }

    public final String getProjectLocation() {
        return this.myLocationField.getText();
    }

    public final void setLocation(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/ide/util/projectWizard/ProjectSettingsStepBase", "setLocation"));
        }
        this.myLocationField.setText(location);
    }

    protected final LabeledComponent<TextFieldWithBrowseButton> createLocationComponent() {
        this.myLocationField = new TextFieldWithBrowseButton();
        this.myProjectDirectory = ProjectSettingsStepBase.findSequentNonExistingUntitled();
        this.myLocationField.setText(this.myProjectDirectory.toString());
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myLocationField.addBrowseFolderListener("Select base directory", "Select base directory for the Project", null, descriptor);
        return LabeledComponent.create((JComponent)this.myLocationField, (String)BundleBase.replaceMnemonicAmpersand((String)"&Location"));
    }

    private static File findSequentNonExistingUntitled() {
        return FileUtil.findSequentNonexistentFile((File)new File(ProjectUtil.getBaseDir()), (String)"untitled", (String)"");
    }
}

