/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationData {
    @NotNull
    private String myTitle;
    @NotNull
    private String myMessage;
    @NotNull
    private NotificationCategory myNotificationCategory;
    @NotNull
    private final NotificationSource myNotificationSource;
    @NotNull
    private NotificationListener myListener;
    @Nullable
    private String myFilePath;
    @Nullable
    private Navigatable navigatable;
    private int myLine;
    private int myColumn;
    private boolean myBalloonNotification;
    @Nullable
    private String myBalloonGroup;
    private final Map<String, NotificationListener> myListenerMap;

    public NotificationData(@NotNull String title, @NotNull String message, @NotNull NotificationCategory notificationCategory, @NotNull NotificationSource notificationSource) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "<init>"));
        }
        if (notificationCategory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationCategory", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "<init>"));
        }
        if (notificationSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationSource", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "<init>"));
        }
        this(title, message, notificationCategory, notificationSource, null, -1, -1, false);
    }

    public NotificationData(@NotNull String title, @NotNull String message, @NotNull NotificationCategory notificationCategory, @NotNull NotificationSource notificationSource, @Nullable String filePath, int line, int column, boolean balloonNotification) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "<init>"));
        }
        if (notificationCategory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationCategory", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "<init>"));
        }
        if (notificationSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationSource", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "<init>"));
        }
        this.myTitle = title;
        this.myMessage = message;
        this.myNotificationCategory = notificationCategory;
        this.myNotificationSource = notificationSource;
        this.myListenerMap = ContainerUtil.newHashMap();
        this.myListener = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/externalSystem/service/notification/NotificationData$1", "hyperlinkActivated"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/notification/NotificationData$1", "hyperlinkActivated"));
                }
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                NotificationListener notificationListener = (NotificationListener)NotificationData.this.myListenerMap.get(event.getDescription());
                if (notificationListener != null) {
                    notificationListener.hyperlinkUpdate(notification, event);
                }
            }
        };
        this.myFilePath = filePath;
        this.myLine = line;
        this.myColumn = column;
        this.myBalloonNotification = balloonNotification;
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "getTitle"));
        }
        return string;
    }

    public void setTitle(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "setTitle"));
        }
        this.myTitle = title;
    }

    @NotNull
    public String getMessage() {
        String string = this.myMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "getMessage"));
        }
        return string;
    }

    public void setMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "setMessage"));
        }
        this.myMessage = message;
    }

    @NotNull
    public NotificationCategory getNotificationCategory() {
        NotificationCategory notificationCategory = this.myNotificationCategory;
        if (notificationCategory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "getNotificationCategory"));
        }
        return notificationCategory;
    }

    public void setNotificationCategory(@NotNull NotificationCategory notificationCategory) {
        if (notificationCategory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationCategory", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "setNotificationCategory"));
        }
        this.myNotificationCategory = notificationCategory;
    }

    @NotNull
    public NotificationSource getNotificationSource() {
        NotificationSource notificationSource = this.myNotificationSource;
        if (notificationSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "getNotificationSource"));
        }
        return notificationSource;
    }

    @NotNull
    public NotificationListener getListener() {
        NotificationListener notificationListener = this.myListener;
        if (notificationListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "getListener"));
        }
        return notificationListener;
    }

    @Nullable
    public String getFilePath() {
        return this.myFilePath;
    }

    public void setFilePath(@Nullable String filePath) {
        this.myFilePath = filePath;
    }

    @NotNull
    public Integer getLine() {
        Integer n = this.myLine;
        if (n == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "getLine"));
        }
        return n;
    }

    public void setLine(int line) {
        this.myLine = line;
    }

    public int getColumn() {
        return this.myColumn;
    }

    public void setColumn(int column) {
        this.myColumn = column;
    }

    public boolean isBalloonNotification() {
        return this.myBalloonNotification;
    }

    public void setBalloonNotification(boolean balloonNotification) {
        this.myBalloonNotification = balloonNotification;
    }

    public void setListener(@NotNull String listenerId, @NotNull NotificationListener listener2) {
        if (listenerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listenerId", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "setListener"));
        }
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/externalSystem/service/notification/NotificationData", "setListener"));
        }
        this.myListenerMap.put(listenerId, listener2);
    }

    boolean hasLinks() {
        return !this.myListenerMap.isEmpty();
    }

    public List<String> getRegisteredListenerIds() {
        return ContainerUtil.newArrayList(this.myListenerMap.keySet());
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.navigatable;
    }

    public void setNavigatable(@Nullable Navigatable navigatable) {
        this.navigatable = navigatable;
    }

    @Nullable
    public String getBalloonGroup() {
        return this.myBalloonGroup;
    }

    public void setBalloonGroup(@Nullable String balloonGroup) {
        this.myBalloonGroup = balloonGroup;
    }
}

