/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModuleDataService<E extends ModuleData>
extends AbstractProjectDataService<E, Module> {
    public static final Key<ModuleData> MODULE_DATA_KEY = Key.create((String)"MODULE_DATA_KEY");
    public static final Key<Module> MODULE_KEY = Key.create((String)"LINKED_MODULE");
    public static final Key<Map<OrderEntry, OrderAware>> ORDERED_DATA_MAP_KEY = Key.create((String)"ORDER_ENTRY_DATA_MAP");
    public static final Key<Set<String>> ORPHAN_MODULE_FILES = Key.create((String)"ORPHAN_FILES");
    private static final Logger LOG = Logger.getInstance(AbstractModuleDataService.class);

    public void importData(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Module module2;
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "importData"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "importData"));
        }
        if (toImport.isEmpty()) {
            return;
        }
        Collection<DataNode<E>> toCreate = this.filterExistingModules(toImport, modelsProvider, project2);
        if (!toCreate.isEmpty()) {
            this.createModules(toCreate, modelsProvider, project2);
        }
        for (DataNode<E> node : toImport) {
            module2 = (Module)node.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            String productionModuleId = ((ModuleData)node.getData()).getProductionModuleId();
            if (productionModuleId != null) {
                modelsProvider.setTestModuleProperties(module2, productionModuleId);
            }
            this.setModuleOptions(module2, node);
            ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module2);
            AbstractModuleDataService.syncPaths(module2, modifiableRootModel, (ModuleData)node.getData());
            this.setLanguageLevel(modifiableRootModel, (ModuleData)node.getData());
        }
        for (DataNode<E> node : toImport) {
            module2 = (Module)node.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            String[] groupPath = ((ModuleData)node.getData()).getIdeModuleGroup();
            ModifiableModuleModel modifiableModel = modelsProvider.getModifiableModuleModel();
            modifiableModel.setModuleGroupPath(module2, groupPath);
        }
    }

    private void createModules(@NotNull Collection<DataNode<E>> toCreate, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project2) {
        if (toCreate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCreate", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "createModules"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "createModules"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "createModules"));
        }
        for (DataNode<E> module2 : toCreate) {
            ModuleData data = (ModuleData)module2.getData();
            Module created = modelsProvider.newModule(data.getModuleFilePath(), data.getModuleTypeId());
            module2.putUserData(MODULE_KEY, (Object)created);
            Set orphanFiles = (Set)project2.getUserData(ORPHAN_MODULE_FILES);
            if (orphanFiles != null) {
                orphanFiles.remove(created.getModuleFilePath());
            }
            final ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(created);
            modifiableRootModel.inheritSdk();
            RootPolicy<Object> visitor = new RootPolicy<Object>(){

                public Object visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, Object value) {
                    modifiableRootModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
                    return value;
                }

                public Object visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, Object value) {
                    modifiableRootModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
                    return value;
                }
            };
            for (OrderEntry orderEntry : modifiableRootModel.getOrderEntries()) {
                orderEntry.accept((RootPolicy)visitor, null);
            }
        }
    }

    @NotNull
    private Collection<DataNode<E>> filterExistingModules(@NotNull Collection<DataNode<E>> modules, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project2) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "filterExistingModules"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "filterExistingModules"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "filterExistingModules"));
        }
        ArrayList result = ContainerUtilRt.newArrayList();
        for (DataNode<E> node : modules) {
            ModuleData moduleData = (ModuleData)node.getData();
            Module module2 = modelsProvider.findIdeModule(moduleData.getInternalName());
            if (module2 == null) {
                result.add(node);
                continue;
            }
            if (!FileUtil.pathsEqual((String)module2.getModuleFilePath(), (String)moduleData.getModuleFilePath())) {
                modelsProvider.getModifiableModuleModel().disposeModule(module2);
                result.add(node);
                Set orphanFiles = (Set)project2.getUserData(ORPHAN_MODULE_FILES);
                if (orphanFiles == null) {
                    orphanFiles = ContainerUtil.newHashSet();
                    project2.putUserData(ORPHAN_MODULE_FILES, (Object)orphanFiles);
                }
                orphanFiles.add(module2.getModuleFilePath());
                continue;
            }
            node.putUserData(MODULE_KEY, (Object)module2);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "filterExistingModules"));
        }
        return arrayList;
    }

    private static void syncPaths(@NotNull Module module2, @NotNull ModifiableRootModel modifiableModel, @NotNull ModuleData data) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "syncPaths"));
        }
        if (modifiableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModel", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "syncPaths"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "syncPaths"));
        }
        CompilerModuleExtension extension = (CompilerModuleExtension)modifiableModel.getModuleExtension(CompilerModuleExtension.class);
        if (extension == null) {
            LOG.warn(String.format("Can't sync paths for module '%s'. Reason: no compiler extension is found for it", module2.getName()));
            return;
        }
        String compileOutputPath = data.getCompileOutputPath(ExternalSystemSourceType.SOURCE);
        extension.setCompilerOutputPath(compileOutputPath != null ? VfsUtilCore.pathToUrl((String)compileOutputPath) : null);
        String testCompileOutputPath = data.getCompileOutputPath(ExternalSystemSourceType.TEST);
        extension.setCompilerOutputPathForTests(testCompileOutputPath != null ? VfsUtilCore.pathToUrl((String)testCompileOutputPath) : null);
        extension.inheritCompilerOutputPath(data.isInheritProjectCompileOutputPath());
    }

    public void removeData(@NotNull Computable<Collection<Module>> toRemoveComputable, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemoveComputable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemoveComputable", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "removeData"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "removeData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "removeData"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "removeData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "removeData"));
        }
        Collection toRemove = (Collection)toRemoveComputable.compute();
        SmartList modules = new SmartList(toRemove);
        for (DataNode<E> moduleDataNode : toIgnore) {
            Module module2 = modelsProvider.findIdeModule((ModuleData)moduleDataNode.getData());
            ContainerUtil.addIfNotNull((Collection)modules, (Object)module2);
        }
        if (modules.isEmpty()) {
            return;
        }
        ContainerUtil.removeDuplicates((Collection)modules);
        for (Module module3 : modules) {
            if (module3.isDisposed()) continue;
            AbstractModuleDataService.unlinkModuleFromExternalSystem(module3);
        }
        AbstractModuleDataService.ruleOrphanModules((List<Module>)modules, project2, projectData.getOwner(), new Consumer<List<Module>>(){

            public void consume(List<Module> modules) {
                for (Module module2 : modules) {
                    if (module2.isDisposed()) continue;
                    String path = module2.getModuleFilePath();
                    ModifiableModuleModel moduleModel = modelsProvider.getModifiableModuleModel();
                    moduleModel.disposeModule(module2);
                    ModuleBuilder.deleteModuleFile((String)path);
                }
            }
        });
    }

    private static void ruleOrphanModules(final @NotNull List<Module> orphanModules, final @NotNull Project project2, final @NotNull ProjectSystemId externalSystemId, final @NotNull Consumer<List<Module>> result) {
        if (orphanModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphanModules", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "ruleOrphanModules"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "ruleOrphanModules"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "ruleOrphanModules"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "ruleOrphanModules"));
        }
        ExternalSystemApiUtil.executeOnEdt((boolean)true, (Runnable)new Runnable(){

            @Override
            public void run() {
                List toRemove = ContainerUtil.newSmartList();
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    toRemove.addAll(orphanModules);
                } else {
                    final JPanel content = new JPanel(new GridBagLayout());
                    content.add((Component)new JLabel(ExternalSystemBundle.message((String)"orphan.modules.text", (Object[])new Object[]{externalSystemId.getReadableName()})), ExternalSystemUiUtil.getFillLineConstraints(0));
                    CheckBoxList orphanModulesList = new CheckBoxList();
                    orphanModulesList.setSelectionMode(2);
                    orphanModulesList.setItems(orphanModules, (Function)new Function<Module, String>(){

                        public String fun(Module module2) {
                            return module2.getName();
                        }
                    });
                    for (Module module2 : orphanModules) {
                        orphanModulesList.setItemSelected((Object)module2, true);
                    }
                    orphanModulesList.setBorder(IdeBorderFactory.createEmptyBorder((int)8));
                    content.add((Component)orphanModulesList, ExternalSystemUiUtil.getFillLineConstraints(0));
                    content.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)8, (int)0));
                    DialogWrapper dialog = new DialogWrapper(project2){
                        {
                            super(arg0);
                            this.setTitle(ExternalSystemBundle.message((String)"import.title", (Object[])new Object[]{externalSystemId.getReadableName()}));
                            this.init();
                        }

                        @Nullable
                        protected JComponent createCenterPanel() {
                            return new JBScrollPane((Component)content);
                        }

                        @NotNull
                        protected Action[] createActions() {
                            Action[] actionArray = new Action[]{this.getOKAction()};
                            if (actionArray == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService$3$2", "createActions"));
                            }
                            return actionArray;
                        }
                    };
                    dialog.showAndGet();
                    for (int i = 0; i < orphanModules.size(); ++i) {
                        Module module3 = (Module)orphanModules.get(i);
                        if (!orphanModulesList.isItemSelected(i)) continue;
                        toRemove.add(module3);
                    }
                }
                result.consume((Object)toRemove);
            }
        });
    }

    public static void unlinkModuleFromExternalSystem(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "unlinkModuleFromExternalSystem"));
        }
        module2.clearOption("external.system.id");
        module2.clearOption("external.linked.project.id");
        module2.clearOption("external.linked.project.path");
        module2.clearOption("external.root.project.path");
        module2.clearOption("external.system.module.group");
        module2.clearOption("external.system.module.version");
    }

    protected void setModuleOptions(Module module2, DataNode<E> moduleDataNode) {
        ModuleData moduleData = (ModuleData)moduleDataNode.getData();
        module2.putUserData(MODULE_DATA_KEY, (Object)moduleData);
        module2.setOption("external.system.id", moduleData.getOwner().toString());
        module2.setOption("external.linked.project.id", moduleData.getId());
        module2.setOption("external.linked.project.path", moduleData.getLinkedExternalProjectPath());
        ProjectData projectData = (ProjectData)moduleDataNode.getData(ProjectKeys.PROJECT);
        module2.setOption("external.root.project.path", projectData != null ? projectData.getLinkedExternalProjectPath() : "");
        if (moduleData.getGroup() != null) {
            module2.setOption("external.system.module.group", moduleData.getGroup());
        }
        if (moduleData.getVersion() != null) {
            module2.setOption("external.system.module.version", moduleData.getVersion());
        }
        module2.clearOption("org.jetbrains.idea.maven.project.MavenProjectsManager.isMavenModule");
    }

    public void postProcess(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "postProcess"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "postProcess"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "postProcess"));
        }
        for (DataNode<E> moduleDataNode : toImport) {
            Module module2 = (Module)moduleDataNode.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            Map orderAwareMap = (Map)moduleDataNode.getUserData(ORDERED_DATA_MAP_KEY);
            if (orderAwareMap != null) {
                this.rearrangeOrderEntries(orderAwareMap, modelsProvider.getModifiableRootModel(module2));
            }
            this.setBytecodeTargetLevel(project2, module2, (ModuleData)moduleDataNode.getData());
        }
        for (Module module3 : modelsProvider.getModules()) {
            module3.putUserData(MODULE_DATA_KEY, null);
        }
    }

    public void onSuccessImport(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "onSuccessImport"));
        }
        final Set orphanFiles = (Set)project2.getUserData(ORPHAN_MODULE_FILES);
        if (orphanFiles != null && !orphanFiles.isEmpty()) {
            ExternalSystemApiUtil.executeOnEdt((boolean)false, (Runnable)new Runnable(){

                @Override
                public void run() {
                    for (String orphanFile : orphanFiles) {
                        ModuleBuilder.deleteModuleFile((String)orphanFile);
                    }
                }
            });
            project2.putUserData(ORPHAN_MODULE_FILES, null);
        }
    }

    protected void rearrangeOrderEntries(@NotNull Map<OrderEntry, OrderAware> orderEntryDataMap, @NotNull ModifiableRootModel modifiableRootModel) {
        Pair<OrderEntry, OrderAware> pair;
        OrderAware orderAware;
        OrderEntry orderEntry;
        if (orderEntryDataMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntryDataMap", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "rearrangeOrderEntries"));
        }
        if (modifiableRootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableRootModel", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "rearrangeOrderEntries"));
        }
        Object[] orderEntries = modifiableRootModel.getOrderEntries();
        int length = orderEntries.length;
        Object[] newOrder = new OrderEntry[length];
        PriorityQueue<Pair<OrderEntry, OrderAware>> priorityQueue = new PriorityQueue<Pair<OrderEntry, OrderAware>>(11, new Comparator<Pair<OrderEntry, OrderAware>>(){

            @Override
            public int compare(Pair<OrderEntry, OrderAware> o1, Pair<OrderEntry, OrderAware> o2) {
                int order2;
                int order1 = ((OrderAware)o1.second).getOrder();
                return order1 != (order2 = ((OrderAware)o2.second).getOrder()) ? (order1 < order2 ? -1 : 1) : 0;
            }
        });
        int shift = 0;
        for (int i = 0; i < length; ++i) {
            orderEntry = orderEntries[i];
            orderAware = orderEntryDataMap.get(orderEntry);
            if (orderAware == null) {
                newOrder[i] = orderEntry;
                ++shift;
                continue;
            }
            priorityQueue.add((Pair<OrderEntry, OrderAware>)Pair.create((Object)orderEntry, (Object)orderAware));
        }
        while ((pair = priorityQueue.poll()) != null) {
            orderEntry = (OrderEntry)pair.first;
            orderAware = (OrderAware)pair.second;
            int order = orderAware.getOrder() != -1 ? orderAware.getOrder() : length - 1;
            int newPlace = AbstractModuleDataService.findNewPlace((OrderEntry[])newOrder, order - shift);
            assert (newPlace != -1);
            newOrder[newPlace] = orderEntry;
        }
        if (LOG.isDebugEnabled()) {
            boolean changed = !ArrayUtil.equals((Object[])orderEntries, (Object[])newOrder, (Comparator)new Comparator<OrderEntry>(){

                @Override
                public int compare(OrderEntry o1, OrderEntry o2) {
                    return o1.compareTo((Object)o2);
                }
            });
            LOG.debug(String.format("rearrange status (%s): %s", modifiableRootModel.getModule(), changed ? "modified" : "not modified"));
        }
        modifiableRootModel.rearrangeOrderEntries((OrderEntry[])newOrder);
    }

    private static int findNewPlace(OrderEntry[] newOrder, int newIndex) {
        int idx;
        for (idx = newIndex; idx < 0 || idx < newOrder.length && newOrder[idx] != null; ++idx) {
        }
        if (idx >= newOrder.length) {
            for (idx = newIndex - 1; idx >= 0 && (idx >= newOrder.length || newOrder[idx] != null); --idx) {
            }
        }
        return idx == -1 ? -1 : idx;
    }

    private void setLanguageLevel(@NotNull ModifiableRootModel modifiableRootModel, E data) {
        if (modifiableRootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableRootModel", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "setLanguageLevel"));
        }
        LanguageLevel level = LanguageLevel.parse((String)data.getSourceCompatibility());
        if (level != null) {
            try {
                ((LanguageLevelModuleExtension)modifiableRootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level);
            }
            catch (IllegalArgumentException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    private void setBytecodeTargetLevel(@NotNull Project project2, @NotNull Module module2, @NotNull E data) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "setBytecodeTargetLevel"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "setBytecodeTargetLevel"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService", "setBytecodeTargetLevel"));
        }
        String targetLevel = data.getTargetCompatibility();
        if (targetLevel != null) {
            CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)project2);
            configuration.setBytecodeTargetLevel(module2, targetLevel);
        }
    }
}

