/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.ui.GuiUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushedFilePropertiesUpdaterImpl
extends PushedFilePropertiesUpdater {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater");
    private final Project myProject;
    private final FilePropertyPusher[] myPushers;
    private final FilePropertyPusher[] myFilePushers;
    private final Queue<Runnable> myTasks = new ConcurrentLinkedQueue<Runnable>();

    public PushedFilePropertiesUpdaterImpl(final Project project2) {
        this.myProject = project2;
        this.myPushers = (FilePropertyPusher[])Extensions.getExtensions((ExtensionPointName)FilePropertyPusher.EP_NAME);
        this.myFilePushers = (FilePropertyPusher[])ContainerUtil.findAllAsArray((Object[])this.myPushers, (Condition)new Condition<FilePropertyPusher>(){

            public boolean value(FilePropertyPusher pusher) {
                return !pusher.pushDirectoriesOnly();
            }
        });
        StartupManager.getInstance((Project)project2).registerPreStartupActivity(new Runnable(){

            @Override
            public void run() {
                project2.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

                    public void rootsChanged(ModuleRootEvent event) {
                        for (FilePropertyPusher pusher : PushedFilePropertiesUpdaterImpl.this.myPushers) {
                            pusher.afterRootsChanged(project2);
                        }
                    }
                });
            }
        });
    }

    public void processAfterVfsChanges(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl", "processAfterVfsChanges"));
        }
        boolean pushedSomething = false;
        ArrayList delayedTasks = ContainerUtil.newArrayList();
        for (VFileEvent vFileEvent : events) {
            FilePropertyPusher[] pushers;
            VirtualFile file2 = vFileEvent.getFile();
            if (file2 == null || (pushers = file2.isDirectory() ? this.myPushers : this.myFilePushers).length == 0) continue;
            if (vFileEvent instanceof VFileCreateEvent) {
                if (!vFileEvent.isFromRefresh() || !file2.isDirectory()) {
                    this.doPushRecursively(file2, pushers, ProjectRootManager.getInstance((Project)this.myProject).getFileIndex());
                    pushedSomething = true;
                    continue;
                }
                if (ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2)) continue;
                ContainerUtil.addIfNotNull((Collection)delayedTasks, (Object)this.createRecursivePushTask(file2, pushers));
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent)) continue;
            for (FilePropertyPusher pusher : pushers) {
                file2.putUserData(pusher.getFileDataKey(), null);
            }
            this.doPushRecursively(file2, pushers, ProjectRootManager.getInstance((Project)this.myProject).getFileIndex());
            pushedSomething = true;
        }
        if (!delayedTasks.isEmpty()) {
            this.queueTasks(delayedTasks);
        }
        if (pushedSomething) {
            GuiUtils.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    PushedFilePropertiesUpdaterImpl.this.scheduleDumbModeReindexingIfNeeded();
                }
            }, (ModalityState)ModalityState.defaultModalityState());
        }
    }

    public void initializeProperties() {
        for (final FilePropertyPusher pusher : this.myPushers) {
            pusher.initExtra(this.myProject, this.myProject.getMessageBus(), new FilePropertyPusher.Engine(){

                public void pushAll() {
                    PushedFilePropertiesUpdaterImpl.this.pushAll(pusher);
                }

                public void pushRecursively(VirtualFile file2, Project project2) {
                    PushedFilePropertiesUpdaterImpl.this.queueTasks(ContainerUtil.createMaybeSingletonList((Object)PushedFilePropertiesUpdaterImpl.this.createRecursivePushTask(file2, new FilePropertyPusher[]{pusher})));
                }
            });
        }
    }

    public void pushAllPropertiesNow() {
        this.performPushTasks();
        this.doPushAll(this.myPushers);
    }

    @Nullable
    private Runnable createRecursivePushTask(final VirtualFile dir, final FilePropertyPusher[] pushers) {
        if (pushers.length == 0) {
            return null;
        }
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        if (!fileIndex.isInContent(dir)) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                PushedFilePropertiesUpdaterImpl.this.doPushRecursively(dir, pushers, fileIndex);
            }
        };
    }

    private void doPushRecursively(VirtualFile dir, final FilePropertyPusher[] pushers, ProjectFileIndex fileIndex) {
        fileIndex.iterateContentUnderDirectory(dir, new ContentIterator(){

            public boolean processFile(VirtualFile fileOrDir) {
                PushedFilePropertiesUpdaterImpl.this.applyPushersToFile(fileOrDir, pushers, null);
                return true;
            }
        });
    }

    private void queueTasks(List<? extends Runnable> actions) {
        for (Runnable runnable2 : actions) {
            this.myTasks.offer(runnable2);
        }
        final DumbModeTask task = new DumbModeTask(){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$7", "performInDumbMode"));
                }
                PushedFilePropertiesUpdaterImpl.this.performPushTasks();
            }
        };
        this.myProject.getMessageBus().connect((Disposable)task).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                DumbService.getInstance((Project)PushedFilePropertiesUpdaterImpl.this.myProject).cancelTask(task);
            }
        });
        DumbService.getInstance((Project)this.myProject).queueTask(task);
    }

    private void performPushTasks() {
        Runnable task;
        boolean hadTasks = false;
        while ((task = this.myTasks.poll()) != null) {
            try {
                task.run();
                hadTasks = true;
            }
            catch (ProcessCanceledException e) {
                this.queueTasks(Collections.singletonList(task));
                throw e;
            }
        }
        if (hadTasks) {
            this.scheduleDumbModeReindexingIfNeeded();
        }
    }

    private void scheduleDumbModeReindexingIfNeeded() {
        if (this.myProject.isDisposed()) {
            return;
        }
        DumbModeTask task = FileBasedIndexProjectHandler.createChangedFilesIndexingTask(this.myProject);
        if (task != null) {
            DumbService.getInstance((Project)this.myProject).queueTask(task);
        }
    }

    private static <T> T findPusherValuesUpwards(Project project2, VirtualFile dir, FilePropertyPusher<T> pusher, T moduleValue) {
        Object value = pusher.getImmediateValue(project2, dir);
        if (value != null) {
            return (T)value;
        }
        if (moduleValue != null) {
            return moduleValue;
        }
        VirtualFile parent = dir.getParent();
        if (parent != null) {
            return PushedFilePropertiesUpdaterImpl.findPusherValuesUpwards(project2, parent, pusher);
        }
        Object projectValue = pusher.getImmediateValue(project2, null);
        return (T)(projectValue != null ? projectValue : pusher.getDefaultValue());
    }

    private static <T> T findPusherValuesUpwards(Project project2, VirtualFile dir, FilePropertyPusher<T> pusher) {
        Object userValue = dir.getUserData(pusher.getFileDataKey());
        if (userValue != null) {
            return (T)userValue;
        }
        Object value = pusher.getImmediateValue(project2, dir);
        if (value != null) {
            return (T)value;
        }
        VirtualFile parent = dir.getParent();
        if (parent != null) {
            return PushedFilePropertiesUpdaterImpl.findPusherValuesUpwards(project2, parent, pusher);
        }
        Object projectValue = pusher.getImmediateValue(project2, null);
        return (T)(projectValue != null ? projectValue : pusher.getDefaultValue());
    }

    public void pushAll(final FilePropertyPusher ... pushers) {
        this.queueTasks(Collections.singletonList(new Runnable(){

            @Override
            public void run() {
                PushedFilePropertiesUpdaterImpl.this.doPushAll(pushers);
            }
        }));
    }

    private void doPushAll(final FilePropertyPusher[] pushers) {
        Module[] modules = (Module[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module[]>(){

            public Module[] compute() {
                return ModuleManager.getInstance((Project)PushedFilePropertiesUpdaterImpl.this.myProject).getModules();
            }
        });
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        for (final Module module2 : modules) {
            Runnable iteration = (Runnable)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Runnable>(){

                public Runnable compute() {
                    if (module2.isDisposed()) {
                        return EmptyRunnable.INSTANCE;
                    }
                    ProgressManager.checkCanceled();
                    final Object[] moduleValues = new Object[pushers.length];
                    for (int i = 0; i < moduleValues.length; ++i) {
                        moduleValues[i] = pushers[i].getImmediateValue(module2);
                    }
                    final ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module2).getFileIndex();
                    return new Runnable(){

                        @Override
                        public void run() {
                            fileIndex.iterateContent(new ContentIterator(){

                                public boolean processFile(VirtualFile fileOrDir) {
                                    PushedFilePropertiesUpdaterImpl.this.applyPushersToFile(fileOrDir, pushers, moduleValues);
                                    return true;
                                }
                            });
                        }
                    };
                }
            });
            tasks.add(iteration);
        }
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
    }

    public static void invokeConcurrentlyIfPossible(List<Runnable> tasks) {
        Runnable runnable2;
        if (tasks.size() == 1 || ApplicationManager.getApplication().isWriteAccessAllowed() || !Registry.is((String)"idea.concurrent.scanning.files.to.index")) {
            for (Runnable r : tasks) {
                r.run();
            }
            return;
        }
        final ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        final ConcurrentLinkedQueue<Runnable> tasksQueue = new ConcurrentLinkedQueue<Runnable>(tasks);
        ArrayList results = ContainerUtil.newArrayList();
        if (tasks.size() > 1) {
            int numThreads = Math.max(Math.min(CacheUpdateRunner.indexingThreadCount() - 1, tasks.size() - 1), 1);
            for (int i = 0; i < numThreads; ++i) {
                results.add(ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        ProgressManager.getInstance().runProcess(new Runnable(){

                            @Override
                            public void run() {
                                Runnable runnable2;
                                while ((runnable2 = (Runnable)tasksQueue.poll()) != null) {
                                    runnable2.run();
                                }
                            }
                        }, (ProgressIndicator)ProgressWrapper.wrap(progress));
                    }
                }));
            }
        }
        while ((runnable2 = tasksQueue.poll()) != null) {
            runnable2.run();
        }
        for (Future result : results) {
            try {
                result.get();
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
    }

    private void applyPushersToFile(final VirtualFile fileOrDir, final FilePropertyPusher[] pushers, final Object[] moduleValues) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                ProgressManager.checkCanceled();
                if (!fileOrDir.isValid()) {
                    return;
                }
                PushedFilePropertiesUpdaterImpl.this.doApplyPushersToFile(fileOrDir, pushers, moduleValues);
            }
        });
    }

    private void doApplyPushersToFile(VirtualFile fileOrDir, FilePropertyPusher[] pushers, Object[] moduleValues) {
        Object pusher = null;
        try {
            boolean isDir = fileOrDir.isDirectory();
            int pushersLength = pushers.length;
            for (int i = 0; i < pushersLength; ++i) {
                pusher = pushers[i];
                if (!isDir && (pusher.pushDirectoriesOnly() || !pusher.acceptsFile(fileOrDir)) || isDir && !pusher.acceptsDirectory(fileOrDir, this.myProject)) continue;
                this.findAndUpdateValue(fileOrDir, (FilePropertyPusher)pusher, (Object)(moduleValues != null ? moduleValues[i] : null));
            }
        }
        catch (AbstractMethodError ame) {
            if (pusher != null) {
                throw new ExtensionException(pusher.getClass());
            }
            throw ame;
        }
    }

    public <T> void findAndUpdateValue(VirtualFile fileOrDir, FilePropertyPusher<T> pusher, T moduleValue) {
        T value = PushedFilePropertiesUpdaterImpl.findPusherValuesUpwards(this.myProject, fileOrDir, pusher, moduleValue);
        PushedFilePropertiesUpdaterImpl.updateValue(this.myProject, fileOrDir, value, pusher);
    }

    private static <T> void updateValue(Project project2, VirtualFile fileOrDir, T value, FilePropertyPusher<T> pusher) {
        Object oldValue = fileOrDir.getUserData(pusher.getFileDataKey());
        if (value != oldValue) {
            fileOrDir.putUserData(pusher.getFileDataKey(), value);
            try {
                pusher.persistAttribute(project2, fileOrDir, value);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void filePropertiesChanged(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl", "filePropertiesChanged"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileBasedIndex.getInstance().requestReindex(file2);
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            PushedFilePropertiesUpdaterImpl.reloadPsi(file2, project2);
        }
    }

    private static void reloadPsi(final VirtualFile file2, final Project project2) {
        final FileManagerImpl fileManager = (FileManagerImpl)((PsiManagerEx)PsiManager.getInstance((Project)project2)).getFileManager();
        if (fileManager.findCachedViewProvider(file2) != null) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (project2.isDisposed()) {
                        return;
                    }
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            fileManager.forceReload(file2);
                        }
                    });
                }
            });
        }
    }
}

