/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.storage;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageManagerListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClasspathStorage
extends StateStorageBase<Boolean> {
    private static final Logger LOG = Logger.getInstance(ClasspathStorage.class);
    private final ClasspathStorageProvider.ClasspathConverter myConverter;
    private final TrackingPathMacroSubstitutor myPathMacroSubstitutor;

    public ClasspathStorage(final @NotNull Module module2, @NotNull StateStorageManager storageManager2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "<init>"));
        }
        if (storageManager2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "<init>"));
        }
        String storageType = module2.getOptionValue("classpath");
        if (storageType == null) {
            throw new IllegalStateException("Classpath storage requires non-default storage type");
        }
        ClasspathStorageProvider provider = ClasspathStorage.getProvider(storageType);
        if (provider == null) {
            throw new IllegalStateException("Classpath storage provider not found, please ensure that Eclipse plugin is installed");
        }
        this.myConverter = provider.createConverter(module2);
        this.myPathMacroSubstitutor = storageManager2.getMacroSubstitutor();
        final List<String> paths = this.myConverter.getFilePaths();
        MessageBusConnection busConnection = module2.getMessageBus().connect();
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$1", "after"));
                }
                for (VFileEvent vFileEvent : events) {
                    if (!vFileEvent.isFromRefresh() || !(vFileEvent instanceof VFileContentChangeEvent)) continue;
                    for (String path : paths) {
                        if (!path.equals(vFileEvent.getPath())) continue;
                        ((StateStorageManager.IStorageManagerListener)module2.getMessageBus().syncPublisher(StateStorageManager.STORAGE_TOPIC)).storageFileChanged(vFileEvent, ClasspathStorage.this, (ComponentManager)module2);
                        return;
                    }
                }
            }
        });
        busConnection.subscribe(StateStorageManager.STORAGE_TOPIC, (Object)new StorageManagerListener(){

            private String fileNameToModuleName(@NotNull String fileName) {
                if (fileName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$2", "fileNameToModuleName"));
                }
                return fileName.substring(0, fileName.length() - ".iml".length());
            }

            @Override
            public void storageFileChanged(@NotNull VFileEvent event, @NotNull StateStorage storage2, @NotNull ComponentManager componentManager) {
                ClasspathStorageProvider provider;
                String oldFileName;
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$2", "storageFileChanged"));
                }
                if (storage2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$2", "storageFileChanged"));
                }
                if (componentManager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentManager", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$2", "storageFileChanged"));
                }
                assert (componentManager == module2);
                if (!(event instanceof VFilePropertyChangeEvent)) {
                    return;
                }
                VFilePropertyChangeEvent propertyEvent = (VFilePropertyChangeEvent)event;
                if (propertyEvent.getPropertyName().equals("name") && (oldFileName = (String)propertyEvent.getOldValue()).endsWith(".iml") && (provider = ClasspathStorage.getProvider(ClassPathStorageUtil.getStorageType(module2))) != null) {
                    provider.moduleRenamed(module2, this.fileNameToModuleName(oldFileName), this.fileNameToModuleName((String)propertyEvent.getNewValue()));
                }
            }
        });
    }

    @Override
    @Nullable
    public <S> S deserializeState(@Nullable Element serializedState, @NotNull Class<S> stateClass, @Nullable S mergeInto) {
        if (stateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateClass", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "deserializeState"));
        }
        if (serializedState == null) {
            return null;
        }
        ModuleRootManagerImpl.ModuleRootManagerState state = new ModuleRootManagerImpl.ModuleRootManagerState();
        state.readExternal(serializedState);
        return (S)state;
    }

    @Override
    protected boolean hasState(@NotNull Boolean storageData, @NotNull String componentName) {
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "hasState"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "hasState"));
        }
        return storageData == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Element getSerializedState(@NotNull Boolean storageData, Object component, @NotNull String componentName, boolean archive) {
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getSerializedState"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getSerializedState"));
        }
        if (storageData.booleanValue()) {
            return null;
        }
        Element element = new Element("component");
        ModifiableRootModel model = null;
        AccessToken token = ReadAction.start();
        try {
            model = ((ModuleRootManagerImpl)((Object)component)).getModifiableModel();
            model.clear();
            try {
                this.myConverter.readClasspath(model);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ((RootModelImpl)model).writeExternal(element);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                token.finish();
            }
            finally {
                if (model != null) {
                    model.dispose();
                }
            }
        }
        if (this.myPathMacroSubstitutor != null) {
            this.myPathMacroSubstitutor.expandPaths(element);
            this.myPathMacroSubstitutor.addUnknownMacros("NewModuleRootManager", PathMacrosCollector.getMacroNames(element));
        }
        this.getStorageDataRef().set(true);
        return element;
    }

    @Override
    @NotNull
    protected Boolean loadData() {
        Boolean bl = false;
        if (bl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "loadData"));
        }
        return bl;
    }

    @NotNull
    public StateStorage.ExternalizationSession startExternalization() {
        StateStorage.ExternalizationSession externalizationSession = this.myConverter.startExternalization();
        if (externalizationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "startExternalization"));
        }
        return externalizationSession;
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Set<String> componentNames) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        componentNames.add("NewModuleRootManager");
        this.getStorageDataRef().set(false);
    }

    @Nullable
    public static ClasspathStorageProvider getProvider(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getProvider"));
        }
        if (type.equals("default")) {
            return null;
        }
        for (ClasspathStorageProvider provider : (ClasspathStorageProvider[])ClasspathStorageProvider.EXTENSION_POINT_NAME.getExtensions()) {
            if (!type.equals(provider.getID())) continue;
            return provider;
        }
        return null;
    }

    @NotNull
    public static String getStorageRootFromOptions(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getStorageRootFromOptions"));
        }
        String moduleRoot = ModuleUtilCore.getModuleDirPath((Module)module2);
        String storageRef = module2.getOptionValue("classpath-dir");
        if (storageRef == null) {
            String string = moduleRoot;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getStorageRootFromOptions"));
            }
            return string;
        }
        storageRef = FileUtil.toSystemIndependentName((String)storageRef);
        if (SystemInfo.isWindows ? FileUtil.isAbsolutePlatformIndependent((String)storageRef) : FileUtil.isUnixAbsolutePath((String)storageRef)) {
            String string = storageRef;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getStorageRootFromOptions"));
            }
            return string;
        }
        String string = moduleRoot + '/' + storageRef;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "getStorageRootFromOptions"));
        }
        return string;
    }

    public static void setStorageType(@NotNull ModuleRootModel model, @NotNull String storageId) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "setStorageType"));
        }
        if (storageId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageId", "com/intellij/openapi/roots/impl/storage/ClasspathStorage", "setStorageType"));
        }
        Module module2 = model.getModule();
        String oldStorageType = ClassPathStorageUtil.getStorageType(module2);
        if (oldStorageType.equals(storageId)) {
            return;
        }
        ClasspathStorageProvider provider = ClasspathStorage.getProvider(oldStorageType);
        if (provider != null) {
            provider.detach(module2);
        }
        if ((provider = ClasspathStorage.getProvider(storageId)) == null) {
            module2.clearOption("classpath");
            module2.clearOption("classpath-dir");
        } else {
            module2.setOption("classpath", storageId);
            module2.setOption("classpath-dir", provider.getContentRoot(model));
        }
    }

    public static void modulePathChanged(Module module2, String newPath) {
        ClasspathStorageProvider provider = ClasspathStorage.getProvider(ClassPathStorageUtil.getStorageType(module2));
        if (provider != null) {
            provider.modulePathChanged(module2, newPath);
        }
    }
}

