/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.vcs.actions.ActiveAnnotationGutter;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import java.awt.Color;
import java.awt.Cursor;
import java.util.List;

public class AnnotationGutterLineConvertorProxy
implements ActiveAnnotationGutter {
    private final UpToDateLineNumberProvider myGetUpToDateLineNumber;
    private final ActiveAnnotationGutter myDelegate;

    public AnnotationGutterLineConvertorProxy(UpToDateLineNumberProvider getUpToDateLineNumber, ActiveAnnotationGutter delegate) {
        this.myGetUpToDateLineNumber = getUpToDateLineNumber;
        this.myDelegate = delegate;
    }

    public String getLineText(int line, Editor editor) {
        int currentLine = this.myGetUpToDateLineNumber.getLineNumber(line);
        if (!AnnotationGutterLineConvertorProxy.canBeAnnotated(currentLine)) {
            return "";
        }
        return this.myDelegate.getLineText(currentLine, editor);
    }

    public String getToolTip(int line, Editor editor) {
        int currentLine = this.myGetUpToDateLineNumber.getLineNumber(line);
        if (!AnnotationGutterLineConvertorProxy.canBeAnnotated(currentLine)) {
            return "";
        }
        return this.myDelegate.getToolTip(currentLine, editor);
    }

    public EditorFontType getStyle(int line, Editor editor) {
        int currentLine = this.myGetUpToDateLineNumber.getLineNumber(line);
        if (!AnnotationGutterLineConvertorProxy.canBeAnnotated(currentLine)) {
            return EditorFontType.PLAIN;
        }
        return this.myDelegate.getStyle(currentLine, editor);
    }

    public ColorKey getColor(int line, Editor editor) {
        int currentLine = this.myGetUpToDateLineNumber.getLineNumber(line);
        if (!AnnotationGutterLineConvertorProxy.canBeAnnotated(currentLine)) {
            return AnnotationSource.LOCAL.getColor();
        }
        return this.myDelegate.getColor(currentLine, editor);
    }

    public Color getBgColor(int line, Editor editor) {
        int currentLine = this.myGetUpToDateLineNumber.getLineNumber(line);
        if (!AnnotationGutterLineConvertorProxy.canBeAnnotated(currentLine)) {
            return null;
        }
        return this.myDelegate.getBgColor(currentLine, editor);
    }

    public List<AnAction> getPopupActions(int line, Editor editor) {
        return this.myDelegate.getPopupActions(line, editor);
    }

    public void gutterClosed() {
        this.myDelegate.gutterClosed();
    }

    public void doAction(int lineNum) {
        int currentLine = this.myGetUpToDateLineNumber.getLineNumber(lineNum);
        if (!AnnotationGutterLineConvertorProxy.canBeAnnotated(currentLine)) {
            return;
        }
        this.myDelegate.doAction(currentLine);
    }

    public Cursor getCursor(int lineNum) {
        int currentLine = this.myGetUpToDateLineNumber.getLineNumber(lineNum);
        if (!AnnotationGutterLineConvertorProxy.canBeAnnotated(currentLine)) {
            return Cursor.getDefaultCursor();
        }
        return this.myDelegate.getCursor(currentLine);
    }

    private static boolean canBeAnnotated(int currentLine) {
        return currentLine >= 0;
    }
}

