/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Generator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.ui.ArtifactElementPresentation;
import com.intellij.packaging.impl.ui.DelegatedPackagingElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactPackagingElement
extends ComplexPackagingElement<ArtifactPackagingElementState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packaging.impl.elements.ArtifactPackagingElement");
    private final Project myProject;
    private ArtifactPointer myArtifactPointer;
    @NonNls
    public static final String ARTIFACT_NAME_ATTRIBUTE = "artifact-name";

    public ArtifactPackagingElement(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/elements/ArtifactPackagingElement", "<init>"));
        }
        super((PackagingElementType)ArtifactElementType.ARTIFACT_ELEMENT_TYPE);
        this.myProject = project2;
    }

    public ArtifactPackagingElement(@NotNull Project project2, @NotNull ArtifactPointer artifactPointer) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/elements/ArtifactPackagingElement", "<init>"));
        }
        if (artifactPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactPointer", "com/intellij/packaging/impl/elements/ArtifactPackagingElement", "<init>"));
        }
        this(project2);
        this.myArtifactPointer = artifactPointer;
    }

    public List<? extends PackagingElement<?>> getSubstitution(@NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/ArtifactPackagingElement", "getSubstitution"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "com/intellij/packaging/impl/elements/ArtifactPackagingElement", "getSubstitution"));
        }
        Artifact artifact = this.findArtifact(context);
        if (artifact != null) {
            ArtifactType type = artifact.getArtifactType();
            List substitution = type.getSubstitution(artifact, context, artifactType);
            if (substitution != null) {
                return substitution;
            }
            ArrayList<CompositePackagingElement> elements = new ArrayList<CompositePackagingElement>();
            CompositePackagingElement rootElement = artifact.getRootElement();
            if (rootElement instanceof ArtifactRootElement) {
                elements.addAll(rootElement.getChildren());
            } else {
                elements.add(rootElement);
            }
            return elements;
        }
        return null;
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        if (resolvingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvingContext", "com/intellij/packaging/impl/elements/ArtifactPackagingElement", "computeAntInstructions"));
        }
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/intellij/packaging/impl/elements/ArtifactPackagingElement", "computeAntInstructions"));
        }
        if (generationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generationContext", "com/intellij/packaging/impl/elements/ArtifactPackagingElement", "computeAntInstructions"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "com/intellij/packaging/impl/elements/ArtifactPackagingElement", "computeAntInstructions"));
        }
        Artifact artifact = this.findArtifact(resolvingContext);
        if (artifact != null) {
            if (artifact.getArtifactType().getSubstitution(artifact, resolvingContext, artifactType) != null) {
                return super.computeAntInstructions(resolvingContext, creator, generationContext, artifactType);
            }
            String outputPath = BuildProperties.propertyRef((String)generationContext.getArtifactOutputProperty(artifact));
            return Collections.singletonList(creator.createDirectoryContentCopyInstruction(outputPath));
        }
        return Collections.emptyList();
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/ArtifactPackagingElement", "createPresentation"));
        }
        return new DelegatedPackagingElementPresentation(new ArtifactElementPresentation(this.myArtifactPointer, context));
    }

    public ArtifactPackagingElementState getState() {
        ArtifactPackagingElementState state = new ArtifactPackagingElementState();
        if (this.myArtifactPointer != null) {
            state.setArtifactName(this.myArtifactPointer.getArtifactName());
        }
        return state;
    }

    public void loadState(ArtifactPackagingElementState state) {
        String name = state.getArtifactName();
        this.myArtifactPointer = name != null ? ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(name) : null;
    }

    public String toString() {
        return "artifact:" + this.getArtifactName();
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/elements/ArtifactPackagingElement", "isEqualTo"));
        }
        return element instanceof ArtifactPackagingElement && this.myArtifactPointer != null && this.myArtifactPointer.equals(((ArtifactPackagingElement)element).myArtifactPointer);
    }

    @Nullable
    public Artifact findArtifact(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/ArtifactPackagingElement", "findArtifact"));
        }
        return this.myArtifactPointer != null ? this.myArtifactPointer.findArtifact(context.getArtifactModel()) : null;
    }

    @Nullable
    public String getArtifactName() {
        return this.myArtifactPointer != null ? this.myArtifactPointer.getArtifactName() : null;
    }

    public static class ArtifactPackagingElementState {
        private String myArtifactName;

        @Attribute(value="artifact-name")
        public String getArtifactName() {
            return this.myArtifactName;
        }

        public void setArtifactName(String artifactName) {
            this.myArtifactName = artifactName;
        }
    }
}

