/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileTypeIndex
extends ScalarIndexExtension<FileType>
implements FileBasedIndex.InputFilter,
KeyDescriptor<FileType>,
DataIndexer<FileType, Void, FileContent> {
    private static final EnumeratorStringDescriptor ENUMERATOR_STRING_DESCRIPTOR = new EnumeratorStringDescriptor();
    public static final ID<FileType, Void> NAME = ID.create((String)"filetypes");
    private final FileTypeRegistry myFileTypeManager;

    @NotNull
    public static Collection<VirtualFile> getFiles(@NotNull FileType fileType, @NotNull GlobalSearchScope scope) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/search/FileTypeIndex", "getFiles"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FileTypeIndex", "getFiles"));
        }
        Collection collection = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)fileType, scope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FileTypeIndex", "getFiles"));
        }
        return collection;
    }

    public FileTypeIndex(FileTypeRegistry fileTypeRegistry) {
        this.myFileTypeManager = fileTypeRegistry;
    }

    @NotNull
    public ID<FileType, Void> getName() {
        ID<FileType, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FileTypeIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<FileType, Void, FileContent> getIndexer() {
        FileTypeIndex fileTypeIndex = this;
        if (fileTypeIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FileTypeIndex", "getIndexer"));
        }
        return fileTypeIndex;
    }

    @NotNull
    public KeyDescriptor<FileType> getKeyDescriptor() {
        FileTypeIndex fileTypeIndex = this;
        if (fileTypeIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FileTypeIndex", "getKeyDescriptor"));
        }
        return fileTypeIndex;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileTypeIndex fileTypeIndex = this;
        if (fileTypeIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FileTypeIndex", "getInputFilter"));
        }
        return fileTypeIndex;
    }

    public boolean dependsOnFileContent() {
        return false;
    }

    public int getVersion() {
        FileType[] types = this.myFileTypeManager.getRegisteredFileTypes();
        int version = 2;
        for (FileType fileType : types) {
            version += fileType.getName().hashCode();
        }
        version *= 31;
        for (FileType fileType : (FileTypeRegistry.FileTypeDetector[])Extensions.getExtensions((ExtensionPointName)FileTypeRegistry.FileTypeDetector.EP_NAME)) {
            version += fileType.getVersion();
        }
        return version;
    }

    public boolean acceptInput(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/FileTypeIndex", "acceptInput"));
        }
        return !file2.isDirectory();
    }

    public void save(@NotNull DataOutput out, FileType value) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/search/FileTypeIndex", "save"));
        }
        ENUMERATOR_STRING_DESCRIPTOR.save(out, value.getName());
    }

    public FileType read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/search/FileTypeIndex", "read"));
        }
        String read = ENUMERATOR_STRING_DESCRIPTOR.read(in);
        return this.myFileTypeManager.findFileTypeByName(read);
    }

    public int getHashCode(FileType value) {
        return value.getName().hashCode();
    }

    public boolean isEqual(FileType val1, FileType val2) {
        return Comparing.equal((Object)val1, (Object)val2);
    }

    @NotNull
    public Map<FileType, Void> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/search/FileTypeIndex", "map"));
        }
        Map<FileType, Object> map = Collections.singletonMap(inputData.getFileType(), null);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FileTypeIndex", "map"));
        }
        return map;
    }

    public static boolean containsFileOfType(@NotNull FileType type, @NotNull GlobalSearchScope scope) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/search/FileTypeIndex", "containsFileOfType"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FileTypeIndex", "containsFileOfType"));
        }
        return !FileBasedIndex.getInstance().processValues(NAME, (Object)type, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Void>(){

            public boolean process(VirtualFile file2, Void value) {
                return false;
            }
        }, scope);
    }
}

