/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.MethodCallUsageInfo;
import com.intellij.usageView.UsageInfo;
import org.jetbrains.annotations.Nullable;

class MethodReferenceUsageInfo
extends UsageInfo {
    private final boolean myIsToModifyArgs;
    private final boolean myIsToCatchExceptions;
    private PsiCallExpression myCallExpression;

    public MethodReferenceUsageInfo(PsiElement element, PsiMethod method, boolean isToModifyArgs, boolean isToCatchExceptions) {
        super(element);
        this.myIsToModifyArgs = isToModifyArgs;
        this.myIsToCatchExceptions = isToCatchExceptions;
    }

    public void setCallExpression(PsiCallExpression callExpression) {
        this.myCallExpression = callExpression;
    }

    @Nullable
    public MethodCallUsageInfo createMethodCallInfo() {
        if (this.myCallExpression == null) {
            return null;
        }
        return new MethodCallUsageInfo((PsiElement)this.myCallExpression, this.myIsToModifyArgs, this.myIsToCatchExceptions);
    }

    public static boolean needToExpand(JavaChangeInfo changeInfo) {
        return !changeInfo.isGenerateDelegate() && (changeInfo.isParameterSetOrOrderChanged() || changeInfo.isExceptionSetOrOrderChanged());
    }

    @Nullable
    public PsiElement getElement() {
        if (this.myCallExpression != null) {
            return this.myCallExpression;
        }
        return super.getElement();
    }
}

