/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.invertBoolean;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.invertBoolean.InvertBooleanDelegate;
import com.intellij.refactoring.invertBoolean.InvertBooleanHandler;
import com.intellij.refactoring.invertBoolean.InvertBooleanUsageViewDescriptor;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvertBooleanProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.invertBoolean.InvertBooleanMethodProcessor");
    private final InvertBooleanDelegate myDelegate;
    private PsiElement myElement;
    private final String myNewName;
    private final RenameProcessor myRenameProcessor;
    private final Map<UsageInfo, SmartPsiElementPointer> myToInvert = new HashMap();
    private final SmartPointerManager mySmartPointerManager;

    public InvertBooleanProcessor(PsiElement namedElement, String newName) {
        super(namedElement.getProject());
        this.myElement = namedElement;
        this.myNewName = newName;
        Project project2 = namedElement.getProject();
        boolean canRename = namedElement instanceof PsiNamedElement && !Comparing.equal((String)((PsiNamedElement)namedElement).getName(), (String)this.myNewName);
        this.myRenameProcessor = canRename ? new RenameProcessor(project2, namedElement, newName, false, false){

            @Override
            @NotNull
            protected ConflictsDialog createConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, final @Nullable UsageInfo[] usages) {
                if (conflicts == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor$1", "createConflictsDialog"));
                }
                ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, conflicts, usages == null ? null : new Runnable(){

                    @Override
                    public void run() {
                        InvertBooleanProcessor.this.execute(usages);
                    }
                }, false, true);
                if (conflictsDialog == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor$1", "createConflictsDialog"));
                }
                return conflictsDialog;
            }

            @Override
            protected void prepareSuccessful() {
                InvertBooleanProcessor.this.prepareSuccessful();
            }
        } : null;
        this.mySmartPointerManager = SmartPointerManager.getInstance((Project)project2);
        this.myDelegate = InvertBooleanDelegate.findInvertBooleanDelegate(this.myElement);
        LOG.assertTrue(this.myDelegate != null);
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor", "createUsageViewDescriptor"));
        }
        InvertBooleanUsageViewDescriptor invertBooleanUsageViewDescriptor = new InvertBooleanUsageViewDescriptor(this.myElement);
        if (invertBooleanUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor", "createUsageViewDescriptor"));
        }
        return invertBooleanUsageViewDescriptor;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor", "preprocessUsages"));
        }
        MultiMap conflicts = new MultiMap();
        UsageInfo[] usageInfos = (UsageInfo[])refUsages.get();
        this.myDelegate.findConflicts(usageInfos, (MultiMap<PsiElement, String>)conflicts);
        if (!conflicts.isEmpty()) {
            return this.showConflicts((MultiMap<PsiElement, String>)conflicts, usageInfos);
        }
        if (this.myRenameProcessor == null || this.myRenameProcessor.preprocessUsages(refUsages)) {
            this.prepareSuccessful();
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<SmartPsiElementPointer> toInvert = new ArrayList<SmartPsiElementPointer>();
        LinkedHashSet<PsiElement> elementsToInvert = new LinkedHashSet<PsiElement>();
        this.myDelegate.collectRefElements(this.myElement, this.myRenameProcessor, this.myNewName, elementsToInvert);
        for (PsiElement element : elementsToInvert) {
            toInvert.add(this.mySmartPointerManager.createSmartPsiElementPointer(element));
        }
        UsageInfo[] renameUsages = this.myRenameProcessor != null ? this.myRenameProcessor.findUsages() : UsageInfo.EMPTY_ARRAY;
        SmartPsiElementPointer[] usagesToInvert = toInvert.toArray(new SmartPsiElementPointer[toInvert.size()]);
        HashMap expressionsToUsages = new HashMap();
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (UsageInfo usageInfo : renameUsages) {
            expressionsToUsages.put(usageInfo.getElement(), usageInfo);
            result.add(usageInfo);
        }
        for (UsageInfo usageInfo : usagesToInvert) {
            PsiElement expression = usageInfo.getElement();
            if (!expressionsToUsages.containsKey(expression)) {
                UsageInfo usageInfo2 = new UsageInfo(expression);
                expressionsToUsages.put(expression, usageInfo2);
                result.add(usageInfo2);
                this.myToInvert.put(usageInfo2, (SmartPsiElementPointer)usageInfo);
                continue;
            }
            this.myToInvert.put((UsageInfo)expressionsToUsages.get(expression), (SmartPsiElementPointer)usageInfo);
        }
        UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor", "refreshElements"));
        }
        this.myElement = elements[0];
    }

    private static UsageInfo[] extractUsagesForElement(PsiElement element, UsageInfo[] usages) {
        ArrayList<MoveRenameUsageInfo> extractedUsages = new ArrayList<MoveRenameUsageInfo>(usages.length);
        for (UsageInfo usage : usages) {
            MoveRenameUsageInfo usageInfo;
            if (!(usage instanceof MoveRenameUsageInfo) || !element.equals((usageInfo = (MoveRenameUsageInfo)usage).getReferencedElement())) continue;
            extractedUsages.add(usageInfo);
        }
        return extractedUsages.toArray(new UsageInfo[extractedUsages.size()]);
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor", "performRefactoring"));
        }
        if (this.myRenameProcessor != null) {
            for (PsiElement element : this.myRenameProcessor.getElements()) {
                try {
                    RenameUtil.doRename(element, this.myRenameProcessor.getNewName(element), InvertBooleanProcessor.extractUsagesForElement(element, usages), this.myProject, null);
                }
                catch (IncorrectOperationException e) {
                    RenameUtil.showErrorMessage(e, element, this.myProject);
                    return;
                }
            }
        }
        for (UsageInfo usage : usages) {
            SmartPsiElementPointer pointerToInvert = this.myToInvert.get(usage);
            if (pointerToInvert == null) continue;
            PsiElement element = pointerToInvert.getElement();
            LOG.assertTrue(element != null);
            InvertBooleanDelegate delegate = InvertBooleanDelegate.findInvertBooleanDelegate(element);
            try {
                (delegate != null ? delegate : this.myDelegate).replaceWithNegatedExpression(element);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myDelegate.invertElementInitializer(this.myElement);
    }

    @Override
    protected String getCommandName() {
        return InvertBooleanHandler.REFACTORING_NAME;
    }
}

