/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliceHandler
implements CodeInsightActionHandler {
    private final boolean myDataFlowToThis;

    public SliceHandler(boolean dataFlowToThis) {
        this.myDataFlowToThis = dataFlowToThis;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/slicer/SliceHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/slicer/SliceHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/slicer/SliceHandler", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiElement expression = this.getExpressionAtCaret(editor, file2);
        if (expression == null) {
            HintManager.getInstance().showErrorHint(editor, "Cannot find what to analyze. Please stand on the expression or variable or method parameter and try again.");
            return;
        }
        SliceManager sliceManager = SliceManager.getInstance(project2);
        sliceManager.slice(expression, this.myDataFlowToThis, this);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getExpressionAtCaret(Editor editor, PsiFile file2) {
        int offset = TargetElementUtil.adjustOffset(file2, editor.getDocument(), editor.getCaretModel().getOffset());
        if (offset == 0) {
            return null;
        }
        PsiElement atCaret = file2.findElementAt(offset);
        SliceLanguageSupportProvider provider = LanguageSlicing.getProvider((PsiElement)file2);
        if (provider == null) {
            return null;
        }
        return provider.getExpressionAtCaret(atCaret, this.myDataFlowToThis);
    }

    public SliceAnalysisParams askForParams(PsiElement element, boolean dataFlowToThis, SliceManager.StoredSettingsBean storedSettingsBean, String dialogTitle) {
        AnalysisScope analysisScope = new AnalysisScope(element.getContainingFile());
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        String name = module2 == null ? null : module2.getName();
        Project myProject = element.getProject();
        AnalysisUIOptions analysisUIOptions = new AnalysisUIOptions();
        analysisUIOptions.save(storedSettingsBean.analysisUIOptions);
        BaseAnalysisActionDialog dialog = new BaseAnalysisActionDialog(dialogTitle, "Analyze scope", myProject, analysisScope, name, true, analysisUIOptions, element);
        if (!dialog.showAndGet()) {
            return null;
        }
        AnalysisScope scope = dialog.getScope(analysisUIOptions, analysisScope, myProject, module2);
        storedSettingsBean.analysisUIOptions.save(analysisUIOptions);
        SliceAnalysisParams params = new SliceAnalysisParams();
        params.scope = scope;
        params.dataFlowToThis = dataFlowToThis;
        return params;
    }
}

