/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.MultiMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigFileSearcher {
    private final MultiMap<Module, PsiFile> myFiles;
    private final MultiMap<VirtualFile, PsiFile> myJars;
    private final MultiMap<VirtualFile, PsiFile> myVirtualFiles;
    @Nullable
    private final Module myModule;
    @NotNull
    private final Project myProject;

    public ConfigFileSearcher(@Nullable Module module2, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/config/ConfigFileSearcher", "<init>"));
        }
        this.myFiles = new MultiMap();
        this.myJars = new MultiMap();
        this.myVirtualFiles = new MultiMap();
        this.myModule = module2;
        this.myProject = project2;
    }

    public void search() {
        this.myFiles.clear();
        this.myJars.clear();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (PsiFile file2 : this.search(this.myModule, this.myProject)) {
            VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(file2.getVirtualFile());
            if (jar != null) {
                this.myJars.putValue((Object)jar, (Object)file2);
                continue;
            }
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
            if (module2 != null) {
                this.myFiles.putValue((Object)module2, (Object)file2);
                continue;
            }
            VirtualFile virtualFile = file2.getVirtualFile();
            this.myVirtualFiles.putValue((Object)virtualFile.getParent(), (Object)psiManager.findFile(virtualFile));
        }
    }

    public abstract Set<PsiFile> search(@Nullable Module var1, @NotNull Project var2);

    public MultiMap<Module, PsiFile> getFilesByModules() {
        return this.myFiles;
    }

    public MultiMap<VirtualFile, PsiFile> getJars() {
        return this.myJars;
    }

    public MultiMap<VirtualFile, PsiFile> getVirtualFiles() {
        return this.myVirtualFiles;
    }
}

