/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import com.jetbrains.jsonSchema.JsonSchemaMappingsConfigurationBase;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        if (element == null) {
            return null;
        }
        VirtualFile fileAtElement = PsiUtilBase.asVirtualFile((PsiElement)element);
        if (fileAtElement == null || !(fileAtElement.getFileType() instanceof LanguageFileType) || !((LanguageFileType)fileAtElement.getFileType()).getLanguage().isKindOf((Language)JsonLanguage.INSTANCE)) {
            return null;
        }
        final Project project2 = element.getProject();
        final JsonSchemaMappingsProjectConfiguration configuration = JsonSchemaMappingsProjectConfiguration.getInstance(project2);
        final JsonSchemaMappingsConfigurationBase.SchemaInfo schemaInfo = configuration.getSchemaBySchemaFile(fileAtElement);
        if (schemaInfo != null && project2.getBaseDir() != null) {
            return new UndoRefactoringElementAdapter(){

                protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
                    String relativePath;
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/JsonSchemaRefactoringListenerProvider$1", "refactored"));
                    }
                    VirtualFile newFile = PsiUtilBase.asVirtualFile((PsiElement)element);
                    if (newFile != null && (relativePath = VfsUtil.getRelativePath((VirtualFile)newFile, (VirtualFile)project2.getBaseDir())) != null) {
                        configuration.removeSchema(schemaInfo);
                        JsonSchemaMappingsConfigurationBase.SchemaInfo newSchema = new JsonSchemaMappingsConfigurationBase.SchemaInfo(schemaInfo.getName(), relativePath, schemaInfo.isApplicationLevel(), schemaInfo.getPatterns());
                        configuration.addSchema(newSchema);
                    }
                }
            };
        }
        return null;
    }
}

