/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor;

import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.extractor.differ.Differ;
import com.intellij.psi.codeStyle.extractor.values.Generation;
import com.intellij.psi.codeStyle.extractor.values.Gens;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResult;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static int CRITICAL_SYMBOL_WEIGHT = 100;
    static long rseed = 0L;
    static final long RAND_MAX_32 = Integer.MAX_VALUE;
    static final long RAND_MAX = 32767L;

    public static void logError(String message) {
        System.out.println(message);
    }

    public static int getTabSize(@Nullable CommonCodeStyleSettings.IndentOptions options) {
        return options == null ? 4 : options.TAB_SIZE;
    }

    public static int getNormalizedLength(@Nullable CommonCodeStyleSettings.IndentOptions options, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/codeStyle/extractor/Utils", "getNormalizedLength"));
        }
        return text.replaceAll("\t", StringUtil.repeatSymbol((char)' ', (int)Utils.getTabSize(options))).replaceAll("\n", StringUtil.repeatSymbol((char)' ', (int)CRITICAL_SYMBOL_WEIGHT)).length();
    }

    public static boolean isSpace(char c) {
        return " \t\n".indexOf(c) >= 0;
    }

    public static boolean isBracket(char c) {
        return "(){}[]<>".indexOf(c) >= 0;
    }

    public static int getDiff(@Nullable CommonCodeStyleSettings.IndentOptions options, @NotNull String oldV, @NotNull String newV) {
        if (oldV == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldV", "com/intellij/psi/codeStyle/extractor/Utils", "getDiff"));
        }
        if (newV == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newV", "com/intellij/psi/codeStyle/extractor/Utils", "getDiff"));
        }
        oldV = oldV.trim();
        newV = newV.trim();
        int diff = 0;
        int oPos = 0;
        int nPos = 0;
        int oEnd = oldV.length();
        int nEnd = newV.length();
        StringBuilder oSp = new StringBuilder();
        StringBuilder nSp = new StringBuilder();
        while (oPos < oEnd || nPos < nEnd) {
            char ch;
            oSp.setLength(0);
            nSp.setLength(0);
            while (oPos < oEnd && Utils.isSpace(ch = oldV.charAt(oPos))) {
                oSp.append(ch);
                ++oPos;
            }
            while (nPos < nEnd && Utils.isSpace(ch = newV.charAt(nPos))) {
                nSp.append(ch);
                ++nPos;
            }
            diff += Math.abs(Utils.getNormalizedLength(options, oSp.toString()) - Utils.getNormalizedLength(options, nSp.toString()));
            while (oPos < oEnd && nPos < nEnd && (ch = oldV.charAt(oPos)) == newV.charAt(nPos) && !Utils.isSpace(ch)) {
                ++oPos;
                ++nPos;
            }
            if (oPos >= oEnd || nPos >= nEnd || Utils.isSpace(oldV.charAt(oPos)) || Utils.isSpace(newV.charAt(nPos))) continue;
            Utils.logError("AST changed!");
            return 0x1FFFFFFF;
        }
        return diff;
    }

    @Nullable
    public static CustomCodeStyleSettings getLanguageSettings(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/codeStyle/extractor/Utils", "getLanguageSettings"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/codeStyle/extractor/Utils", "getLanguageSettings"));
        }
        for (CodeStyleSettingsProvider provider : (CodeStyleSettingsProvider[])CodeStyleSettingsProvider.EXTENSION_POINT_NAME.getExtensions()) {
            Object customSettings;
            CustomCodeStyleSettings modelSettings;
            if (!((Object)((Object)language)).equals((Object)provider.getLanguage()) || (modelSettings = provider.createCustomSettings(settings)) == null || (customSettings = settings.getCustomSettings(modelSettings.getClass())) == null) continue;
            return customSettings;
        }
        Utils.logError("Failed to load CustomCodeStyleSettings for " + (Object)((Object)language));
        return null;
    }

    public static void adjustValuesMin(@NotNull ValuesExtractionResult gens, @NotNull Differ differ, @Nullable ProgressIndicator indicator) {
        if (gens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gens", "com/intellij/psi/codeStyle/extractor/Utils", "adjustValuesMin"));
        }
        if (differ == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "differ", "com/intellij/psi/codeStyle/extractor/Utils", "adjustValuesMin"));
        }
        List<Value> values = gens.getValues();
        int length = values.size();
        int i = 0;
        for (Value value : values) {
            if (indicator != null) {
                indicator.checkCanceled();
                indicator.setText2("Value:" + value.name);
                indicator.setFraction(0.5 + 0.5 * (double)i / (double)length);
            }
            Object bestValue = value.value;
            int bestScope = differ.getDifference(gens);
            for (Object cnst : value.getPossibleValues()) {
                if (cnst.equals(value.value)) continue;
                value.value = cnst;
                int diff = differ.getDifference(gens);
                if (diff < bestScope) {
                    bestValue = cnst;
                    bestScope = diff;
                    value.state = Value.STATE.SELECTED;
                    continue;
                }
                if (diff <= bestScope) continue;
                value.state = Value.STATE.SELECTED;
            }
            value.value = bestValue;
            ++i;
        }
    }

    public static void adjustValuesGA(@NotNull Gens gens, @NotNull Differ differ, @Nullable ProgressIndicator indicator) {
        if (gens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gens", "com/intellij/psi/codeStyle/extractor/Utils", "adjustValuesGA"));
        }
        if (differ == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "differ", "com/intellij/psi/codeStyle/extractor/Utils", "adjustValuesGA"));
        }
        Generation generation = Generation.createZeroGeneration(gens);
        while (generation.tryAgain()) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            int age = generation.getAge();
            if (indicator != null) {
                indicator.setText2(" age:" + age + "/" + generation.getParentKind());
                indicator.setFraction(0.5 * (double)age / (double)Generation.GEN_COUNT);
            }
            generation = Generation.createNextGeneration(differ, generation);
        }
        gens.copyFrom(generation.getBestGens(differ));
    }

    public static void resetRandom() {
        rseed = 0L;
    }

    public static long getRandom() {
        rseed = rseed * 214013L + 2531011L & Integer.MAX_VALUE;
        return rseed >> 16;
    }

    public static int getRandomLess(int count) {
        int ret = (int)(Utils.getRandom() * (long)count / 32767L);
        if (ret >= count) {
            return count - 1;
        }
        if (ret < 0) {
            return 0;
        }
        return ret;
    }
}

