/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.ide.hierarchy.type.JavaTypeHierarchyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelper;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

public class KotlinTypeHierarchyProvider
extends JavaTypeHierarchyProvider {
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "org/jetbrains/kotlin/idea/hierarchy/KotlinTypeHierarchyProvider", "getTarget"));
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            int offset2;
            PsiElement element2;
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return null;
            }
            if (!ProjectRootsUtil.isInProjectOrLibSource((PsiElement)file)) {
                return null;
            }
            PsiElement target = TargetElementUtilBase.findTargetElement((Editor)editor, (int)TargetElementUtilBase.getInstance().getAllAccepted());
            if (target instanceof PsiClass) {
                return target;
            }
            if (target instanceof KtClassOrObject) {
                return SourceNavigationHelper.getOriginalPsiClassOrCreateLightClass((KtClassOrObject)target);
            }
            if (target instanceof KtNamedFunction) {
                Collection<KtClassOrObject> classOrObjects;
                String returnTypeText;
                KotlinType type2;
                KtNamedFunction function2 = (KtNamedFunction)target;
                String functionName = function2.getName();
                FunctionDescriptor functionDescriptor = ResolutionUtils.analyze(function2).get(BindingContext.FUNCTION, target);
                if (functionDescriptor != null && (type2 = functionDescriptor.getReturnType()) != null && (returnTypeText = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2)).equals(functionName) && (classOrObjects = KotlinClassShortNameIndex.getInstance().get(functionName, project, GlobalSearchScope.allScope((Project)project))).size() == 1) {
                    KtClassOrObject classOrObject = classOrObjects.iterator().next();
                    return SourceNavigationHelper.getOriginalPsiClassOrCreateLightClass(classOrObject);
                }
            }
            if ((element2 = file.findElementAt(offset2 = editor.getCaretModel().getOffset())) == null) {
                return null;
            }
            KtClassOrObject classOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)element2, KtClassOrObject.class);
            if (classOrObject != null) {
                return SourceNavigationHelper.getOriginalPsiClassOrCreateLightClass(classOrObject);
            }
        } else {
            PsiElement element3 = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element3 instanceof KtClassOrObject) {
                return SourceNavigationHelper.getOriginalPsiClassOrCreateLightClass((KtClassOrObject)element3);
            }
        }
        return null;
    }
}

