/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.execution.junit.JUnitProcessHandler;
import com.intellij.execution.junit2.segments.DeferredActionsQueue;
import com.intellij.execution.junit2.segments.DeferredActionsQueueImpl;
import com.intellij.execution.junit2.segments.InputConsumer;
import com.intellij.execution.junit2.segments.OutputPacketProcessor;
import com.intellij.execution.junit2.segments.SegmentReader;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.lang.ant.config.execution.InputRequestHandler;
import com.intellij.lang.ant.config.execution.OutputParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import java.io.IOException;

final class OutputParser2
extends OutputParser
implements PacketProcessor,
InputConsumer,
OutputPacketProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ant.execution.OutputParser2");
    private int myLastPacketIndex = -1;

    private OutputParser2(Project project, OSProcessHandler processHandler, AntBuildMessageView errorsView, ProgressIndicator progress, String buildName) {
        super(project, processHandler, errorsView, progress, buildName);
    }

    public void processOutput(Printable printable) {
        printable.printOn(null);
    }

    public void processPacket(String packet) {
        SegmentReader reader = new SegmentReader(packet);
        int index = reader.readInt();
        if (this.myLastPacketIndex + 1 < index) {
            LOG.error("last: " + this.myLastPacketIndex + " current: " + index);
        }
        if (this.myLastPacketIndex + 1 > index) {
            return;
        }
        ++this.myLastPacketIndex;
        char id = reader.readChar();
        if (id == 'I') {
            try {
                InputRequestHandler.processInput(this.getProject(), reader, this.getProcessHandler());
            }
            catch (IOException e) {
                MessagesEx.error((Project)this.getProject(), (String)e.getMessage()).showLater();
            }
        } else {
            int priority = reader.readInt();
            char contentType = reader.readChar();
            String message = reader.readLimitedString();
            switch (id) {
                case 'b': {
                    if (contentType != 'X') break;
                    this.processTag('X', message, priority);
                    break;
                }
                default: {
                    this.processTag(id, message, priority);
                }
            }
        }
    }

    public void onOutput(String text, ConsoleViewContentType contentType) {
        if (text.length() == 0) {
            return;
        }
        if (this.myLastPacketIndex != -1) {
            return;
        }
        if (contentType == ConsoleViewContentType.ERROR_OUTPUT) {
            this.readErrorOutput(text);
        }
    }

    public static OutputParser attachParser(Project myProject, JUnitProcessHandler handler, AntBuildMessageView errorView, ProgressIndicator progress, AntBuildFile buildFile) {
        OutputParser2 parser = new OutputParser2(myProject, (OSProcessHandler)handler, errorView, progress, buildFile.getName());
        DeferredActionsQueueImpl queue = new DeferredActionsQueueImpl();
        handler.getErr().setPacketDispatcher((PacketProcessor)parser, (DeferredActionsQueue)queue);
        return parser;
    }
}

