/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.optimization.fixStack.SavedStackDescriptor;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001c\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u001c\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0017J\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\tJ\b\u0010\u001f\u001a\u00020\u000eH\u0002J\u000e\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\tJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\tJ\u0010\u0010$\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u000e\u0010%\u001a\u00020#2\u0006\u0010!\u001a\u00020\tJ\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u000eH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/LocalVariablesManager;", "", "context", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "allocatedHandles", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/LocalVariablesManager$AllocatedHandle;", "getContext", "()Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "initialMaxLocals", "", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "allocateNewHandle", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "numRestoreStackMarkers", "saveStackMarker", "savedStackValues", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "allocateVariablesForBeforeInlineMarker", "beforeInlineMarker", "allocateVariablesForSaveStackMarker", "createReturnValueVariable", "returnValue", "getBeforeInlineDescriptor", "afterInlineMarker", "getFirstUnusedLocalVariableIndex", "getSavedStackDescriptor", "restoreStackMarker", "markAfterInlineMarkerEmitted", "", "markEmitted", "markRestoreStackMarkerEmitted", "updateMaxLocals", "newValue", "AllocatedHandle", "kotlin-compiler"})
public final class LocalVariablesManager {
    private final int initialMaxLocals;
    private final HashMap<AbstractInsnNode, AllocatedHandle> allocatedHandles;
    @NotNull
    private final FixStackContext context;
    @NotNull
    private final MethodNode methodNode;

    private final void updateMaxLocals(int newValue) {
        this.methodNode.maxLocals = Math.max(this.methodNode.maxLocals, newValue);
    }

    @NotNull
    public final SavedStackDescriptor allocateVariablesForSaveStackMarker(@NotNull AbstractInsnNode saveStackMarker, @NotNull List<? extends BasicValue> savedStackValues) {
        Intrinsics.checkParameterIsNotNull(saveStackMarker, "saveStackMarker");
        Intrinsics.checkParameterIsNotNull(savedStackValues, "savedStackValues");
        List<AbstractInsnNode> list2 = this.context.getRestoreStackMarkersForSaveMarker().get(saveStackMarker);
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        int numRestoreStackMarkers = list2.size();
        return this.allocateNewHandle(numRestoreStackMarkers, saveStackMarker, savedStackValues);
    }

    /*
     * WARNING - void declaration
     */
    private final SavedStackDescriptor allocateNewHandle(int numRestoreStackMarkers, AbstractInsnNode saveStackMarker, List<? extends BasicValue> savedStackValues) {
        void value$iv;
        void $receiver$iv;
        int firstUnusedLocalVarIndex = this.getFirstUnusedLocalVariableIndex();
        SavedStackDescriptor savedStackDescriptor = new SavedStackDescriptor(savedStackValues, firstUnusedLocalVarIndex);
        this.updateMaxLocals(savedStackDescriptor.getFirstUnusedLocalVarIndex());
        AllocatedHandle allocatedHandle = new AllocatedHandle(savedStackDescriptor, numRestoreStackMarkers);
        Map map2 = this.allocatedHandles;
        AllocatedHandle allocatedHandle2 = allocatedHandle;
        $receiver$iv.put(saveStackMarker, value$iv);
        return savedStackDescriptor;
    }

    @NotNull
    public final SavedStackDescriptor getSavedStackDescriptor(@NotNull AbstractInsnNode restoreStackMarker) {
        Intrinsics.checkParameterIsNotNull(restoreStackMarker, "restoreStackMarker");
        AbstractInsnNode saveStackMarker = this.context.getSaveStackMarkerForRestoreMarker().get(restoreStackMarker);
        Map $receiver$iv = this.allocatedHandles;
        Map map2 = $receiver$iv;
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        Object v = map2.get(saveStackMarker);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return ((AllocatedHandle)v).getSavedStackDescriptor();
    }

    /*
     * WARNING - void declaration
     */
    private final int getFirstUnusedLocalVariableIndex() {
        void var3_3;
        void $receiver$iv;
        Iterable iterable = this.allocatedHandles.values();
        int initial$iv = this.initialMaxLocals;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv) {
            void handle;
            AllocatedHandle allocatedHandle = (AllocatedHandle)element$iv;
            int index2 = accumulator$iv;
            accumulator$iv = Math.max(index2, handle.getSavedStackDescriptor().getFirstUnusedLocalVarIndex());
        }
        return (int)var3_3;
    }

    public final void markRestoreStackMarkerEmitted(@NotNull AbstractInsnNode restoreStackMarker) {
        AbstractInsnNode saveStackMarker;
        Intrinsics.checkParameterIsNotNull(restoreStackMarker, "restoreStackMarker");
        AbstractInsnNode abstractInsnNode = saveStackMarker = this.context.getSaveStackMarkerForRestoreMarker().get(restoreStackMarker);
        if (abstractInsnNode == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "saveStackMarker!!");
        this.markEmitted(abstractInsnNode);
    }

    @NotNull
    public final SavedStackDescriptor allocateVariablesForBeforeInlineMarker(@NotNull AbstractInsnNode beforeInlineMarker, @NotNull List<? extends BasicValue> savedStackValues) {
        Intrinsics.checkParameterIsNotNull(beforeInlineMarker, "beforeInlineMarker");
        Intrinsics.checkParameterIsNotNull(savedStackValues, "savedStackValues");
        return this.allocateNewHandle(1, beforeInlineMarker, savedStackValues);
    }

    @NotNull
    public final SavedStackDescriptor getBeforeInlineDescriptor(@NotNull AbstractInsnNode afterInlineMarker) {
        Intrinsics.checkParameterIsNotNull(afterInlineMarker, "afterInlineMarker");
        AbstractInsnNode beforeInlineMarker = this.context.getOpeningInlineMethodMarker().get(afterInlineMarker);
        Map $receiver$iv = this.allocatedHandles;
        Map map2 = $receiver$iv;
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        Object v = map2.get(beforeInlineMarker);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return ((AllocatedHandle)v).getSavedStackDescriptor();
    }

    public final void markAfterInlineMarkerEmitted(@NotNull AbstractInsnNode afterInlineMarker) {
        AbstractInsnNode beforeInlineMarker;
        Intrinsics.checkParameterIsNotNull(afterInlineMarker, "afterInlineMarker");
        AbstractInsnNode abstractInsnNode = beforeInlineMarker = this.context.getOpeningInlineMethodMarker().get(afterInlineMarker);
        if (abstractInsnNode == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "beforeInlineMarker!!");
        this.markEmitted(abstractInsnNode);
    }

    private final void markEmitted(AbstractInsnNode saveStackMarker) {
        AllocatedHandle allocatedHandle = this.allocatedHandles.get(saveStackMarker);
        if (allocatedHandle == null) {
            Intrinsics.throwNpe();
        }
        AllocatedHandle allocatedHandle2 = allocatedHandle;
        allocatedHandle2.markRestoreNodeEmitted();
        if (allocatedHandle2.isFullyEmitted()) {
            this.allocatedHandles.remove(saveStackMarker);
        }
    }

    public final int createReturnValueVariable(@NotNull BasicValue returnValue) {
        Intrinsics.checkParameterIsNotNull(returnValue, "returnValue");
        int returnValueIndex = this.getFirstUnusedLocalVariableIndex();
        this.updateMaxLocals(returnValueIndex + returnValue.getSize());
        return returnValueIndex;
    }

    @NotNull
    public final FixStackContext getContext() {
        return this.context;
    }

    @NotNull
    public final MethodNode getMethodNode() {
        return this.methodNode;
    }

    public LocalVariablesManager(@NotNull FixStackContext context, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        this.context = context;
        this.methodNode = methodNode;
        this.initialMaxLocals = this.methodNode.maxLocals;
        this.allocatedHandles = MapsKt.hashMapOf(new Pair[0]);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/LocalVariablesManager$AllocatedHandle;", "", "savedStackDescriptor", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "numRestoreMarkers", "", "(Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;I)V", "getNumRestoreMarkers", "()I", "setNumRestoreMarkers", "(I)V", "getSavedStackDescriptor", "()Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "isFullyEmitted", "", "markRestoreNodeEmitted", "", "kotlin-compiler"})
    private static final class AllocatedHandle {
        @NotNull
        private final SavedStackDescriptor savedStackDescriptor;
        private int numRestoreMarkers;

        public final boolean isFullyEmitted() {
            return this.numRestoreMarkers == 0;
        }

        public final void markRestoreNodeEmitted() {
            Unit unit;
            boolean value$iv = this.numRestoreMarkers > 0;
            if (_Assertions.ENABLED) {
                if (!value$iv) {
                    String message$iv = "Emitted more restore markers than expected for " + this.savedStackDescriptor;
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            int n = this.numRestoreMarkers;
            this.numRestoreMarkers = n + -1;
        }

        @NotNull
        public final SavedStackDescriptor getSavedStackDescriptor() {
            return this.savedStackDescriptor;
        }

        public final int getNumRestoreMarkers() {
            return this.numRestoreMarkers;
        }

        public final void setNumRestoreMarkers(int n) {
            this.numRestoreMarkers = n;
        }

        public AllocatedHandle(@NotNull SavedStackDescriptor savedStackDescriptor, int numRestoreMarkers) {
            Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
            this.savedStackDescriptor = savedStackDescriptor;
            this.numRestoreMarkers = numRestoreMarkers;
        }
    }
}

