/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiModifierList;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.AnnotationGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;

public class ModifierListGenerator {
    public static final String[] JAVA_MODIFIERS = new String[]{"public", "protected", "private", "static", "abstract", "final", "native", "synchronized", "strictfp", "transient", "volatile"};
    public static final String[] JAVA_MODIFIERS_WITHOUT_ABSTRACT = new String[]{"public", "protected", "private", "static", "final", "native", "synchronized", "strictfp", "transient", "volatile"};
    public static final String[] ENUM_CONSTRUCTOR_MODIFIERS = new String[]{"private", "packageLocal"};

    private ModifierListGenerator() {
    }

    public static boolean writeModifiers(StringBuilder text, PsiModifierList modifierList) {
        return ModifierListGenerator.writeModifiers(text, modifierList, JAVA_MODIFIERS, true);
    }

    public static boolean writeModifiers(StringBuilder text, PsiModifierList modifierList, String[] modifiers) {
        return ModifierListGenerator.writeModifiers(text, modifierList, modifiers, true);
    }

    public static boolean writeModifiers(StringBuilder builder, PsiModifierList modifierList, String[] modifiers, boolean writeAnnotations) {
        boolean wasAddedModifiers = false;
        if (writeAnnotations && modifierList instanceof GrModifierList) {
            GrAnnotation[] annotations = ((GrModifierList)modifierList).getAnnotations();
            AnnotationGenerator annotationGenerator = new AnnotationGenerator(builder, new ExpressionContext(modifierList.getProject(), GroovyFile.EMPTY_ARRAY));
            wasAddedModifiers = annotations.length > 0;
            for (GrAnnotation annotation : annotations) {
                annotation.accept(annotationGenerator);
                builder.append(' ');
            }
        }
        for (String modifierType : modifiers) {
            if (!modifierList.hasModifierProperty(modifierType)) continue;
            builder.append(modifierType);
            builder.append(' ');
            wasAddedModifiers = true;
        }
        return wasAddedModifiers;
    }

    public static void writeClassModifiers(StringBuilder text, @Nullable PsiModifierList modifierList, boolean isInterface, boolean isEnum, boolean toplevel, boolean generateAnnotations) {
        if (modifierList == null) {
            text.append("public ");
            return;
        }
        ArrayList<String> allowedModifiers = new ArrayList<String>();
        allowedModifiers.add("public");
        if (!isEnum) {
            allowedModifiers.add("final");
        }
        if (!toplevel) {
            allowedModifiers.addAll(Arrays.asList("protected", "private", "static"));
        }
        if (!isInterface && !isEnum) {
            allowedModifiers.add("abstract");
        }
        ModifierListGenerator.writeModifiers(text, modifierList, ArrayUtil.toStringArray(allowedModifiers), generateAnnotations);
    }
}

