/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GrExpressionWrapper
implements IntroduceParameterData.ExpressionWrapper {
    private final GrExpression myExpression;
    private final RangeMarker myMarker;
    private final PsiFile myFile;

    public GrExpressionWrapper(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrExpressionWrapper", "<init>"));
        }
        assert (expression.isValid());
        this.myExpression = expression;
        this.myFile = expression.getContainingFile();
        if (this.myFile.isPhysical()) {
            Document document = PsiDocumentManager.getInstance((Project)expression.getProject()).getDocument(this.myFile);
            assert (document != null);
            this.myMarker = document.createRangeMarker(this.myExpression.getTextRange());
        } else {
            this.myMarker = null;
        }
    }

    @NotNull
    public String getText() {
        String string = this.myExpression.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrExpressionWrapper", "getText"));
        }
        return string;
    }

    public PsiType getType() {
        return this.myExpression.getType();
    }

    @NotNull
    public GrExpression getExpression() {
        PsiElement at;
        if (this.myExpression.isValid()) {
            GrExpression grExpression = this.myExpression;
            if (grExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrExpressionWrapper", "getExpression"));
            }
            return grExpression;
        }
        if (this.myMarker != null && this.myMarker.isValid() && (at = this.myFile.findElementAt(this.myMarker.getStartOffset())) != null) {
            GrExpression grExpression = GroovyPsiElementFactory.getInstance(this.myFile.getProject()).createExpressionFromText(this.myExpression.getText(), at);
            if (grExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrExpressionWrapper", "getExpression"));
            }
            return grExpression;
        }
        GrExpression grExpression = GroovyPsiElementFactory.getInstance(this.myFile.getProject()).createExpressionFromText(this.myExpression.getText(), null);
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrExpressionWrapper", "getExpression"));
        }
        return grExpression;
    }
}

