/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.ui.ASGallery;
import com.android.tools.idea.wizard.template.TemplateWizardState;
import com.android.tools.idea.wizard.template.TemplateWizardStep;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateGalleryStep
extends TemplateWizardStep
implements ListSelectionListener {
    private final TemplateChangeListener myTemplateChangeListener;
    private JPanel myPanel;
    private JLabel myDescription;
    private JLabel myError;
    private ASGallery<MetadataListItem> myGallery;
    private JBScrollPane myGalleryScroller;
    private int myPreviousSelection = -1;

    public TemplateGalleryStep(TemplateWizardState state, String templateCategory, @Nullable Project project, @Nullable Module module, @Nullable Icon sidePanelIcon, TemplateWizardStep.UpdateListener updateListener, @Nullable TemplateChangeListener templateChangeListener) {
        this(state, templateCategory, project, module, sidePanelIcon, updateListener, templateChangeListener, null);
    }

    public TemplateGalleryStep(TemplateWizardState state, String templateCategory, @Nullable Project project, @Nullable Module module, @Nullable Icon sidePanelIcon, TemplateWizardStep.UpdateListener updateListener, @Nullable TemplateChangeListener templateChangeListener, @Nullable Set<String> excluded) {
        super(state, project, module, sidePanelIcon, updateListener);
        this.$$$setupUI$$$();
        this.myGallery.setImageProvider(new TemplateImageProvider());
        this.myGallery.setLabelProvider(new TemplateLabelProvider());
        this.myGallery.setThumbnailSize((Dimension)JBUI.size((int)256, (int)256));
        this.myTemplateChangeListener = templateChangeListener;
        if (templateCategory != null) {
            List<MetadataListItem> templates = TemplateGalleryStep.getTemplateList(state, templateCategory, excluded);
            this.setListData(templates);
            this.validate();
        }
    }

    protected static List<MetadataListItem> getTemplateList(TemplateWizardState state, String templateFolder, @Nullable Set<String> excluded) {
        TemplateManager manager = TemplateManager.getInstance();
        List<File> templates = manager.getTemplates(templateFolder);
        ArrayList<MetadataListItem> metadataList = new ArrayList<MetadataListItem>(templates.size());
        for (File template : templates) {
            Boolean isLauncher;
            TemplateMetadata metadata = manager.getTemplate(template);
            if (metadata == null || !metadata.isSupported() || (isLauncher = (Boolean)state.get("isLauncher")) != null && isLauncher.booleanValue() && metadata.getParameter("isLauncher") == null || excluded != null && excluded.contains(metadata.getTitle())) continue;
            metadataList.add(new MetadataListItem(template, metadata));
        }
        Collections.sort(metadataList);
        return metadataList;
    }

    private void createUIComponents() {
        this.myGalleryScroller = new JBScrollPane();
        this.myGalleryScroller.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    protected void setListData(List<MetadataListItem> metadataList) {
        this.myGallery.setModel(JBList.createDefaultListModel((Object[])ArrayUtil.toObjectArray(metadataList)));
        if (!metadataList.isEmpty()) {
            this.myGallery.setSelectedIndex(0);
        }
        this.myGallery.addListSelectionListener(this);
    }

    @Override
    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGallery;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.update();
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        this.setDescriptionHtml("");
        MetadataListItem templateListItem = this.getSelectedTemplate();
        if (templateListItem != null) {
            this.myTemplateState.setTemplateLocation(templateListItem.getTemplateFile());
            Template.convertApisToInt(this.myTemplateState.getParameters());
            this.setDescriptionHtml(templateListItem.myMetadata.getDescription());
            int minSdk = templateListItem.myMetadata.getMinSdk();
            Integer minApi = (Integer)this.myTemplateState.get("minApiLevel");
            if (minApi != null && minSdk > minApi) {
                this.setErrorHtml(String.format("The component %s has a minimum SDK level of %d.", templateListItem.myMetadata.getTitle(), minSdk));
                return false;
            }
            int minBuildApi = templateListItem.myMetadata.getMinBuildApi();
            Integer buildApi = (Integer)this.myTemplateState.get("buildApi");
            if (buildApi != null && minSdk > buildApi) {
                this.setErrorHtml(String.format("The component %s has a minimum build API level of %d.", templateListItem.myMetadata.getTitle(), minBuildApi));
                return false;
            }
            int index = this.myGallery.getSelectedIndex();
            if (this.myTemplateChangeListener != null && this.myPreviousSelection != index) {
                this.myPreviousSelection = index;
                this.myTemplateChangeListener.templateChanged(templateListItem.toString());
            }
        }
        return true;
    }

    @Nullable
    private MetadataListItem getSelectedTemplate() {
        return this.myGallery.getSelectedElement();
    }

    @Override
    @NotNull
    protected JLabel getDescription() {
        JLabel jLabel = this.myDescription;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/TemplateGalleryStep", "getDescription"));
        }
        return jLabel;
    }

    @Override
    @NotNull
    protected JLabel getError() {
        JLabel jLabel = this.myError;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/TemplateGalleryStep", "getError"));
        }
        return jLabel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 175), null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Description", 0, 0, null, null));
        this.myDescription = jLabel2 = new JLabel();
        jLabel2.setVerticalTextPosition(1);
        jLabel2.setText("");
        ((Component)jLabel2).setBackground(new Color(-1118482));
        jLabel2.setVerticalAlignment(1);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        this.myError = jLabel = new JLabel();
        jLabel.setVerticalTextPosition(3);
        jLabel.setText("");
        ((Component)jLabel).setBackground(new Color(-1118482));
        jLabel.setVerticalAlignment(3);
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        JBScrollPane jBScrollPane = this.myGalleryScroller;
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ASGallery aSGallery = new ASGallery();
        this.myGallery = aSGallery;
        jBScrollPane.setViewportView((Component)((Object)aSGallery));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static final class TemplateLabelProvider
    implements Function<MetadataListItem, String> {
        private TemplateLabelProvider() {
        }

        public String apply(MetadataListItem input) {
            return input.myMetadata.getTitle();
        }
    }

    private static final class TemplateImageProvider
    implements Function<MetadataListItem, Image> {
        private TemplateImageProvider() {
        }

        public Image apply(MetadataListItem input) {
            String thumb = input.myMetadata.getThumbnailPath();
            if (thumb != null && !thumb.isEmpty()) {
                try {
                    File file = new File(input.myTemplate, thumb.replace('/', File.separatorChar));
                    if (file.isFile()) {
                        return ImageIO.read(file);
                    }
                    return null;
                }
                catch (IOException e) {
                    Logger.getInstance(this.getClass()).warn((Throwable)e);
                }
            }
            return null;
        }
    }

    public static class MetadataListItem
    implements Comparable<MetadataListItem> {
        private TemplateMetadata myMetadata;
        private final File myTemplate;

        public MetadataListItem(@NotNull File template, @NotNull TemplateMetadata metadata) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/android/tools/idea/npw/TemplateGalleryStep$MetadataListItem", "<init>"));
            }
            if (metadata == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/npw/TemplateGalleryStep$MetadataListItem", "<init>"));
            }
            this.myTemplate = template;
            this.myMetadata = metadata;
        }

        public String toString() {
            return Strings.nullToEmpty((String)this.myMetadata.getTitle());
        }

        public File getTemplateFile() {
            return this.myTemplate;
        }

        @Override
        public int compareTo(@NotNull MetadataListItem other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/android/tools/idea/npw/TemplateGalleryStep$MetadataListItem", "compareTo"));
            }
            return StringUtil.naturalCompare((String)this.myMetadata.getTitle(), (String)other.myMetadata.getTitle());
        }
    }

    public static interface TemplateChangeListener {
        public void templateChanged(String var1);
    }
}

