/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class LabelForDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("LabelFor", "Missing `labelFor` attribute", "Text fields should be labelled with a `labelFor` attribute, provided your `minSdkVersion` is at least 17.\n\nIf your view is labeled but by a label in a different layout which includes this one, just suppress this warning from lint.", Category.A11Y, 2, Severity.WARNING, new Implementation(LabelForDetector.class, Scope.RESOURCE_FILE_SCOPE));
    private Set<String> mLabels;
    private List<Element> mTextFields;

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("labelFor");
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("EditText", "AutoCompleteTextView", "MultiAutoCompleteTextView");
    }

    @Override
    public void afterCheckFile(Context context) {
        if (this.mTextFields != null) {
            if (this.mLabels == null) {
                this.mLabels = Collections.emptySet();
            }
            for (Element element : this.mTextFields) {
                if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "hint")) continue;
                String id = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
                boolean missing = true;
                if (this.mLabels.contains(id)) {
                    missing = false;
                } else if (id.startsWith("@+id/")) {
                    missing = !this.mLabels.contains("@id/" + LintUtils.stripIdPrefix(id));
                } else if (id.startsWith("@id/")) {
                    boolean bl = missing = !this.mLabels.contains("@+id/" + LintUtils.stripIdPrefix(id));
                }
                if (!missing) continue;
                XmlContext xmlContext = (XmlContext)context;
                Location location = xmlContext.getLocation(element);
                String message = id == null || id.isEmpty() ? "No label views point to this text field with a `labelFor` attribute" : String.format("No label views point to this text field with an `android:labelFor=\"@+id/%1$s\"` attribute", id);
                xmlContext.report(ISSUE, element, location, message);
            }
        }
        this.mLabels = null;
        this.mTextFields = null;
    }

    @Override
    public void visitAttribute(XmlContext context, Attr attribute) {
        if (this.mLabels == null) {
            this.mLabels = Sets.newHashSet();
        }
        this.mLabels.add(attribute.getValue());
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        if (context.getMainProject().getMinSdk() < 17) {
            return;
        }
        if (this.mTextFields == null) {
            this.mTextFields = new ArrayList<Element>();
        }
        this.mTextFields.add(element);
    }
}

