/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.widgets;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import icons.ImagesIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import sun.awt.image.IntegerComponentRaster;

public class ImagePanel
extends JPanel {
    private static final int ZOOM_AMOUNT = 5;
    private static final int SCROLL_AMOUNT = 15;
    @NotNull
    private final ImageComponent myImage;

    public ImagePanel() {
        super(new BorderLayout());
        JBScrollPane scrollPane = new JBScrollPane();
        this.myImage = new ImageComponent(scrollPane);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        scrollPane.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        this.add((Component)scrollPane, "Center");
        this.setFocusable(true);
    }

    public void addToolbarActions(DefaultActionGroup group, boolean enableVerticalFlip) {
        this.myImage.addToolbarActions(group, enableVerticalFlip);
    }

    public StatusText getEmptyText() {
        return this.myImage.getEmptyText();
    }

    public void setImage(Image image) {
        this.myImage.setImage(image);
    }

    private static final class ImageComponent
    extends JComponent {
        private static final double ZOOM_FIT = Double.POSITIVE_INFINITY;
        private static final double MAX_ZOOM_FACTOR = 8.0;
        private static final double MIN_ZOOM_WIDTH = 100.0;
        private static final BufferedImage EMPTY_IMAGE = UIUtil.createImage((int)1, (int)1, (int)6);
        private static final int BORDER_SIZE = JBUI.scale((int)2);
        private static final Border BORDER = new LineBorder(JBColor.border(), BORDER_SIZE);
        private static final Paint CHECKER_PAINT = new CheckerboardPaint();
        private final JViewport parent;
        private final StatusText emptyText;
        private Image image = EMPTY_IMAGE;
        private double zoom;
        private boolean drawCheckerBoard = true;
        private boolean flipped = false;

        public ImageComponent(JBScrollPane scrollPane) {
            scrollPane.setViewportView((Component)this);
            this.parent = scrollPane.getViewport();
            this.emptyText = new StatusText(){

                protected boolean isStatusVisible() {
                    return image == EMPTY_IMAGE;
                }
            };
            this.emptyText.attachTo((Component)this.parent);
            this.zoom = Double.POSITIVE_INFINITY;
            MouseAdapter mouseHandler = new MouseAdapter(){
                private int lastX;
                private int lastY;

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    this.zoom(Math.max(-5, Math.min(5, e.getWheelRotation())), e.getPoint());
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.lastX = e.getX();
                    this.lastY = e.getY();
                    if (this.isPanningButton(e)) {
                        this.setCursor(new Cursor(13));
                    } else {
                        this.zoomToFit();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.setCursor(null);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    int dx = this.lastX - e.getX();
                    int dy = this.lastY - e.getY();
                    this.lastX = e.getX();
                    this.lastY = e.getY();
                    if (this.isPanningButton(e)) {
                        this.scrollBy(dx, dy);
                    }
                }

                private boolean isPanningButton(MouseEvent e) {
                    return (e.getModifiersEx() & 0xC00) != 0;
                }
            };
            this.parent.addMouseListener(mouseHandler);
            this.parent.addMouseWheelListener(mouseHandler);
            this.parent.addMouseMotionListener(mouseHandler);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 38: 
                        case 75: {
                            this.scrollBy(0, -15);
                            break;
                        }
                        case 40: 
                        case 74: {
                            this.scrollBy(0, 15);
                            break;
                        }
                        case 37: 
                        case 72: {
                            this.scrollBy(-15, 0);
                            break;
                        }
                        case 39: 
                        case 76: {
                            this.scrollBy(15, 0);
                            break;
                        }
                        case 107: 
                        case 521: {
                            this.zoom(-5, this.getCenterPoint());
                            break;
                        }
                        case 45: 
                        case 109: {
                            this.zoom(5, this.getCenterPoint());
                            break;
                        }
                        case 61: {
                            if ((e.getModifiersEx() & 0x40) != 0) {
                                this.zoom(-5, this.getCenterPoint());
                                break;
                            }
                            this.zoomToFit();
                        }
                    }
                }
            });
        }

        public StatusText getEmptyText() {
            return this.emptyText;
        }

        public void setImage(Image image) {
            if (this.image == EMPTY_IMAGE) {
                this.zoomToFit();
            }
            this.image = image == null ? EMPTY_IMAGE : image;
            this.revalidate();
            this.repaint();
        }

        public void addToolbarActions(DefaultActionGroup group, boolean enableVerticalFlip) {
            group.add(new AnAction("Zoom to Fit", "Fit the image to the panel", AndroidIcons.ZoomFit){

                public void actionPerformed(AnActionEvent e) {
                    this.zoomToFit();
                }
            });
            group.add(new AnAction("Actual Size", "Display the image at its actual size", AndroidIcons.ZoomActual){

                public void actionPerformed(AnActionEvent e) {
                    this.zoomToActual();
                }
            });
            group.add(new AnAction("Zoom In", "Zoom In", AndroidIcons.ZoomIn){

                public void actionPerformed(AnActionEvent e) {
                    this.zoom(-5, this.getCenterPoint());
                }
            });
            group.add(new AnAction("Zoom Out", "Zoom Out", AndroidIcons.ZoomOut){

                public void actionPerformed(AnActionEvent e) {
                    this.zoom(5, this.getCenterPoint());
                }
            });
            group.add((AnAction)new Separator());
            group.add((AnAction)new ToggleAction("Show Checkerboard", "Toggle the checkerboard background", ImagesIcons.ToggleTransparencyChessboard){

                public boolean isSelected(AnActionEvent e) {
                    return drawCheckerBoard;
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    drawCheckerBoard = state;
                    this.repaint();
                }
            });
            if (enableVerticalFlip) {
                group.add((AnAction)new ToggleAction("Flip Vertically", "Flip The image vertically", AndroidIcons.GfxTrace.FlipVertically){

                    public boolean isSelected(AnActionEvent e) {
                        return flipped;
                    }

                    public void setSelected(AnActionEvent e, boolean state) {
                        flipped = state;
                        this.repaint();
                    }
                });
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.zoom == Double.POSITIVE_INFINITY ? new Dimension(this.parent.getWidth(), this.parent.getHeight()) : new Dimension((int)(this.zoom * (double)this.image.getWidth(this)) + 2 * BORDER_SIZE, (int)(this.zoom * (double)this.image.getHeight(this)) + 2 * BORDER_SIZE);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image == EMPTY_IMAGE) {
                this.emptyText.paint((Component)this.parent, g);
                return;
            }
            double scale = this.zoom == Double.POSITIVE_INFINITY ? this.getFitRatio() : this.zoom;
            int w = (int)((double)this.image.getWidth(this) * scale);
            int h = (int)((double)this.image.getHeight(this) * scale);
            int x = (this.getWidth() - w) / 2;
            int y = (this.getHeight() - h) / 2;
            if (this.drawCheckerBoard) {
                ((Graphics2D)g).setPaint(CHECKER_PAINT);
                g.fillRect(x, y, w, h);
            }
            AffineTransform transform = ((Graphics2D)g).getTransform();
            if (this.flipped) {
                ((Graphics2D)g).transform(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, this.getHeight() - 1));
            }
            g.drawImage(this.image, x, y, w, h, this);
            ((Graphics2D)g).setTransform(transform);
            BORDER.paintBorder(this, g, x - BORDER_SIZE, y - BORDER_SIZE, w + 2 * BORDER_SIZE, h + 2 * BORDER_SIZE);
        }

        private void scrollBy(int dx, int dy) {
            if (dx == 0 && dy == 0) {
                this.revalidate();
                this.repaint();
            } else {
                this.parent.scrollRectToVisible(new Rectangle(new Point(dx, dy), this.parent.getExtentSize()));
            }
        }

        private Point getCenterPoint() {
            return new Point(this.parent.getWidth() / 2, this.parent.getHeight() / 2);
        }

        private void zoom(int amount, Point cursor) {
            Dimension oldSize = this.getPreferredSize();
            oldSize.setSize(Math.max(this.parent.getWidth(), oldSize.width), Math.max(this.parent.getHeight(), oldSize.height));
            if (this.zoom == Double.POSITIVE_INFINITY) {
                this.zoom = this.getFitRatio();
            }
            int delta = Math.min(Math.max(amount, -5), 5);
            this.zoom = Math.min(this.getMaxZoom(), Math.max(this.getMinZoom(), this.zoom * (1.0 - 0.05 * (double)delta)));
            this.invalidate();
            Dimension newSize = this.getPreferredSize();
            newSize.setSize(Math.max(this.parent.getWidth(), newSize.width), Math.max(this.parent.getHeight(), newSize.height));
            Point pos = this.parent.getViewPosition();
            pos.translate(cursor.x, cursor.y);
            this.scrollBy(pos.x * newSize.width / oldSize.width - pos.x, pos.y * newSize.height / oldSize.height - pos.y);
        }

        private void zoomToFit() {
            this.zoom = Double.POSITIVE_INFINITY;
            this.revalidate();
            this.repaint();
        }

        private void zoomToActual() {
            this.zoom = 1.0;
            this.revalidate();
            this.repaint();
        }

        private double getFitRatio() {
            return Math.min((double)(this.getWidth() - 2 * BORDER_SIZE) / (double)this.image.getWidth(this), (double)(this.getHeight() - 2 * BORDER_SIZE) / (double)this.image.getHeight(this));
        }

        private double getMinZoom() {
            return Math.min(1.0, Math.min(this.getFitRatio(), Math.min(100.0 / (double)this.image.getWidth(this), 100.0 / (double)this.image.getHeight(this))));
        }

        private double getMaxZoom() {
            return Math.max(8.0, this.getFitRatio());
        }

        private static class CheckerboardPaint
        implements Paint,
        PaintContext {
            private static final int CHECKER_SIZE = JBUI.scale((int)15);
            private static final int TWO_CHECKER_SIZE = 2 * CHECKER_SIZE;
            private static final int LIGHT_COLOR = -1;
            private static final int DARK_COLOR = -4144960;
            private WritableRaster cachedRaster;
            private int[] cachedEvenRow = new int[0];
            private int[] cachedOddRow = new int[0];

            private CheckerboardPaint() {
            }

            @Override
            public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
                return this;
            }

            @Override
            public void dispose() {
                this.cachedRaster = null;
            }

            @Override
            public ColorModel getColorModel() {
                return ColorModel.getRGBdefault();
            }

            @Override
            public Raster getRaster(int x, int y, int w, int h) {
                WritableRaster raster = this.cachedRaster;
                if (raster == null || w > raster.getWidth() || h > raster.getHeight()) {
                    this.cachedRaster = raster = this.getColorModel().createCompatibleWritableRaster(w, h);
                }
                w = raster.getWidth();
                h = raster.getHeight();
                int xOffset = x % TWO_CHECKER_SIZE;
                int yOffset = y % TWO_CHECKER_SIZE;
                int[] evenRow = this.cachedEvenRow;
                int[] oddRow = this.cachedOddRow;
                if (evenRow.length < xOffset + w || oddRow.length < xOffset + w) {
                    evenRow = new int[TWO_CHECKER_SIZE * ((xOffset + w + TWO_CHECKER_SIZE - 1) / TWO_CHECKER_SIZE)];
                    oddRow = new int[evenRow.length];
                    for (int i = 0; i < evenRow.length; i += TWO_CHECKER_SIZE) {
                        Arrays.fill(evenRow, i, i + CHECKER_SIZE, -1);
                        Arrays.fill(evenRow, i + CHECKER_SIZE, i + TWO_CHECKER_SIZE, -4144960);
                        Arrays.fill(oddRow, i, i + CHECKER_SIZE, -4144960);
                        Arrays.fill(oddRow, i + CHECKER_SIZE, i + TWO_CHECKER_SIZE, -1);
                    }
                }
                int[] pixels = ((IntegerComponentRaster)raster).getDataStorage();
                int[][] rows = new int[][]{evenRow, oddRow};
                int curRowPointer = yOffset < CHECKER_SIZE ? 0 : 1;
                int[] curRow = rows[curRowPointer];
                int i = 0;
                int done = 0;
                int tileY = yOffset % CHECKER_SIZE;
                while (i < h) {
                    if (tileY >= CHECKER_SIZE) {
                        tileY = 0;
                        curRowPointer = curRowPointer + 1 & 1;
                        curRow = rows[curRowPointer];
                    }
                    System.arraycopy(curRow, xOffset, pixels, done, w);
                    ++i;
                    ++tileY;
                    done += w;
                }
                return raster;
            }

            @Override
            public int getTransparency() {
                return 1;
            }
        }
    }
}

