/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.KotlinCompletionCharFilter;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KotlinCompletionCharFilter;", "Lcom/intellij/codeInsight/lookup/CharFilter;", "()V", "acceptChar", "Lcom/intellij/codeInsight/lookup/CharFilter$Result;", "c", "", "prefixLength", "", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "isInFunctionLiteralStart", "", "position", "Lcom/intellij/psi/PsiElement;", "Companion", "idea-completion"})
public final class KotlinCompletionCharFilter
extends CharFilter {
    @NotNull
    private static final Key<Unit> ACCEPT_OPENING_BRACE;
    @NotNull
    private static final Key<Unit> SUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING;
    @NotNull
    private static final Key<Unit> HIDE_LOOKUP_ON_COLON;
    @NotNull
    private static final Key<String> JUST_TYPING_PREFIX;
    public static final Companion Companion;

    @Nullable
    public CharFilter.Result acceptChar(char c, int prefixLength, @NotNull Lookup lookup) {
        CharFilter.Result result2;
        LookupElement currentItem;
        boolean isAutopopup;
        block18: {
            block19: {
                Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
                if (!(lookup.getPsiFile() instanceof KtFile)) {
                    return null;
                }
                if (!lookup.isCompletion()) {
                    return null;
                }
                CompletionProcess completionProcess = CompletionService.getCompletionService().getCurrentCompletion();
                if (completionProcess == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.completion.CompletionProgressIndicator");
                }
                CompletionParameters completionParameters = ((CompletionProgressIndicator)completionProcess).getParameters();
                boolean bl = isAutopopup = completionParameters.getInvocationCount() == 0;
                if (Character.isJavaIdentifierPart(c) || c == '@') {
                    return CharFilter.Result.ADD_TO_PREFIX;
                }
                currentItem = lookup.getCurrentItem();
                if (!isAutopopup || lookup.isSelectionTouched()) break block18;
                LookupElement lookupElement2 = currentItem;
                if ((lookupElement2 != null ? (Unit)lookupElement2.getUserData(Companion.getSUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING()) : null) != null) break block19;
                PsiElement psiElement = completionParameters.getPosition();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"completionParameters.position");
                if (!this.isInFunctionLiteralStart(psiElement)) break block18;
            }
            return CharFilter.Result.HIDE_LOOKUP;
        }
        if (c == ':') {
            LookupElement lookupElement3 = currentItem;
            return (lookupElement3 != null ? (Unit)lookupElement3.getUserData(Companion.getHIDE_LOOKUP_ON_COLON()) : null) != null ? CharFilter.Result.HIDE_LOOKUP : CharFilter.Result.ADD_TO_PREFIX;
        }
        if (!lookup.isSelectionTouched()) {
            Unit unit;
            LookupElement lookupElement4 = currentItem;
            if (lookupElement4 != null) {
                CompletionUtilsKt.putUserDataDeep(lookupElement4, Companion.getJUST_TYPING_PREFIX(), lookup.itemPattern(currentItem));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        switch (c) {
            case '.': {
                int caret;
                if (prefixLength == 0 && isAutopopup && !lookup.isSelectionTouched() && (caret = lookup.getEditor().getCaretModel().getOffset()) > 0 && lookup.getEditor().getDocument().getCharsSequence().charAt(caret - 1) == '.') {
                    return CharFilter.Result.HIDE_LOOKUP;
                }
                result2 = CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                break;
            }
            case '{': {
                if (currentItem != null && currentItem.getUserData(Companion.getACCEPT_OPENING_BRACE()) != null) {
                    result2 = CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                    break;
                }
                result2 = CharFilter.Result.HIDE_LOOKUP;
                break;
            }
            case ' ': 
            case '!': 
            case '(': 
            case ',': 
            case '=': {
                result2 = CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                break;
            }
            default: {
                result2 = CharFilter.Result.HIDE_LOOKUP;
            }
        }
        return result2;
    }

    private final boolean isInFunctionLiteralStart(PsiElement position) {
        PsiElement psiElement;
        PsiElement psiElement2;
        PsiElement prev2 = PsiUtilsKt.prevLeaf(position, (Function1<? super PsiElement, Boolean>)((Function1)isInFunctionLiteralStart.prev.1.INSTANCE));
        PsiElement psiElement3 = prev2;
        if (Intrinsics.areEqual((Object)(psiElement3 != null && (psiElement3 = psiElement3.getNode()) != null ? psiElement3.getElementType() : null), (Object)((Object)KtTokens.LPAR))) {
            PsiElement psiElement4 = prev2;
            prev2 = psiElement4 != null ? PsiUtilsKt.prevLeaf(psiElement4, (Function1<? super PsiElement, Boolean>)((Function1)isInFunctionLiteralStart.1.INSTANCE)) : null;
        }
        if (Intrinsics.areEqual((Object)((psiElement2 = prev2) != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null), (Object)((Object)KtTokens.LBRACE)) ^ true) {
            return false;
        }
        PsiElement psiElement5 = prev2;
        if (psiElement5 == null) {
            Intrinsics.throwNpe();
        }
        if (!((psiElement = psiElement5.getParent()) instanceof KtFunctionLiteral)) {
            psiElement = null;
        }
        KtFunctionLiteral ktFunctionLiteral = (KtFunctionLiteral)psiElement;
        if (ktFunctionLiteral == null) {
            return false;
        }
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        return Intrinsics.areEqual((Object)functionLiteral.getLBrace(), (Object)prev2);
    }

    static {
        Companion = new Companion(null);
        ACCEPT_OPENING_BRACE = new Key("KotlinCompletionCharFilter.ACCEPT_OPENING_BRACE");
        SUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING = new Key("KotlinCompletionCharFilter.SUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING");
        HIDE_LOOKUP_ON_COLON = new Key("KotlinCompletionCharFilter.HIDE_LOOKUP_ON_COLON");
        JUST_TYPING_PREFIX = new Key("KotlinCompletionCharFilter.JUST_TYPING_PREFIX");
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KotlinCompletionCharFilter$Companion;", "", "()V", "ACCEPT_OPENING_BRACE", "Lcom/intellij/openapi/util/Key;", "", "getACCEPT_OPENING_BRACE", "()Lcom/intellij/openapi/util/Key;", "HIDE_LOOKUP_ON_COLON", "getHIDE_LOOKUP_ON_COLON", "JUST_TYPING_PREFIX", "", "getJUST_TYPING_PREFIX", "SUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING", "getSUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING", "idea-completion"})
    public static final class Companion {
        @NotNull
        public final Key<Unit> getACCEPT_OPENING_BRACE() {
            return ACCEPT_OPENING_BRACE;
        }

        @NotNull
        public final Key<Unit> getSUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING() {
            return SUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING;
        }

        @NotNull
        public final Key<Unit> getHIDE_LOOKUP_ON_COLON() {
            return HIDE_LOOKUP_ON_COLON;
        }

        @NotNull
        public final Key<String> getJUST_TYPING_PREFIX() {
            return JUST_TYPING_PREFIX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

