/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.sam;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.sam.SamAdapterFunctionDescriptor;
import org.jetbrains.kotlin.resolve.ExternalOverridabilityCondition;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;

public class SamAdapterOverridabilityCondition
implements ExternalOverridabilityCondition {
    @Override
    @NotNull
    public ExternalOverridabilityCondition.Result isOverridable(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor, @Nullable ClassDescriptor subClassDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superDescriptor", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition", "isOverridable"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDescriptor", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition", "isOverridable"));
        }
        if (!(subDescriptor instanceof SimpleFunctionDescriptor) || !(superDescriptor instanceof SimpleFunctionDescriptor)) {
            ExternalOverridabilityCondition.Result result2 = ExternalOverridabilityCondition.Result.UNKNOWN;
            if (result2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition", "isOverridable"));
            }
            return result2;
        }
        SimpleFunctionDescriptor superOriginal = SamAdapterOverridabilityCondition.getOriginalOfSamAdapterFunction((SimpleFunctionDescriptor)superDescriptor);
        SimpleFunctionDescriptor subOriginal = SamAdapterOverridabilityCondition.getOriginalOfSamAdapterFunction((SimpleFunctionDescriptor)subDescriptor);
        if (superOriginal == null || subOriginal == null) {
            ExternalOverridabilityCondition.Result result3 = subOriginal == null ? ExternalOverridabilityCondition.Result.UNKNOWN : ExternalOverridabilityCondition.Result.INCOMPATIBLE;
            if (result3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition", "isOverridable"));
            }
            return result3;
        }
        ExternalOverridabilityCondition.Result result4 = SamAdapterOverridabilityCondition.equalErasure(superOriginal, subOriginal) ? ExternalOverridabilityCondition.Result.UNKNOWN : ExternalOverridabilityCondition.Result.INCOMPATIBLE;
        if (result4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition", "isOverridable"));
        }
        return result4;
    }

    @Override
    @NotNull
    public ExternalOverridabilityCondition.Contract getContract() {
        ExternalOverridabilityCondition.Contract contract = ExternalOverridabilityCondition.Contract.CONFLICTS_ONLY;
        if (contract == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition", "getContract"));
        }
        return contract;
    }

    private static boolean equalErasure(@NotNull FunctionDescriptor fun1, @NotNull FunctionDescriptor fun2) {
        if (fun1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun1", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition", "equalErasure"));
        }
        if (fun2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun2", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition", "equalErasure"));
        }
        List<ValueParameterDescriptor> parameters1 = fun1.getValueParameters();
        List<ValueParameterDescriptor> parameters2 = fun2.getValueParameters();
        for (ValueParameterDescriptor param1 : parameters1) {
            ValueParameterDescriptor param2 = parameters2.get(param1.getIndex());
            if (!SamAdapterOverridabilityCondition.differentClasses(param2.getType(), param1.getType())) continue;
            return false;
        }
        return true;
    }

    private static boolean differentClasses(@NotNull KotlinType type1, @NotNull KotlinType type2) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition", "differentClasses"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition", "differentClasses"));
        }
        ClassifierDescriptor declarationDescriptor1 = type1.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor1 == null) {
            return true;
        }
        ClassifierDescriptor declarationDescriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor2 == null) {
            return true;
        }
        if (declarationDescriptor1 instanceof TypeParameterDescriptor && declarationDescriptor2 instanceof TypeParameterDescriptor) {
            return false;
        }
        return !declarationDescriptor1.getOriginal().equals(declarationDescriptor2.getOriginal());
    }

    @Nullable
    private static SimpleFunctionDescriptor getOriginalOfSamAdapterFunction(@NotNull SimpleFunctionDescriptor callable) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition", "getOriginalOfSamAdapterFunction"));
        }
        if (callable.getDispatchReceiverParameter() != null) {
            return null;
        }
        DeclarationDescriptor containingDeclaration = callable.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return null;
        }
        SamAdapterInfo declarationOrSynthesized = SamAdapterOverridabilityCondition.getNearestDeclarationOrSynthesized(callable, ((ClassDescriptor)containingDeclaration).getDefaultType());
        if (declarationOrSynthesized == null) {
            return null;
        }
        SimpleFunctionDescriptorImpl fun = (SimpleFunctionDescriptorImpl)declarationOrSynthesized.samAdapter.getOriginal();
        if (!(fun instanceof SamAdapterFunctionDescriptor)) {
            return null;
        }
        JavaMethodDescriptor originalDeclarationOfSam = ((SamAdapterFunctionDescriptor)fun).getOriginForSam();
        return (SimpleFunctionDescriptor)originalDeclarationOfSam.substitute(TypeSubstitutor.create(declarationOrSynthesized.ownerType));
    }

    @Nullable
    private static SamAdapterInfo getNearestDeclarationOrSynthesized(@NotNull SimpleFunctionDescriptor samAdapter, @NotNull KotlinType ownerType) {
        if (samAdapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samAdapter", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition", "getNearestDeclarationOrSynthesized"));
        }
        if (ownerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerType", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition", "getNearestDeclarationOrSynthesized"));
        }
        if (samAdapter.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            return new SamAdapterInfo(samAdapter, ownerType);
        }
        for (FunctionDescriptor functionDescriptor : samAdapter.getOriginal().getOverriddenDescriptors()) {
            ClassDescriptor containingClass = (ClassDescriptor)functionDescriptor.getContainingDeclaration();
            for (KotlinType immediateSupertype : TypeUtils.getImmediateSupertypes(ownerType)) {
                SamAdapterInfo found;
                if (containingClass != immediateSupertype.getConstructor().getDeclarationDescriptor() || (found = SamAdapterOverridabilityCondition.getNearestDeclarationOrSynthesized((SimpleFunctionDescriptor)functionDescriptor, immediateSupertype)) == null) continue;
                return found;
            }
        }
        return null;
    }

    private static class SamAdapterInfo {
        private final SimpleFunctionDescriptor samAdapter;
        private final KotlinType ownerType;

        private SamAdapterInfo(@NotNull SimpleFunctionDescriptor samAdapter, @NotNull KotlinType ownerType) {
            if (samAdapter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samAdapter", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition$SamAdapterInfo", "<init>"));
            }
            if (ownerType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerType", "org/jetbrains/kotlin/load/java/sam/SamAdapterOverridabilityCondition$SamAdapterInfo", "<init>"));
            }
            this.samAdapter = samAdapter;
            this.ownerType = ownerType;
        }
    }
}

