/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.write;

import java.io.IOException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.formats.tiff.constants.TagInfo;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldTypeASCII;
import org.apache.sanselan.formats.tiff.write.TiffOutputItem;

public class TiffOutputField
implements TiffConstants {
    public final int tag;
    public final TagInfo tagInfo;
    public final FieldType fieldType;
    public final int count;
    private byte[] bytes;
    private final TiffOutputItem.Value separateValueItem;
    private int sortHint = -1;
    private static final String newline = System.getProperty("line.separator");

    public TiffOutputField(TagInfo tagInfo, FieldType tagtype, int count, byte[] bytes) {
        this(tagInfo.tag, tagInfo, tagtype, count, bytes);
    }

    public TiffOutputField(int tag, TagInfo tagInfo, FieldType fieldType, int count, byte[] bytes) {
        this.tag = tag;
        this.tagInfo = tagInfo;
        this.fieldType = fieldType;
        this.count = count;
        this.bytes = bytes;
        if (this.isLocalValue()) {
            this.separateValueItem = null;
        } else {
            String name = "Field Seperate value (" + tagInfo.getDescription() + ")";
            this.separateValueItem = new TiffOutputItem.Value(name, bytes);
        }
    }

    public static TiffOutputField create(TagInfo tagInfo, int byteOrder, Number number) throws ImageWriteException {
        if (tagInfo.dataTypes == null || tagInfo.dataTypes.length < 1) {
            throw new ImageWriteException("Tag has no default data type.");
        }
        FieldType fieldType = tagInfo.dataTypes[0];
        if (tagInfo.length != 1) {
            throw new ImageWriteException("Tag does not expect a single value.");
        }
        byte[] bytes = fieldType.writeData(number, byteOrder);
        return new TiffOutputField(tagInfo.tag, tagInfo, fieldType, 1, bytes);
    }

    public static TiffOutputField create(TagInfo tagInfo, int byteOrder, Number[] value) throws ImageWriteException {
        if (tagInfo.dataTypes == null || tagInfo.dataTypes.length < 1) {
            throw new ImageWriteException("Tag has no default data type.");
        }
        FieldType fieldType = tagInfo.dataTypes[0];
        if (tagInfo.length != value.length) {
            throw new ImageWriteException("Tag does not expect a single value.");
        }
        byte[] bytes = fieldType.writeData(value, byteOrder);
        return new TiffOutputField(tagInfo.tag, tagInfo, fieldType, value.length, bytes);
    }

    public static TiffOutputField create(TagInfo tagInfo, int byteOrder, String value) throws ImageWriteException {
        FieldTypeASCII fieldType;
        if (tagInfo.dataTypes == null) {
            fieldType = FIELD_TYPE_ASCII;
        } else if (tagInfo.dataTypes == FIELD_TYPE_DESCRIPTION_ASCII) {
            fieldType = FIELD_TYPE_ASCII;
        } else {
            throw new ImageWriteException("Tag has unexpected data type.");
        }
        byte[] bytes = ((FieldType)fieldType).writeData(value, byteOrder);
        return new TiffOutputField(tagInfo.tag, tagInfo, fieldType, 1, bytes);
    }

    protected static final TiffOutputField createOffsetField(TagInfo tagInfo, int byteOrder) throws ImageWriteException {
        return new TiffOutputField(tagInfo, FIELD_TYPE_LONG, 1, FIELD_TYPE_LONG.writeData(new int[]{0}, byteOrder));
    }

    protected void writeField(BinaryOutputStream bos) throws IOException, ImageWriteException {
        bos.write2Bytes(this.tag);
        bos.write2Bytes(this.fieldType.type);
        bos.write4Bytes(this.count);
        if (this.isLocalValue()) {
            if (this.separateValueItem != null) {
                throw new ImageWriteException("Unexpected separate value item.");
            }
            if (this.bytes.length > 4) {
                throw new ImageWriteException("Local value has invalid length: " + this.bytes.length);
            }
            bos.writeByteArray(this.bytes);
            int remainder = 4 - this.bytes.length;
            for (int i = 0; i < remainder; ++i) {
                bos.write(0);
            }
        } else {
            if (this.separateValueItem == null) {
                throw new ImageWriteException("Missing separate value item.");
            }
            bos.write4Bytes(this.separateValueItem.getOffset());
        }
    }

    protected TiffOutputItem getSeperateValue() {
        return this.separateValueItem;
    }

    protected boolean isLocalValue() {
        return this.bytes.length <= 4;
    }

    protected void setData(byte[] bytes) throws ImageWriteException {
        if (this.bytes.length != bytes.length) {
            throw new ImageWriteException("Cannot change size of value.");
        }
        this.bytes = bytes;
        if (this.separateValueItem != null) {
            this.separateValueItem.updateValue(bytes);
        }
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        StringBuffer result = new StringBuffer();
        result.append(prefix);
        result.append(this.tagInfo);
        result.append(newline);
        result.append(prefix);
        result.append("count: " + this.count);
        result.append(newline);
        result.append(prefix);
        result.append(this.fieldType);
        result.append(newline);
        return result.toString();
    }

    public int getSortHint() {
        return this.sortHint;
    }

    public void setSortHint(int sortHint) {
        this.sortHint = sortHint;
    }
}

